/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.entity.basic.Sanitizer;
import brooklyn.location.jclouds.ComputeServiceRegistryImpl;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.util.collections.MutableList;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.Protocol;
import brooklyn.util.ssh.IptablesCommands;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.predicates.OperatingSystemPredicates;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.domain.Container;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.PasswordDataAndPrivateKey;
import org.jclouds.ec2.compute.functions.WindowsLoginCredentialsFromEncryptedData;
import org.jclouds.ec2.domain.PasswordData;
import org.jclouds.ec2.features.WindowsApi;
import org.jclouds.encryption.bouncycastle.config.BouncyCastleCryptoModule;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Predicates2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsUtil
implements JcloudsLocationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsUtil.class);
    @Deprecated
    public static String APT_INSTALL = "apt-get install -f -y -qq --force-yes";
    @Deprecated
    public static final Statement APT_RUN_SCRIPT = Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)JcloudsUtil.installAfterUpdatingIfNotPresent("curl")), Statements.exec((String)"(which java && java -fullversion 2>&1|egrep -q 1.6 ) ||"), ComputeServiceUtils.execHttpResponse((URI)URI.create("http://whirr.s3.amazonaws.com/0.2.0-incubating-SNAPSHOT/sun/java/install")), Statements.exec((String)("echo nameserver 208.67.222.222 >> /etc/resolv.conf\n" + "rm -rf /var/cache/apt /usr/lib/vmware-tools\n" + "echo \"export PATH=\\\"$JAVA_HOME/bin/:$PATH\\\"\" >> /root/.bashrc"))});
    @Deprecated
    public static final Statement YUM_RUN_SCRIPT = Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)"which curl ||yum --nogpgcheck -y install curl"), Statements.exec((String)"(which java && java -fullversion 2>&1|egrep -q 1.6 ) ||"), ComputeServiceUtils.execHttpResponse((URI)URI.create("http://whirr.s3.amazonaws.com/0.2.0-incubating-SNAPSHOT/sun/java/install")), Statements.exec((String)("echo nameserver 208.67.222.222 >> /etc/resolv.conf\n" + "echo \"export PATH=\\\"$JAVA_HOME/bin/:$PATH\\\"\" >> /root/.bashrc"))});
    @Deprecated
    public static final Statement ZYPPER_RUN_SCRIPT = Statements.exec((String)("echo nameserver 208.67.222.222 >> /etc/resolv.conf\n" + "which curl || zypper install curl\n" + "(which java && java -fullversion 2>&1|egrep -q 1.6 ) || zypper install java-1.6.0-openjdk\n"));

    @Deprecated
    public static String installAfterUpdatingIfNotPresent(String cmd) {
        String aptInstallCmd = APT_INSTALL + " " + cmd;
        return String.format("which %s || (%s || (apt-get update && %s))", cmd, aptInstallCmd, aptInstallCmd);
    }

    @Deprecated
    public static Predicate<NodeMetadata> predicateMatchingById(NodeMetadata node) {
        return JcloudsUtil.predicateMatchingById(node.getId());
    }

    @Deprecated
    public static Predicate<NodeMetadata> predicateMatchingById(final String id) {
        Predicate<NodeMetadata> nodePredicate = new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata arg0) {
                return id.equals(arg0.getId());
            }

            public String toString() {
                return "node.id==" + id;
            }
        };
        return nodePredicate;
    }

    @Deprecated
    public static Statement authorizePortInIpTables(int port) {
        return Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)("iptables -I INPUT 1 -p tcp --dport " + port + " -j ACCEPT")), Statements.exec((String)("iptables -I RH-Firewall-1-INPUT 1 -p tcp --dport " + port + " -j ACCEPT")), Statements.exec((String)"iptables-save")});
    }

    @Deprecated
    public static ExecResponse runScriptOnNode(ComputeService computeService, NodeMetadata node, Statement statement, String scriptName) throws RunScriptOnNodesException {
        Map scriptResults = computeService.runScriptOnNodesMatching(JcloudsUtil.predicateMatchingById(node), statement, new RunScriptOptions().nameTask(scriptName));
        if (scriptResults.isEmpty()) {
            throw new IllegalStateException("No matching node found when executing script " + scriptName + ": expected=" + node);
        }
        if (scriptResults.size() > 1) {
            throw new IllegalStateException("Multiple nodes matched predicate: id=" + node.getId() + "; expected=" + node + "; actual=" + scriptResults.keySet());
        }
        return (ExecResponse)Iterables.getOnlyElement(scriptResults.values());
    }

    @Deprecated
    public static Statement installJavaAndCurl(OperatingSystem os) {
        if (os == null || OperatingSystemPredicates.supportsApt().apply((Object)os)) {
            return APT_RUN_SCRIPT;
        }
        if (OperatingSystemPredicates.supportsYum().apply((Object)os)) {
            return YUM_RUN_SCRIPT;
        }
        if (OperatingSystemPredicates.supportsZypper().apply((Object)os)) {
            return ZYPPER_RUN_SCRIPT;
        }
        throw new IllegalArgumentException("don't know how to handle" + os.toString());
    }

    @Deprecated
    public static ComputeService findComputeService(ConfigBag conf) {
        return ComputeServiceRegistryImpl.INSTANCE.findComputeService(conf, true);
    }

    @Deprecated
    public static ComputeService findComputeService(ConfigBag conf, boolean allowReuse) {
        return ComputeServiceRegistryImpl.INSTANCE.findComputeService(conf, allowReuse);
    }

    @Deprecated
    public static ImmutableSet<Module> getCommonModules() {
        return ImmutableSet.of((Object)new SshjSshClientModule(), (Object)new SLF4JLoggingModule(), (Object)new BouncyCastleCryptoModule());
    }

    @Beta
    public static BlobStoreContext newBlobstoreContext(String provider, @Nullable String endpoint, String identity, String credential) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.strip-expect-header", "true");
        ContextBuilder contextBuilder = ContextBuilder.newBuilder((String)provider).credentials(identity, credential);
        contextBuilder.modules((Iterable)MutableList.copyOf(JcloudsUtil.getCommonModules()));
        if (!Strings.isBlank((CharSequence)endpoint)) {
            contextBuilder.endpoint(endpoint);
        }
        contextBuilder.overrides(overrides);
        BlobStoreContext context = (BlobStoreContext)contextBuilder.buildView(BlobStoreContext.class);
        return context;
    }

    @Deprecated
    protected static String getDeprecatedProperty(ConfigBag conf, String key) {
        if (conf.containsKey(key)) {
            LOG.warn("Jclouds using deprecated brooklyn-jclouds property " + key + ": " + Sanitizer.sanitize((Map)conf.getAllConfig()));
            return (String)conf.getStringKey(key);
        }
        return null;
    }

    @Deprecated
    public static Statement addAuthorizedKeysToRoot(File publicKeyFile) throws IOException {
        String publicKey = Files.toString((File)publicKeyFile, (Charset)Charsets.UTF_8);
        return JcloudsUtil.addAuthorizedKeysToRoot(publicKey);
    }

    @Deprecated
    public static Statement addAuthorizedKeysToRoot(String publicKey) {
        return Statements.newStatementList((Statement[])new Statement[]{Statements.appendFile((String)"/root/.ssh/authorized_keys", (Iterable)Splitter.on((char)'\n').split((CharSequence)publicKey)), Statements.interpret((String[])new String[]{"chmod 600 /root/.ssh/authorized_keys"})});
    }

    public static String getFirstReachableAddress(ComputeServiceContext context, NodeMetadata node) {
        SshClient client;
        try {
            client = (SshClient)context.utils().sshForNode().apply((Object)node);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Unable to connect SshClient to " + node + "; check that the node is accessible and that the SSH key exists and is correctly configured, including any passphrase defined", e);
        }
        return client.getHostAddress();
    }

    public static String waitForPasswordOnAws(ComputeService computeService, NodeMetadata node, long timeout, TimeUnit timeUnit) throws TimeoutException {
        ComputeServiceContext computeServiceContext = computeService.getContext();
        AWSEC2Api ec2Client = (AWSEC2Api)computeServiceContext.unwrapApi(AWSEC2Api.class);
        final WindowsApi client = (WindowsApi)ec2Client.getWindowsApi().get();
        final String region = node.getLocation().getParent().getId();
        Predicate<String> passwordReady = new Predicate<String>(){

            public boolean apply(String s) {
                if (com.google.common.base.Strings.isNullOrEmpty((String)s)) {
                    return false;
                }
                PasswordData data = client.getPasswordDataInRegion(region, s);
                if (data == null) {
                    return false;
                }
                return !com.google.common.base.Strings.isNullOrEmpty((String)data.getPasswordData());
            }
        };
        LOG.info("Waiting for password, for " + node.getProviderId() + ":" + node.getId());
        Predicate passwordReadyRetryable = Predicates2.retry((Predicate)passwordReady, (long)timeUnit.toMillis(timeout), (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        boolean ready = passwordReadyRetryable.apply((Object)node.getProviderId());
        if (!ready) {
            throw new TimeoutException("Password not available for " + node + " in region " + region + " after " + timeout + " " + timeUnit.name());
        }
        PasswordDataAndPrivateKey dataAndKey = new PasswordDataAndPrivateKey(client.getPasswordDataInRegion(region, node.getProviderId()), node.getCredentials().getPrivateKey());
        WindowsLoginCredentialsFromEncryptedData f = (WindowsLoginCredentialsFromEncryptedData)computeServiceContext.utils().injector().getInstance(WindowsLoginCredentialsFromEncryptedData.class);
        LoginCredentials credentials = f.apply(dataAndKey);
        return credentials.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Integer> dockerPortMappingsFor(JcloudsLocation docker, String containerId) {
        ComputeServiceContext context = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("jclouds.trust-all-certs", Boolean.toString(true));
            properties.setProperty("jclouds.relax-hostname", Boolean.toString(true));
            context = (ComputeServiceContext)ContextBuilder.newBuilder((String)"docker").endpoint(docker.getEndpoint()).credentials(docker.getIdentity(), docker.getCredential()).overrides(properties).modules((Iterable)ImmutableSet.of((Object)new SLF4JLoggingModule(), (Object)new SshjSshClientModule())).build(ComputeServiceContext.class);
            DockerApi api = (DockerApi)context.unwrapApi(DockerApi.class);
            Container container = api.getContainerApi().inspectContainer(containerId);
            LinkedHashMap portMappings = Maps.newLinkedHashMap();
            Map ports = container.networkSettings().ports();
            if (ports == null) {
                ports = ImmutableMap.of();
            }
            LOG.debug("Docker will forward these ports {}", (Object)ports);
            for (Map.Entry entrySet : ports.entrySet()) {
                String containerPort = (String)Iterables.get((Iterable)Splitter.on((String)"/").split((CharSequence)entrySet.getKey()), (int)0);
                String hostPort = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)((Iterable)entrySet.getValue()), (Function)new Function<Map<String, String>, String>(){

                    public String apply(Map<String, String> hostIpAndPort) {
                        return hostIpAndPort.get("HostPort");
                    }
                }));
                portMappings.put(Integer.parseInt(containerPort), Integer.parseInt(hostPort));
            }
            LinkedHashMap linkedHashMap = portMappings;
            return linkedHashMap;
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Deprecated
    public static void mapSecurityGroupRuleToIpTables(ComputeService computeService, NodeMetadata node, LoginCredentials credentials, String networkInterface, Iterable<Integer> ports) {
        for (Integer port : ports) {
            String insertIptableRule = IptablesCommands.insertIptablesRule((IptablesCommands.Chain)IptablesCommands.Chain.INPUT, (String)networkInterface, (Protocol)Protocol.TCP, (int)port, (IptablesCommands.Policy)IptablesCommands.Policy.ACCEPT);
            Statement statement = Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)insertIptableRule)});
            ExecResponse response = computeService.runScriptOnNode(node.getId(), statement, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(false));
            if (response.getExitStatus() == 0) continue;
            String msg = String.format("Cannot insert the iptables rule for port %d. Error: %s", port, response.getError());
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
    }
}

