/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.location.HardwareDetails;
import brooklyn.location.MachineDetails;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.BasicHardwareDetails;
import brooklyn.location.basic.BasicMachineDetails;
import brooklyn.location.basic.BasicOsDetails;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsMachineLocation;
import brooklyn.location.jclouds.JcloudsUtil;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Networking;
import brooklyn.util.text.Strings;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.InterpretableStatement;
import org.jclouds.scriptbuilder.domain.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsSshMachineLocation
extends SshMachineLocation
implements JcloudsMachineLocation {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsSshMachineLocation.class);
    private static final long serialVersionUID = -443866395634771659L;
    @SetFromFlag
    JcloudsLocation jcloudsParent;
    @SetFromFlag
    NodeMetadata node;
    @SetFromFlag
    Template template;
    private RunScriptOnNode.Factory runScriptFactory;

    public JcloudsSshMachineLocation() {
    }

    @Deprecated
    public JcloudsSshMachineLocation(Map<?, ?> flags, JcloudsLocation jcloudsParent, NodeMetadata node) {
        super(flags);
        this.jcloudsParent = jcloudsParent;
        this.node = node;
        this.init();
    }

    public void init() {
        if (this.jcloudsParent != null) {
            super.init();
            ComputeServiceContext context = this.jcloudsParent.getComputeService().getContext();
            this.runScriptFactory = (RunScriptOnNode.Factory)context.utils().injector().getInstance(RunScriptOnNode.Factory.class);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not doing init() of {} because parent not set; presuming rebinding", (Object)this);
        }
    }

    public void rebind() {
        super.rebind();
        ComputeServiceContext context = this.jcloudsParent.getComputeService().getContext();
        this.runScriptFactory = (RunScriptOnNode.Factory)context.utils().injector().getInstance(RunScriptOnNode.Factory.class);
    }

    public String toVerboseString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("user", (Object)this.getUser()).add("address", (Object)this.getAddress()).add("port", this.getConfig(SSH_PORT)).add("node", (Object)this.getNode()).add("jcloudsId", (Object)this.getJcloudsId()).add("privateAddresses", (Object)this.node.getPrivateAddresses()).add("publicAddresses", (Object)this.node.getPublicAddresses()).add("parentLocation", (Object)this.getParent()).add("osDetails", (Object)this.getOsDetails()).toString();
    }

    @Override
    public NodeMetadata getNode() {
        return this.node;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public JcloudsLocation getParent() {
        return this.jcloudsParent;
    }

    public String getHostname() {
        return this.node.getHostname();
    }

    public Set<String> getPublicAddresses() {
        return this.node.getPublicAddresses();
    }

    public Set<String> getPrivateAddresses() {
        return this.node.getPrivateAddresses();
    }

    @Override
    public String getSubnetHostname() {
        String publicHostname = this.jcloudsParent.getPublicHostname(this.node, (Optional<HostAndPort>)Optional.absent(), this.config().getBag());
        return publicHostname;
    }

    public String getSubnetIp() {
        Optional<String> privateAddress = this.getPrivateAddress();
        if (privateAddress.isPresent()) {
            return (String)privateAddress.get();
        }
        String hostname = this.jcloudsParent.getPublicHostname(this.node, (Optional<HostAndPort>)Optional.absent(), this.config().getBag());
        if (hostname != null && !Networking.isValidIp4((String)hostname)) {
            try {
                return InetAddress.getByName(hostname).getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.debug("Cannot resolve IP for hostname {} of machine {} (so returning hostname): {}", new Object[]{hostname, this, e});
            }
        }
        return hostname;
    }

    protected Optional<String> getPrivateAddress() {
        if (JavaGroovyEquivalents.groovyTruth((Collection)this.node.getPrivateAddresses())) {
            for (String p : this.node.getPrivateAddresses()) {
                if (Networking.isLocalOnly((String)p)) continue;
                return Optional.of((Object)p);
            }
        }
        return Optional.absent();
    }

    @Override
    public String getJcloudsId() {
        return this.node.getId();
    }

    public ListenableFuture<ExecResponse> submitRunScript(String ... statements) {
        return this.submitRunScript((Statement)new InterpretableStatement(statements));
    }

    public ListenableFuture<ExecResponse> submitRunScript(Statement script) {
        return this.submitRunScript(script, new RunScriptOptions());
    }

    public ListenableFuture<ExecResponse> submitRunScript(Statement script, RunScriptOptions options) {
        return this.runScriptFactory.submit(this.node, script, options);
    }

    public void execRemoteScript(String ... commands) {
        try {
            ExecResponse result = (ExecResponse)this.submitRunScript(commands).get();
            if (result.getExitStatus() != 0) {
                throw new IllegalStateException("Error running remote commands (code " + result.getExitStatus() + "): " + commands);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String waitForPassword() {
        if (this.jcloudsParent.getProvider().equals("aws-ec2")) {
            try {
                return JcloudsUtil.waitForPasswordOnAws(this.jcloudsParent.getComputeService(), this.node, 15L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        LoginCredentials credentials = this.node.getCredentials();
        return credentials != null ? credentials.getPassword() : null;
    }

    protected MachineDetails inferMachineDetails() {
        Optional cpus;
        Hardware hardware;
        Optional ram;
        Optional name = Optional.absent();
        Optional version = Optional.absent();
        Optional architecture = Optional.absent();
        OperatingSystem os = this.node.getOperatingSystem();
        if (os == null && this.getTemplate() != null && this.getTemplate().getImage() != null) {
            os = this.getTemplate().getImage().getOperatingSystem();
        }
        if (os != null) {
            name = Optional.fromNullable(os.getFamily() != null && !OsFamily.UNRECOGNIZED.equals((Object)os.getFamily()) ? os.getFamily().toString() : null);
            version = Optional.fromNullable((Object)(!Strings.isBlank((CharSequence)os.getVersion()) ? os.getVersion() : null));
            architecture = Optional.fromNullable((Object)(os.is64Bit() ? "x86_64" : "i386"));
        }
        Optional optional = ram = (hardware = this.node.getHardware()) == null ? Optional.absent() : Optional.fromNullable((Object)hardware.getRam());
        Optional optional2 = hardware == null ? Optional.absent() : (cpus = Optional.fromNullable(hardware.getProcessors() != null ? Integer.valueOf(hardware.getProcessors().size()) : null));
        if (name.isPresent() && version.isPresent() && architecture.isPresent() && ram.isPresent() && cpus.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Gathered machine details from Jclouds, skipping SSH test on {}", (Object)this);
            }
            BasicOsDetails osD = new BasicOsDetails((String)name.get(), (String)architecture.get(), (String)version.get());
            BasicHardwareDetails hwD = new BasicHardwareDetails((Integer)cpus.get(), (Integer)ram.get());
            return new BasicMachineDetails((HardwareDetails)hwD, (OsDetails)osD);
        }
        if ("false".equalsIgnoreCase((String)this.getConfig(JcloudsLocation.WAIT_FOR_SSHABLE))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Machine details for {} missing from Jclouds, but skipping SSH test because waitForSshable=false. name={}, version={}, arch={}, ram={}, #cpus={}", new Object[]{this, name, version, architecture, ram, cpus});
            }
            BasicOsDetails osD = new BasicOsDetails((String)name.orNull(), (String)architecture.orNull(), (String)version.orNull());
            BasicHardwareDetails hwD = new BasicHardwareDetails((Integer)cpus.orNull(), (Integer)ram.orNull());
            return new BasicMachineDetails((HardwareDetails)hwD, (OsDetails)osD);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Machine details for {} missing from Jclouds, using SSH test instead. name={}, version={}, arch={}, ram={}, #cpus={}", new Object[]{this, name, version, architecture, ram, cpus});
        }
        return super.inferMachineDetails();
    }

    public Map<String, String> toMetadataRecord() {
        Hardware hardware = this.node.getHardware();
        List processors = hardware != null ? hardware.getProcessors() : null;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.toMetadataRecord());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "provider", this.getParent().getProvider());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "account", this.getParent().getIdentity());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "serverId", this.node.getProviderId());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "imageId", this.node.getImageId());
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "instanceTypeName", hardware != null ? hardware.getName() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "instanceTypeId", hardware != null ? hardware.getProviderId() : null);
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "ram", "" + (hardware != null ? Integer.valueOf(hardware.getRam()) : null));
        this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "cpus", "" + (processors != null ? Integer.valueOf(processors.size()) : null));
        try {
            OsDetails osDetails = this.getOsDetails();
            this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "osName", osDetails.getName());
            this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "osArch", osDetails.getArch());
            this.putIfNotNull((ImmutableMap.Builder<String, String>)builder, "is64bit", osDetails.is64bit() ? "true" : "false");
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.warn("Unable to get OS Details for " + this.node + "; continuing", (Throwable)e);
        }
        return builder.build();
    }

    private void putIfNotNull(ImmutableMap.Builder<String, String> builder, String key, @Nullable String value) {
        if (value != null) {
            builder.put((Object)key, (Object)value);
        }
    }
}

