/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.config.ConfigUtils;
import brooklyn.location.basic.DeprecatedKeysMappingBuilder;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.javalang.JavaClassNames;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsPropertiesFromBrooklynProperties
extends LocationPropertiesFromBrooklynProperties {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsPropertiesFromBrooklynProperties.class);
    private static final Map<String, String> DEPRECATED_JCLOUDS_KEYS_MAPPING = new DeprecatedKeysMappingBuilder(LOG).putAll(LocationPropertiesFromBrooklynProperties.DEPRECATED_KEYS_MAPPING).camelToHyphen(JcloudsLocation.IMAGE_ID).camelToHyphen(JcloudsLocation.IMAGE_NAME_REGEX).camelToHyphen(JcloudsLocation.IMAGE_DESCRIPTION_REGEX).camelToHyphen(JcloudsLocation.HARDWARE_ID).build();

    public Map<String, Object> getLocationProperties(String provider, String namedLocation, Map<String, ?> properties) {
        throw new UnsupportedOperationException("Instead use getJcloudsProperties(String,String,String,Map)");
    }

    public Map<String, Object> getJcloudsProperties(String providerOrApi, String regionOrEndpoint, String namedLocation, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)namedLocation) && Strings.isNullOrEmpty((String)providerOrApi)) {
            throw new IllegalArgumentException("Neither cloud provider/API nor location name have been specified correctly");
        }
        ConfigBag jcloudsProperties = ConfigBag.newInstance();
        String provider = this.getProviderName(providerOrApi, namedLocation, properties);
        jcloudsProperties.put(LocationConfigKeys.CLOUD_PROVIDER, (Object)provider);
        jcloudsProperties.putAll(this.transformDeprecated(this.getGenericLocationSingleWordProperties(properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getGenericJcloudsSingleWordProperties(providerOrApi, properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getProviderOrApiJcloudsProperties(providerOrApi, properties)));
        jcloudsProperties.putAll(this.transformDeprecated(this.getRegionJcloudsProperties(providerOrApi, regionOrEndpoint, properties)));
        if (!Strings.isNullOrEmpty((String)namedLocation)) {
            jcloudsProperties.putAll(this.transformDeprecated(this.getNamedJcloudsProperties(namedLocation, properties)));
        }
        JcloudsPropertiesFromBrooklynProperties.setLocalTempDir(properties, (ConfigBag)jcloudsProperties);
        return jcloudsProperties.getAllConfigRaw();
    }

    protected String getProviderName(String providerOrApi, String namedLocationName, Map<String, ?> properties) {
        String providerDefinition;
        String provider = providerOrApi;
        if (!Strings.isNullOrEmpty((String)namedLocationName) && (providerDefinition = (String)properties.get(String.format("brooklyn.location.named.%s", namedLocationName))) != null) {
            String provider2 = this.getProviderFromDefinition(providerDefinition);
            if (provider == null) {
                LOG.warn(JavaClassNames.niceClassAndMethod() + " NOT set with provider, inferring from locationName " + namedLocationName + " as " + provider2);
                provider = provider2;
            } else if (!provider.equals(provider2)) {
                LOG.debug(JavaClassNames.niceClassAndMethod() + " NOT changing provider from " + provider + " to candidate " + provider2);
            }
        }
        return provider;
    }

    protected String getProviderFromDefinition(String definition) {
        return (String)Iterables.get((Iterable)Splitter.on((String)":").split((CharSequence)definition), (int)1);
    }

    protected Map<String, Object> getGenericJcloudsSingleWordProperties(String providerOrApi, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)providerOrApi)) {
            return Maps.newHashMap();
        }
        String deprecatedPrefix = "brooklyn.jclouds.";
        String preferredPrefix = "brooklyn.location.jclouds.";
        return this.getMatchingSingleWordProperties(preferredPrefix, deprecatedPrefix, properties);
    }

    protected Map<String, Object> getProviderOrApiJcloudsProperties(String providerOrApi, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)providerOrApi)) {
            return Maps.newHashMap();
        }
        String preferredPrefix = String.format("brooklyn.location.jclouds.%s.", providerOrApi);
        String deprecatedPrefix = String.format("brooklyn.jclouds.%s.", providerOrApi);
        return this.getMatchingProperties(preferredPrefix, deprecatedPrefix, properties);
    }

    protected Map<String, Object> getRegionJcloudsProperties(String providerOrApi, String regionName, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)providerOrApi) || Strings.isNullOrEmpty((String)regionName)) {
            return Maps.newHashMap();
        }
        String preferredPrefix = String.format("brooklyn.location.jclouds.%s@%s.", providerOrApi, regionName);
        String deprecatedPrefix = String.format("brooklyn.jclouds.%s@%s.", providerOrApi, regionName);
        return this.getMatchingProperties(preferredPrefix, deprecatedPrefix, properties);
    }

    protected Map<String, Object> getNamedJcloudsProperties(String locationName, Map<String, ?> properties) {
        if (locationName == null) {
            return Maps.newHashMap();
        }
        String prefix = String.format("brooklyn.location.named.%s.", locationName);
        return ConfigUtils.filterForPrefixAndStrip(properties, (String)prefix).asMapWithStringKeys();
    }

    protected Map<String, String> getDeprecatedKeysMapping() {
        return DEPRECATED_JCLOUDS_KEYS_MAPPING;
    }
}

