/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import com.google.common.base.Predicate;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.domain.Location;

public class JcloudsPredicates {

    public static class NodeInLocation
    implements Predicate<ComputeMetadata> {
        private String regionId;
        private boolean matchNullLocations;

        public NodeInLocation(String regionId, boolean matchNullLocations) {
            this.regionId = regionId;
            this.matchNullLocations = matchNullLocations;
        }

        public boolean apply(ComputeMetadata input) {
            Location nodeLocation = input.getLocation();
            if (nodeLocation == null) {
                return this.matchNullLocations;
            }
            boolean exclude = true;
            while (nodeLocation != null && exclude) {
                if (nodeLocation.getId().equals(this.regionId)) {
                    exclude = false;
                }
                nodeLocation = nodeLocation.getParent();
            }
            return !exclude;
        }
    }
}

