/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigUtils;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Sanitizer;
import brooklyn.entity.rebind.persister.LocationWithObjectStore;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.entity.rebind.persister.jclouds.JcloudsBlobStoreBasedObjectStore;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineManagementMixins;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.access.PortForwardManager;
import brooklyn.location.access.PortMapping;
import brooklyn.location.basic.BasicMachineMetadata;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.location.cloud.AbstractCloudMachineProvisioningLocation;
import brooklyn.location.cloud.AvailabilityZoneExtension;
import brooklyn.location.cloud.names.AbstractCloudMachineNamer;
import brooklyn.location.cloud.names.CloudMachineNamer;
import brooklyn.location.jclouds.BrooklynImageChooser;
import brooklyn.location.jclouds.ComputeServiceRegistry;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.location.jclouds.JcloudsLocationCustomizer;
import brooklyn.location.jclouds.JcloudsMachineLocation;
import brooklyn.location.jclouds.JcloudsMachineNamer;
import brooklyn.location.jclouds.JcloudsPredicates;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.JcloudsUtil;
import brooklyn.location.jclouds.JcloudsWinRmMachineLocation;
import brooklyn.location.jclouds.networking.JcloudsPortForwarderExtension;
import brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import brooklyn.location.jclouds.zone.AwsAvailabilityZoneExtension;
import brooklyn.management.AccessController;
import brooklyn.management.ManagementContext;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.crypto.SecureKeys;
import brooklyn.util.exceptions.CompoundRuntimeException;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.ReferenceWithError;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.internal.ssh.ShellTool;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.javalang.Enums;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Networking;
import brooklyn.util.net.Protocol;
import brooklyn.util.os.Os;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.ssh.IptablesCommands;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.ByteSizeStrings;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.KeyValueParser;
import brooklyn.util.text.Strings;
import brooklyn.util.text.TemplateProcessor;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.google.common.reflect.TypeToken;
import io.cloudsoft.winrm4j.pywinrm.Session;
import io.cloudsoft.winrm4j.pywinrm.WinRMFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.config.AdminAccessConfiguration;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.functions.Sha512Crypt;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.scriptbuilder.domain.LiteralStatement;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.login.ReplaceShadowPasswordEntry;
import org.jclouds.scriptbuilder.statements.ssh.AuthorizeRSAPublicKeys;
import org.jclouds.scriptbuilder.statements.ssh.SshStatements;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsLocation
extends AbstractCloudMachineProvisioningLocation
implements JcloudsLocationConfig,
MachineManagementMixins.RichMachineProvisioningLocation<MachineLocation>,
LocationWithObjectStore {
    public static final Logger LOG = LoggerFactory.getLogger(JcloudsLocation.class);
    public static final String ROOT_USERNAME = "root";
    public static final List<String> ROOT_ALIASES = ImmutableList.of((Object)"ubuntu", (Object)"ec2-user");
    public static final List<String> COMMON_USER_NAMES_TO_TRY = ImmutableList.builder().add((Object)"root").addAll(ROOT_ALIASES).add((Object)"admin").build();
    private static final Pattern LIST_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^\\d*$");
    private final AtomicBoolean loggedSshKeysHint = new AtomicBoolean(false);
    private final AtomicBoolean listedAvailableTemplatesOnNoSuchTemplate = new AtomicBoolean(false);
    private final Map<String, Map<String, ? extends Object>> tagMapping = Maps.newLinkedHashMap();
    @SetFromFlag
    private final Map<MachineLocation, String> vmInstanceIds = Maps.newLinkedHashMap();
    public static final Map<ConfigKey<?>, CustomizeTemplateBuilder> SUPPORTED_TEMPLATE_BUILDER_PROPERTIES;
    public static final Map<ConfigKey<?>, CustomizeTemplateOptions> SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES;

    public JcloudsLocation() {
    }

    public JcloudsLocation(Map<?, ?> conf) {
        super(conf);
    }

    public JcloudsLocation configure(Map<?, ?> properties) {
        super.configure(properties);
        if (this.config().getLocalBag().containsKey("providerLocationId")) {
            LOG.warn("Using deprecated 'providerLocationId' key in " + this);
            if (!this.config().getLocalBag().containsKey(CLOUD_REGION_ID)) {
                this.config().addToLocalBag((Map)MutableMap.of((Object)CLOUD_REGION_ID.getName(), (Object)((String)this.config().getLocalBag().getStringKey("providerLocationId"))));
            }
        }
        if (this.isDisplayNameAutoGenerated() || !JavaGroovyEquivalents.groovyTruth((String)this.getDisplayName())) {
            this.setDisplayName(JavaGroovyEquivalents.elvis((String)this.getProvider(), (String)"unknown") + (JavaGroovyEquivalents.groovyTruth((String)this.getRegion()) ? ":" + this.getRegion() : "") + (JavaGroovyEquivalents.groovyTruth((String)this.getEndpoint()) ? ":" + this.getEndpoint() : ""));
        }
        this.setCreationString(this.config().getLocalBag());
        if (this.getConfig(MACHINE_CREATION_SEMAPHORE) == null) {
            Integer maxConcurrent = (Integer)this.getConfig(MAX_CONCURRENT_MACHINE_CREATIONS);
            if (maxConcurrent == null || maxConcurrent < 1) {
                throw new IllegalStateException(MAX_CONCURRENT_MACHINE_CREATIONS.getName() + " must be >= 1, but was " + maxConcurrent);
            }
            this.setConfig(MACHINE_CREATION_SEMAPHORE, new Semaphore(maxConcurrent, true));
        }
        return this;
    }

    public void init() {
        super.init();
        if ("aws-ec2".equals(this.getProvider())) {
            this.addExtension(AvailabilityZoneExtension.class, (Object)new AwsAvailabilityZoneExtension(this.getManagementContext(), this));
        }
    }

    public JcloudsLocation newSubLocation(Map<?, ?> newFlags) {
        return this.newSubLocation(this.getClass(), (Map)newFlags);
    }

    public JcloudsLocation newSubLocation(Class<? extends AbstractCloudMachineProvisioningLocation> type, Map<?, ?> newFlags) {
        return (JcloudsLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(type).parent((Location)this).configure(this.config().getLocalBag().getAllConfig()).configure(MACHINE_CREATION_SEMAPHORE, (Object)this.getMachineCreationSemaphore()).configure(newFlags));
    }

    public String toString() {
        String identity = this.getIdentity();
        String configDescription = this.config().getLocalBag().getDescription();
        if (configDescription != null && configDescription.startsWith(this.getClass().getSimpleName())) {
            return configDescription;
        }
        return this.getClass().getSimpleName() + "[" + this.getDisplayName() + ":" + (identity != null ? identity : null) + (configDescription != null ? "/" + configDescription : "") + "@" + this.getId() + "]";
    }

    public String toVerboseString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("identity", (Object)this.getIdentity()).add("description", (Object)this.config().getLocalBag().getDescription()).add("provider", (Object)this.getProvider()).add("region", (Object)this.getRegion()).add("endpoint", (Object)this.getEndpoint()).toString();
    }

    public String getProvider() {
        return (String)this.getConfig(CLOUD_PROVIDER);
    }

    public String getIdentity() {
        return (String)this.getConfig(ACCESS_IDENTITY);
    }

    public String getCredential() {
        return (String)this.getConfig(ACCESS_CREDENTIAL);
    }

    public String getRegion() {
        return (String)this.getConfig(CLOUD_REGION_ID);
    }

    public String getEndpoint() {
        return (String)this.config().getBag().getWithDeprecation(CLOUD_ENDPOINT, new ConfigKey[]{JCLOUDS_KEY_ENDPOINT});
    }

    public String getUser(ConfigBag config) {
        return (String)config.getWithDeprecation(USER, new ConfigKey[]{JCLOUDS_KEY_USERNAME});
    }

    public boolean isWindows(Template template, ConfigBag config) {
        return this.isWindows(template.getImage(), config);
    }

    public boolean isWindows(Image image, ConfigBag config) {
        OperatingSystem os;
        org.jclouds.compute.domain.OsFamily override = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY_OVERRIDE);
        if (override != null) {
            return override == org.jclouds.compute.domain.OsFamily.WINDOWS;
        }
        org.jclouds.compute.domain.OsFamily confFamily = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY);
        OperatingSystem operatingSystem = os = image != null ? image.getOperatingSystem() : null;
        return os != null && os.getFamily() != org.jclouds.compute.domain.OsFamily.UNRECOGNIZED ? org.jclouds.compute.domain.OsFamily.WINDOWS == os.getFamily() : org.jclouds.compute.domain.OsFamily.WINDOWS == confFamily;
    }

    public boolean isWindows(NodeMetadata node, ConfigBag config) {
        OperatingSystem os;
        org.jclouds.compute.domain.OsFamily override = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY_OVERRIDE);
        if (override != null) {
            return override == org.jclouds.compute.domain.OsFamily.WINDOWS;
        }
        org.jclouds.compute.domain.OsFamily confFamily = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY);
        OperatingSystem operatingSystem = os = node != null ? node.getOperatingSystem() : null;
        return os != null && os.getFamily() != org.jclouds.compute.domain.OsFamily.UNRECOGNIZED ? org.jclouds.compute.domain.OsFamily.WINDOWS == os.getFamily() : org.jclouds.compute.domain.OsFamily.WINDOWS == confFamily;
    }

    protected Semaphore getMachineCreationSemaphore() {
        return (Semaphore)Preconditions.checkNotNull((Object)this.getConfig(MACHINE_CREATION_SEMAPHORE), (Object)MACHINE_CREATION_SEMAPHORE.getName());
    }

    protected CloudMachineNamer getCloudMachineNamer(ConfigBag config) {
        String namerClass = (String)config.get(LocationConfigKeys.CLOUD_MACHINE_NAMER_CLASS);
        if (Strings.isNonBlank((CharSequence)namerClass)) {
            Optional cloudNamer = Reflections.invokeConstructorWithArgs((ClassLoader)this.getManagementContext().getCatalogClassLoader(), (String)namerClass, (Object[])new Object[0]);
            if (cloudNamer.isPresent()) {
                return (CloudMachineNamer)cloudNamer.get();
            }
            throw new IllegalStateException("Failed to create CloudMachineNamer " + namerClass + " for location " + this);
        }
        return new JcloudsMachineNamer();
    }

    protected Collection<JcloudsLocationCustomizer> getCustomizers(ConfigBag setup) {
        JcloudsLocationCustomizer customizer = (JcloudsLocationCustomizer)setup.get(JCLOUDS_LOCATION_CUSTOMIZER);
        Collection customizers = (Collection)setup.get(JCLOUDS_LOCATION_CUSTOMIZERS);
        String customizerType = (String)setup.get(JCLOUDS_LOCATION_CUSTOMIZER_TYPE);
        String customizersSupplierType = (String)setup.get(JCLOUDS_LOCATION_CUSTOMIZERS_SUPPLIER_TYPE);
        ClassLoader catalogClassLoader = this.getManagementContext().getCatalogClassLoader();
        ArrayList<JcloudsLocationCustomizer> result = new ArrayList<JcloudsLocationCustomizer>();
        if (customizer != null) {
            result.add(customizer);
        }
        if (customizers != null) {
            result.addAll(customizers);
        }
        if (Strings.isNonBlank((CharSequence)customizerType)) {
            Optional customizerByType = Reflections.invokeConstructorWithArgs((ClassLoader)catalogClassLoader, (String)customizerType, (Object[])new Object[]{setup});
            if (customizerByType.isPresent()) {
                result.add((JcloudsLocationCustomizer)customizerByType.get());
            } else {
                customizerByType = Reflections.invokeConstructorWithArgs((ClassLoader)catalogClassLoader, (String)customizerType, (Object[])new Object[0]);
                if (customizerByType.isPresent()) {
                    result.add((JcloudsLocationCustomizer)customizerByType.get());
                } else {
                    throw new IllegalStateException("Failed to create JcloudsLocationCustomizer " + customizersSupplierType + " for location " + this);
                }
            }
        }
        if (Strings.isNonBlank((CharSequence)customizersSupplierType)) {
            Optional supplier = Reflections.invokeConstructorWithArgs((ClassLoader)catalogClassLoader, (String)customizersSupplierType, (Object[])new Object[]{setup});
            if (supplier.isPresent()) {
                result.addAll((Collection)((Supplier)supplier.get()).get());
            } else {
                supplier = Reflections.invokeConstructorWithArgs((ClassLoader)catalogClassLoader, (String)customizersSupplierType, (Object[])new Object[0]);
                if (supplier.isPresent()) {
                    result.addAll((Collection)((Supplier)supplier.get()).get());
                } else {
                    throw new IllegalStateException("Failed to create JcloudsLocationCustomizer supplier " + customizersSupplierType + " for location " + this);
                }
            }
        }
        return result;
    }

    public void setDefaultImageId(String val) {
        this.setConfig(DEFAULT_IMAGE_ID, val);
    }

    public void setTagMapping(Map<String, Map<String, ? extends Object>> val) {
        this.tagMapping.clear();
        this.tagMapping.putAll(val);
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        ArrayList unmatchedTags = Lists.newArrayList();
        for (String it : tags) {
            if (JavaGroovyEquivalents.groovyTruth(this.tagMapping.get(it)) && !JavaGroovyEquivalents.groovyTruth((Object)result)) {
                result.putAll(this.tagMapping.get(it));
                continue;
            }
            unmatchedTags.add(it);
        }
        if (unmatchedTags.size() > 0) {
            LOG.debug("Location {}, failed to match provisioning tags {}", (Object)this, (Object)unmatchedTags);
        }
        return result;
    }

    public static final Set<ConfigKey<?>> getAllSupportedProperties() {
        LinkedHashSet configsOnClass = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)ConfigUtils.getStaticKeysOnClass(JcloudsLocation.class), (Function)new Function<ConfigKey.HasConfigKey<?>, String>(){

            @Nullable
            public String apply(@Nullable ConfigKey.HasConfigKey<?> input) {
                return input.getConfigKey().getName();
            }
        }));
        ImmutableSet configKeysInList = ImmutableSet.builder().addAll(SUPPORTED_TEMPLATE_BUILDER_PROPERTIES.keySet()).addAll(SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES.keySet()).build();
        LinkedHashSet configsInList = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)configKeysInList, (Function)new Function<ConfigKey<?>, String>(){

            @Nullable
            public String apply(@Nullable ConfigKey<?> input) {
                return input.getName();
            }
        }));
        Sets.SetView extrasInList = Sets.difference((Set)configsInList, (Set)configsOnClass);
        if (!extrasInList.isEmpty()) {
            LOG.warn("JcloudsLocation supported properties differs from config defined on class: " + extrasInList);
        }
        return Collections.unmodifiableSet(configKeysInList);
    }

    public ComputeService getComputeService() {
        return this.getComputeService((Map<?, ?>)MutableMap.of());
    }

    public ComputeService getComputeService(Map<?, ?> flags) {
        ConfigBag conf = flags == null || flags.isEmpty() ? this.config().getBag() : ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        return ((ComputeServiceRegistry)this.getConfig(COMPUTE_SERVICE_REGISTRY)).findComputeService(conf, true);
    }

    @Deprecated
    public Set<? extends ComputeMetadata> listNodes() {
        return this.listNodes((Map<?, ?>)MutableMap.of());
    }

    @Deprecated
    public Set<? extends ComputeMetadata> listNodes(Map<?, ?> flags) {
        return this.getComputeService(flags).listNodes();
    }

    public Map<String, MachineManagementMixins.MachineMetadata> listMachines() {
        Set nodes = this.getRegion() != null ? this.getComputeService().listNodesDetailsMatching((Predicate)new JcloudsPredicates.NodeInLocation(this.getRegion(), true)) : this.getComputeService().listNodes();
        LinkedHashMap<String, MachineManagementMixins.MachineMetadata> result = new LinkedHashMap<String, MachineManagementMixins.MachineMetadata>();
        for (ComputeMetadata node : nodes) {
            result.put(node.getId(), this.getMachineMetadata(node));
        }
        return result;
    }

    protected MachineManagementMixins.MachineMetadata getMachineMetadata(ComputeMetadata node) {
        if (node == null) {
            return null;
        }
        return new BasicMachineMetadata(node.getId(), node.getName(), node instanceof NodeMetadata ? (String)Iterators.tryFind(((NodeMetadata)node).getPublicAddresses().iterator(), (Predicate)Predicates.alwaysTrue()).orNull() : null, node instanceof NodeMetadata ? Boolean.valueOf(((NodeMetadata)node).getStatus() == NodeMetadata.Status.RUNNING) : null, (Object)node);
    }

    public MachineManagementMixins.MachineMetadata getMachineMetadata(MachineLocation l) {
        if (l instanceof JcloudsSshMachineLocation) {
            return this.getMachineMetadata((ComputeMetadata)((JcloudsSshMachineLocation)l).node);
        }
        return null;
    }

    public void killMachine(String cloudServiceId) {
        this.getComputeService().destroyNode(cloudServiceId);
    }

    public void killMachine(MachineLocation l) {
        MachineManagementMixins.MachineMetadata m = this.getMachineMetadata(l);
        if (m == null) {
            throw new NoSuchElementException("Machine " + l + " is not known at " + this);
        }
        this.killMachine(m.getId());
    }

    protected void setCreationString(ConfigBag config) {
        config.setDescription(JavaGroovyEquivalents.elvis((String)((String)config.get(CLOUD_PROVIDER)), (String)"unknown") + (config.containsKey(CLOUD_REGION_ID) ? ":" + (String)config.get(CLOUD_REGION_ID) : "") + (config.containsKey(CLOUD_ENDPOINT) ? ":" + (String)config.get(CLOUD_ENDPOINT) : "") + (config.containsKey(CALLER_CONTEXT) ? "@" + config.get(CALLER_CONTEXT) : ""));
    }

    public MachineLocation obtain() throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.of());
    }

    public MachineLocation obtain(TemplateBuilder tb) throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.of(), tb);
    }

    public MachineLocation obtain(Map<?, ?> flags, TemplateBuilder tb) throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.builder().putAll(flags).put((Object)TEMPLATE_BUILDER, (Object)tb).build());
    }

    public MachineLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        Object cause;
        ConfigBag setup = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        Integer attempts = (Integer)setup.get(MACHINE_CREATE_ATTEMPTS);
        ArrayList exceptions = Lists.newArrayList();
        if (attempts == null || attempts < 1) {
            attempts = 1;
        }
        for (int i = 1; i <= attempts; ++i) {
            try {
                return this.obtainOnce(setup);
            }
            catch (RuntimeException e) {
                LOG.warn("Attempt #{}/{} to obtain machine threw error: {}", new Object[]{i, attempts, e});
                exceptions.add(e);
                continue;
            }
        }
        String msg = String.format("Failed to get VM after %d attempt%s.", attempts, attempts == 1 ? "" : "s");
        Object object = cause = exceptions.size() == 1 ? (Exception)exceptions.get(0) : new CompoundRuntimeException(msg + " - " + "First cause is " + exceptions.get(0) + " (listed in primary trace); " + "plus " + (exceptions.size() - 1) + " more (e.g. the last is " + exceptions.get(exceptions.size() - 1) + ")", (Throwable)exceptions.get(0), (Iterable)exceptions);
        if (exceptions.get(exceptions.size() - 1) instanceof NoMachinesAvailableException) {
            throw new NoMachinesAvailableException(msg, (Throwable)cause);
        }
        throw Exceptions.propagate((Throwable)cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MachineLocation obtainOnce(ConfigBag setup) throws NoMachinesAvailableException {
        AccessController.Response access = this.getManagementContext().getAccessController().canProvisionLocation((Location)this);
        if (!access.isAllowed()) {
            throw new IllegalStateException("Access controller forbids provisioning in " + this + ": " + access.getMsg());
        }
        this.setCreationString(setup);
        boolean waitForSshable = !"false".equalsIgnoreCase((String)setup.get(WAIT_FOR_SSHABLE));
        boolean waitForWinRmable = !"false".equalsIgnoreCase((String)setup.get(WAIT_FOR_WINRM_AVAILABLE));
        boolean usePortForwarding = (Boolean)setup.get(USE_PORT_FORWARDING);
        boolean skipJcloudsSshing = Boolean.FALSE.equals(setup.get(USE_JCLOUDS_SSH_INIT)) || usePortForwarding;
        JcloudsPortForwarderExtension portForwarder = (JcloudsPortForwarderExtension)setup.get(PORT_FORWARDER);
        if (usePortForwarding) {
            Preconditions.checkNotNull((Object)portForwarder, (Object)"portForwarder, when use-port-forwarding enabled");
        }
        ComputeService computeService = ((ComputeServiceRegistry)this.getConfig(COMPUTE_SERVICE_REGISTRY)).findComputeService(setup, true);
        CloudMachineNamer cloudMachineNamer = this.getCloudMachineNamer(setup);
        String groupId = JavaGroovyEquivalents.elvis((String)((String)setup.get(GROUP_ID)), (String)cloudMachineNamer.generateNewGroupId(setup));
        NodeMetadata node = null;
        JcloudsMachineLocation machineLocation = null;
        try {
            LoginCredentials customCredentials;
            Duration provisionTimestamp;
            Set nodes;
            Duration templateTimestamp;
            Template template;
            LOG.info("Creating VM " + setup.getDescription() + " in " + this);
            Semaphore machineCreationSemaphore = this.getMachineCreationSemaphore();
            boolean acquired = machineCreationSemaphore.tryAcquire(0L, TimeUnit.SECONDS);
            if (!acquired) {
                LOG.info("Waiting in {} for machine-creation permit ({} other queuing requests already)", new Object[]{this, machineCreationSemaphore.getQueueLength()});
                Stopwatch blockStopwatch = Stopwatch.createStarted();
                machineCreationSemaphore.acquire();
                LOG.info("Acquired in {} machine-creation permit, after waiting {}", (Object)this, (Object)Time.makeTimeStringRounded((Stopwatch)blockStopwatch));
            } else {
                LOG.debug("Acquired in {} machine-creation permit immediately", (Object)this);
            }
            Stopwatch provisioningStopwatch = Stopwatch.createStarted();
            LoginCredentials userCredentials = null;
            try {
                template = this.buildTemplate(computeService, setup);
                boolean expectWindows = this.isWindows(template, setup);
                if (!skipJcloudsSshing) {
                    if (expectWindows) {
                        LOG.warn("Ignoring invalid configuration for Windows provisioning of " + template.getImage() + ": " + USE_JCLOUDS_SSH_INIT.getName() + " should be false");
                        skipJcloudsSshing = true;
                    } else if (waitForSshable) {
                        userCredentials = this.initTemplateForCreateUser(template, setup);
                    }
                }
                templateTimestamp = Duration.of((Object)provisioningStopwatch);
                template.getOptions().getUserMetadata().put("Name", cloudMachineNamer.generateNewMachineUniqueNameFromGroupId(setup, groupId));
                if (((Boolean)setup.get(JcloudsLocationConfig.INCLUDE_BROOKLYN_USER_METADATA)).booleanValue()) {
                    template.getOptions().getUserMetadata().put("brooklyn-user", System.getProperty("user.name"));
                    Object context = setup.get(CALLER_CONTEXT);
                    if (context instanceof Entity) {
                        Entity entity = (Entity)context;
                        template.getOptions().getUserMetadata().put("brooklyn-app-id", entity.getApplicationId());
                        template.getOptions().getUserMetadata().put("brooklyn-app-name", entity.getApplication().getDisplayName());
                        template.getOptions().getUserMetadata().put("brooklyn-entity-id", entity.getId());
                        template.getOptions().getUserMetadata().put("brooklyn-entity-name", entity.getDisplayName());
                        template.getOptions().getUserMetadata().put("brooklyn-server-creation-date", Time.makeDateSimpleStampString());
                    }
                }
                this.customizeTemplate(setup, computeService, template);
                LOG.debug("jclouds using template {} / options {} to provision machine in {}", new Object[]{template, template.getOptions(), setup.getDescription()});
                if (!setup.getUnusedConfig().isEmpty()) {
                    LOG.debug("NOTE: unused flags passed to obtain VM in " + setup.getDescription() + ": " + setup.getUnusedConfig());
                }
                nodes = computeService.createNodesInGroup(groupId, 1, template);
                provisionTimestamp = Duration.of((Object)provisioningStopwatch);
            }
            finally {
                machineCreationSemaphore.release();
            }
            node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes, null);
            LOG.debug("jclouds created {} for {}", (Object)node, (Object)setup.getDescription());
            if (node == null) {
                throw new IllegalStateException("No nodes returned by jclouds create-nodes in " + setup.getDescription());
            }
            boolean windows = this.isWindows(node, setup);
            if (windows) {
                int newLoginPort = node.getLoginPort() == 22 ? 5985 : node.getLoginPort();
                String newLoginUser = ROOT_USERNAME.equals(node.getCredentials().getUser()) ? "Administrator" : node.getCredentials().getUser();
                LOG.debug("jclouds created Windows VM {}; transforming connection details: loginPort from {} to {}; loginUser from {} to {}", new Object[]{node, node.getLoginPort(), newLoginPort, node.getCredentials().getUser(), newLoginUser});
                node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).loginPort(newLoginPort).credentials(LoginCredentials.builder((Credentials)node.getCredentials()).user(newLoginUser).build()).build();
            }
            Optional sshHostAndPortOverride = usePortForwarding ? Optional.of((Object)portForwarder.openPortForwarding(node, node.getLoginPort(), (Optional<Integer>)Optional.absent(), Protocol.TCP, Cidr.UNIVERSAL)) : Optional.absent();
            if (skipJcloudsSshing) {
                boolean waitForConnectable;
                boolean bl = waitForConnectable = windows ? waitForWinRmable : waitForSshable;
                if (waitForConnectable) {
                    if (windows) {
                        this.waitForWinRmAvailable(computeService, node, (Optional<HostAndPort>)sshHostAndPortOverride, node.getCredentials(), setup);
                    } else {
                        this.waitForSshable(computeService, node, (Optional<HostAndPort>)sshHostAndPortOverride, node.getCredentials(), setup);
                    }
                    userCredentials = this.createUser(computeService, node, (Optional<HostAndPort>)sshHostAndPortOverride, setup);
                }
            }
            if ((customCredentials = (LoginCredentials)setup.get(CUSTOM_CREDENTIALS)) != null) {
                userCredentials = customCredentials;
                Object oldUsername = setup.put(USER, (Object)customCredentials.getUser());
                LOG.debug("node {} username {} / {} (customCredentials)", new Object[]{node, customCredentials.getUser(), oldUsername});
                if (customCredentials.getOptionalPassword().isPresent()) {
                    setup.put(PASSWORD, customCredentials.getOptionalPassword().get());
                }
                if (customCredentials.getOptionalPrivateKey().isPresent()) {
                    setup.put(PRIVATE_KEY_DATA, customCredentials.getOptionalPrivateKey().get());
                }
            }
            if (userCredentials == null) {
                userCredentials = this.extractVmCredentials(setup, node);
            }
            if (userCredentials != null) {
                node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).credentials(userCredentials).build();
            } else {
                userCredentials = LoginCredentials.fromCredentials((Credentials)node.getCredentials());
            }
            setup.putIfNotNull(JcloudsLocationConfig.PASSWORD, userCredentials.getOptionalPassword().orNull());
            setup.putIfNotNull(JcloudsLocationConfig.PRIVATE_KEY_DATA, userCredentials.getOptionalPrivateKey().orNull());
            if (waitForSshable && !windows) {
                this.waitForSshable(computeService, node, (Optional<HostAndPort>)sshHostAndPortOverride, userCredentials, setup);
            } else {
                LOG.debug("Skipping ssh check for {} ({}) due to config waitForSshable=false", (Object)node, (Object)setup.getDescription());
            }
            Duration usableTimestamp = Duration.of((Object)provisioningStopwatch);
            if (windows) {
                machineLocation = this.registerWinRmMachineLocation(computeService, node, userCredentials, (Optional<HostAndPort>)sshHostAndPortOverride, setup);
            } else {
                machineLocation = this.registerJcloudsSshMachineLocation(computeService, node, userCredentials, (Optional<HostAndPort>)sshHostAndPortOverride, setup);
                if (template != null && machineLocation.getTemplate() == null) {
                    ((JcloudsSshMachineLocation)machineLocation).template = template;
                }
            }
            if (usePortForwarding && sshHostAndPortOverride.isPresent()) {
                PortForwardManager portForwardManager = (PortForwardManager)setup.get(PORT_FORWARDING_MANAGER);
                if (portForwardManager != null) {
                    portForwardManager.associate(node.getId(), (HostAndPort)sshHostAndPortOverride.get(), (Location)machineLocation, node.getLoginPort());
                } else {
                    LOG.warn("No port-forward manager for {} so could not associate {} -> {} for {}", new Object[]{this, node.getLoginPort(), sshHostAndPortOverride, machineLocation});
                }
            }
            if ("docker".equals(this.getProvider())) {
                if (windows) {
                    throw new UnsupportedOperationException("Docker not supported on Windows");
                }
                Map<Integer, Integer> portMappings = JcloudsUtil.dockerPortMappingsFor(this, node.getId());
                PortForwardManager portForwardManager = (PortForwardManager)setup.get(PORT_FORWARDING_MANAGER);
                if (portForwardManager != null) {
                    for (Integer containerPort : portMappings.keySet()) {
                        Integer hostPort = portMappings.get(containerPort);
                        String dockerHost = ((JcloudsSshMachineLocation)machineLocation).getSshHostAndPort().getHostText();
                        portForwardManager.associate(node.getId(), HostAndPort.fromParts((String)dockerHost, (int)hostPort), (Location)machineLocation, containerPort.intValue());
                    }
                } else {
                    LOG.warn("No port-forward manager for {} so could not associate docker port-mappings for {}", (Object)this, (Object)machineLocation);
                }
            }
            ArrayList<String> customisationForLogging = new ArrayList<String>();
            if (waitForSshable) {
                List extraKeyUrlsToAuth;
                String setupScript = (String)setup.get(JcloudsLocationConfig.CUSTOM_MACHINE_SETUP_SCRIPT_URL);
                List setupScripts = (List)setup.get(JcloudsLocationConfig.CUSTOM_MACHINE_SETUP_SCRIPT_URL_LIST);
                MutableList allScripts = new MutableList().appendIfNotNull((Object)setupScript).appendAll((Iterable)setupScripts);
                for (String setupScriptItem : allScripts) {
                    if (!Strings.isNonBlank((CharSequence)setupScriptItem)) continue;
                    customisationForLogging.add("custom setup script " + setupScriptItem);
                    String setupVarsString = (String)setup.get(JcloudsLocationConfig.CUSTOM_MACHINE_SETUP_SCRIPT_VARS);
                    ImmutableMap substitutions = setupVarsString != null ? Splitter.on((String)",").withKeyValueSeparator(":").split((CharSequence)setupVarsString) : ImmutableMap.of();
                    String scriptContent = ResourceUtils.create((Object)this).getResourceAsString(setupScriptItem);
                    String script = TemplateProcessor.processTemplateContents((String)scriptContent, (ManagementContext)this.getManagementContext(), (Map)substitutions);
                    if (windows) {
                        ((WinRmMachineLocation)machineLocation).executeScript((List)ImmutableList.copyOf((Object[])script.replace("\r", "").split("\n")));
                        continue;
                    }
                    ((SshMachineLocation)machineLocation).execCommands("Customizing node " + this, (List)ImmutableList.of((Object)script));
                }
                if (((Boolean)setup.get(JcloudsLocationConfig.MAP_DEV_RANDOM_TO_DEV_URANDOM)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring flag MAP_DEV_RANDOM_TO_DEV_URANDOM on Windows location {}", (Object)machineLocation);
                    } else {
                        customisationForLogging.add("point /dev/random to urandom");
                        ((SshMachineLocation)machineLocation).execCommands("using urandom instead of random", Arrays.asList("sudo mv /dev/random /dev/random-real", "sudo ln -s /dev/urandom /dev/random"));
                    }
                }
                if (((Boolean)setup.get(GENERATE_HOSTNAME)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring flag GENERATE_HOSTNAME on Windows location {}", (Object)machineLocation);
                    } else {
                        customisationForLogging.add("configure hostname");
                        ((SshMachineLocation)machineLocation).execCommands("Generate hostname " + node.getName(), Arrays.asList("sudo hostname " + node.getName(), "sudo sed -i \"s/HOSTNAME=.*/HOSTNAME=" + node.getName() + "/g\" /etc/sysconfig/network", "sudo bash -c \"echo 127.0.0.1   `hostname` >> /etc/hosts\""));
                    }
                }
                if (((Boolean)setup.get(OPEN_IPTABLES)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring flag OPEN_IPTABLES on Windows location {}", (Object)machineLocation);
                    } else {
                        Iterable inboundPorts = (Iterable)setup.get(INBOUND_PORTS);
                        if (inboundPorts == null || Iterables.isEmpty((Iterable)inboundPorts)) {
                            LOG.info("No ports to open in iptables (no inbound ports) for {} at {}", (Object)machineLocation, (Object)this);
                        } else {
                            customisationForLogging.add("open iptables");
                            List<String> iptablesRules = this.createIptablesRulesForNetworkInterface(inboundPorts);
                            iptablesRules.add(IptablesCommands.saveIptablesRules());
                            ArrayList batch = Lists.newArrayList();
                            for (String rule : iptablesRules) {
                                batch.add(rule);
                                if (batch.size() != 50) continue;
                                ((SshMachineLocation)machineLocation).execCommands("Inserting iptables rules, 50 command batch", (List)batch);
                                batch.clear();
                            }
                            if (batch.size() > 0) {
                                ((SshMachineLocation)machineLocation).execCommands("Inserting iptables rules", (List)batch);
                            }
                            ((SshMachineLocation)machineLocation).execCommands("List iptables rules", (List)ImmutableList.of((Object)IptablesCommands.listIptablesRule()));
                        }
                    }
                }
                if (((Boolean)setup.get(STOP_IPTABLES)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring flag OPEN_IPTABLES on Windows location {}", (Object)machineLocation);
                    } else {
                        customisationForLogging.add("stop iptables");
                        ImmutableList cmds = ImmutableList.of((Object)IptablesCommands.iptablesServiceStop(), (Object)IptablesCommands.iptablesServiceStatus());
                        ((SshMachineLocation)machineLocation).execCommands("Stopping iptables", (List)cmds);
                    }
                }
                if ((extraKeyUrlsToAuth = (List)setup.get(EXTRA_PUBLIC_KEY_URLS_TO_AUTH)) != null && !extraKeyUrlsToAuth.isEmpty()) {
                    if (windows) {
                        LOG.warn("Ignoring flag EXTRA_PUBLIC_KEY_URLS_TO_AUTH on Windows location", (Object)machineLocation);
                    } else {
                        MutableList extraKeyDataToAuth = MutableList.of();
                        for (String keyUrl : extraKeyUrlsToAuth) {
                            extraKeyDataToAuth.add(ResourceUtils.create().getResourceAsString(keyUrl));
                        }
                        ((SshMachineLocation)machineLocation).execCommands("Authorizing ssh keys", (List)ImmutableList.of((Object)new AuthorizeRSAPublicKeys((Iterable)extraKeyDataToAuth).render(OsFamily.UNIX)));
                    }
                }
            }
            for (JcloudsLocationCustomizer customizer : this.getCustomizers(setup)) {
                customizer.customize(this, computeService, machineLocation);
            }
            Duration customizedTimestamp = Duration.of((Object)provisioningStopwatch);
            try {
                String logMessage = "Finished VM " + setup.getDescription() + " creation:" + " " + machineLocation.getUser() + "@" + machineLocation.getAddress() + ":" + machineLocation.getPort() + (Boolean.TRUE.equals(setup.get(LOG_CREDENTIALS)) ? "password=" + (String)userCredentials.getOptionalPassword().or((Object)"<absent>") + " && key=" + (String)userCredentials.getOptionalPrivateKey().or((Object)"<absent>") : "") + " ready after " + Duration.of((Object)provisioningStopwatch).toStringRounded() + " (" + template + " template built in " + Duration.of((Object)templateTimestamp).toStringRounded() + ";" + " " + node + " provisioned in " + Duration.of((Object)provisionTimestamp).subtract(templateTimestamp).toStringRounded() + ";" + " " + machineLocation + " connection usable in " + Duration.of((Object)usableTimestamp).subtract(provisionTimestamp).toStringRounded() + ";" + " and os customized in " + Duration.of((Object)customizedTimestamp).subtract(usableTimestamp).toStringRounded() + " - " + Joiner.on((String)", ").join(customisationForLogging) + ")";
                LOG.info(logMessage);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Problem generating log message summarising completion of jclouds machine provisioning " + machineLocation + " by " + this, (Throwable)e);
            }
            return machineLocation;
        }
        catch (Exception e) {
            if (e instanceof RunNodesException && ((RunNodesException)e).getNodeErrors().size() > 0) {
                node = (NodeMetadata)Iterables.get(((RunNodesException)e).getNodeErrors().keySet(), (int)0);
            }
            boolean destroyNode = node != null && Boolean.TRUE.equals(setup.get(DESTROY_ON_FAILURE));
            LOG.error("Failed to start VM for {}{}: {}", new Object[]{setup.getDescription(), destroyNode ? " (destroying " + node + ")" : "", e.getMessage()});
            LOG.debug(Throwables.getStackTraceAsString((Throwable)e));
            if (destroyNode) {
                if (machineLocation != null) {
                    this.releaseSafely(machineLocation);
                } else {
                    this.releaseNodeSafely(node);
                }
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected void customizeTemplate(ConfigBag setup, ComputeService computeService, Template template) {
        for (JcloudsLocationCustomizer customizer : this.getCustomizers(setup)) {
            customizer.customize(this, computeService, template);
            customizer.customize(this, computeService, template.getOptions());
        }
        if (template.getOptions() instanceof SoftLayerTemplateOptions) {
            Map md;
            SoftLayerTemplateOptions slT = (SoftLayerTemplateOptions)template.getOptions();
            if (Strings.isBlank((CharSequence)slT.getDomainName()) || "jclouds.org".equals(slT.getDomainName())) {
                slT.domainName("local.brooklyncentral.org");
            }
            if ((md = slT.getUserMetadata()) != null && !md.isEmpty()) {
                MutableSet tags = MutableSet.copyOf((Iterable)slT.getTags());
                for (Map.Entry entry : md.entrySet()) {
                    tags.add(AbstractCloudMachineNamer.sanitize((String)((String)entry.getKey())) + ":" + AbstractCloudMachineNamer.sanitize((String)((String)entry.getValue())));
                }
                slT.tags((Iterable)tags);
            }
        }
    }

    public Template buildTemplate(ComputeService computeService, ConfigBag config) {
        Template template;
        PortableTemplateBuilder templateBuilder = (PortableTemplateBuilder)config.get(TEMPLATE_BUILDER);
        if (templateBuilder == null) {
            templateBuilder = new PortableTemplateBuilder();
        } else {
            LOG.debug("jclouds using templateBuilder {} as custom base for provisioning in {} for {}", new Object[]{templateBuilder, this, config.getDescription()});
        }
        if (templateBuilder instanceof PortableTemplateBuilder) {
            if (templateBuilder.imageChooser() == null) {
                Function chooser = (Function)config.get(JcloudsLocationConfig.IMAGE_CHOOSER);
                chooser = BrooklynImageChooser.cloneFor(chooser, computeService);
                templateBuilder.imageChooser(chooser);
            }
        } else {
            LOG.warn("Cannot check imageChooser status for {} due to manually supplied black-box TemplateBuilder; it is recommended to use a PortableTemplateBuilder if you supply a TemplateBuilder", (Object)config.getDescription());
        }
        if (!Strings.isEmpty((CharSequence)((CharSequence)config.get(CLOUD_REGION_ID)))) {
            templateBuilder.locationId((String)config.get(CLOUD_REGION_ID));
        }
        for (Map.Entry<ConfigKey<?>, CustomizeTemplateBuilder> entry : SUPPORTED_TEMPLATE_BUILDER_PROPERTIES.entrySet()) {
            ConfigKey<?> name = entry.getKey();
            CustomizeTemplateBuilder code = entry.getValue();
            if (!config.containsKey(name)) continue;
            code.apply(templateBuilder, config, config.get(name));
        }
        if (templateBuilder instanceof PortableTemplateBuilder) {
            templateBuilder.attachComputeService(computeService);
            if (JavaGroovyEquivalents.groovyTruth((String)((String)config.get(DEFAULT_IMAGE_ID))) && templateBuilder.isBlank()) {
                templateBuilder.imageId(((String)config.get(DEFAULT_IMAGE_ID)).toString());
            }
        }
        for (JcloudsLocationCustomizer customizer : this.getCustomizers(config)) {
            customizer.customize(this, computeService, templateBuilder);
        }
        LOG.debug("jclouds using templateBuilder {} for provisioning in {} for {}", new Object[]{templateBuilder, this, config.getDescription()});
        try {
            template = templateBuilder.build();
            if (template == null) {
                throw new NullPointerException("No template found (templateBuilder.build returned null)");
            }
            Image image = template.getImage();
            LOG.debug("jclouds found template " + template + " (image " + image + ") for provisioning in " + this + " for " + config.getDescription());
            if (image == null) {
                throw new NullPointerException("Template does not contain an image (templateBuilder.build returned invalid template)");
            }
        }
        catch (AuthorizationException e) {
            LOG.warn("Error resolving template: not authorized (rethrowing: " + (Object)((Object)e) + ")");
            throw new IllegalStateException("Not authorized to access cloud " + this + " to resolve " + templateBuilder, e);
        }
        catch (Exception e) {
            try {
                IOException ioe = (IOException)Exceptions.getFirstThrowableOfType((Throwable)e, IOException.class);
                if (ioe != null) {
                    LOG.warn("IOException found...", (Throwable)ioe);
                    throw ioe;
                }
                if (this.listedAvailableTemplatesOnNoSuchTemplate.compareAndSet(false, true)) {
                    LOG.warn("Unable to match required VM template constraints " + templateBuilder + " when trying to provision VM in " + this + " (rethrowing): " + e);
                    this.logAvailableTemplates(config);
                }
            }
            catch (Exception e2) {
                LOG.warn("Error loading available images to report (following original error matching template which will be rethrown): " + e2, (Throwable)e2);
                throw new IllegalStateException("Unable to access cloud " + this + " to resolve " + templateBuilder + ": " + e, e);
            }
            throw new IllegalStateException("Unable to match required VM template constraints " + templateBuilder + " when trying to provision VM in " + this + "; " + "see list of images in log. Root cause: " + e, e);
        }
        TemplateOptions options = template.getOptions();
        boolean windows = this.isWindows(template, config);
        if (windows && !config.containsKey(JcloudsLocationConfig.USER_METADATA_STRING) && !config.containsKey(JcloudsLocationConfig.USER_METADATA_MAP)) {
            config.put(JcloudsLocationConfig.USER_METADATA_STRING, (Object)WinRmMachineLocation.getDefaultUserMetadataString());
        }
        for (Map.Entry<ConfigKey<?>, CustomizeTemplateOptions> entry : SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES.entrySet()) {
            ConfigKey<?> key = entry.getKey();
            CustomizeTemplateOptions code = entry.getValue();
            if (!config.containsKey(key)) continue;
            code.apply(options, config, config.get(key));
        }
        return template;
    }

    protected void logAvailableTemplates(ConfigBag config) {
        LOG.info("Loading available images at " + this + " for reference...");
        ConfigBag m1 = ConfigBag.newInstanceCopying((ConfigBag)config);
        if (m1.containsKey(IMAGE_ID)) {
            m1.remove(IMAGE_ID);
            m1.putStringKey("anyOwner", (Object)true);
        }
        ComputeService computeServiceLessRestrictive = ((ComputeServiceRegistry)this.getConfig(COMPUTE_SERVICE_REGISTRY)).findComputeService(m1, true);
        Set imgs = computeServiceLessRestrictive.listImages();
        LOG.info("" + imgs.size() + " available images at " + this);
        for (Image img : imgs) {
            LOG.info(" Image: " + img);
        }
        Set profiles = computeServiceLessRestrictive.listHardwareProfiles();
        LOG.info("" + profiles.size() + " available profiles at " + this);
        for (Hardware profile : profiles) {
            LOG.info(" Profile: " + profile);
        }
        Set assignableLocations = computeServiceLessRestrictive.listAssignableLocations();
        LOG.info("" + assignableLocations.size() + " available locations at " + this);
        for (org.jclouds.domain.Location assignableLocation : assignableLocations) {
            LOG.info(" Location: " + assignableLocation);
        }
    }

    protected SshMachineLocation createTemporarySshMachineLocation(HostAndPort hostAndPort, LoginCredentials creds, ConfigBag config) {
        Optional initialPassword = creds.getOptionalPassword();
        Optional initialPrivateKey = creds.getOptionalPrivateKey();
        String initialUser = creds.getUser();
        LinkedHashMap sshProps = Maps.newLinkedHashMap((Map)config.getAllConfig());
        sshProps.put("user", initialUser);
        sshProps.put("address", hostAndPort.getHostText());
        sshProps.put("port", hostAndPort.getPort());
        if (initialPassword.isPresent()) {
            sshProps.put("password", initialPassword.get());
        }
        if (initialPrivateKey.isPresent()) {
            sshProps.put("privateKeyData", initialPrivateKey.get());
        }
        if (initialPrivateKey.isPresent()) {
            sshProps.put("privateKeyData", initialPrivateKey.get());
        }
        if (this.isManaged()) {
            return (SshMachineLocation)this.getManagementContext().getLocationManager().createLocation((Map)sshProps, SshMachineLocation.class);
        }
        return new SshMachineLocation((Map)sshProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected LoginCredentials createUser(ComputeService computeService, NodeMetadata node, Optional<HostAndPort> hostAndPortOverride, ConfigBag config) {
        SshMachineLocation sshLoc;
        UserCreation userCreation;
        block7: {
            Image image = node.getImageId() != null ? computeService.getImage(node.getImageId()) : null;
            userCreation = this.createUserStatements(image, config);
            if (userCreation.statements.isEmpty()) return userCreation.createdUserCredentials;
            OsFamily scriptOsFamily = this.isWindows(node, config) ? OsFamily.WINDOWS : OsFamily.UNIX;
            boolean windows = this.isWindows(node, config);
            if (windows) {
                LOG.warn("Unable to execute statements on WinRM in JcloudsLocation; skipping for " + node + ": " + userCreation.statements);
                return userCreation.createdUserCredentials;
            }
            ArrayList commands = Lists.newArrayList();
            for (Statement statement : userCreation.statements) {
                InitAdminAccess initAdminAccess = new InitAdminAccess((AdminAccess.Configuration)new AdminAccessConfiguration.Default());
                initAdminAccess.visit(statement);
                commands.add(statement.render(scriptOsFamily));
            }
            LoginCredentials initialCredentials = node.getCredentials();
            Optional initialPassword = initialCredentials.getOptionalPassword();
            Optional initialPrivateKey = initialCredentials.getOptionalPrivateKey();
            String initialUser = initialCredentials.getUser();
            String address = hostAndPortOverride.isPresent() ? ((HostAndPort)hostAndPortOverride.get()).getHostText() : JcloudsUtil.getFirstReachableAddress(computeService.getContext(), node);
            int port = hostAndPortOverride.isPresent() ? ((HostAndPort)hostAndPortOverride.get()).getPort() : node.getLoginPort();
            LinkedHashMap sshProps = Maps.newLinkedHashMap((Map)config.getAllConfig());
            sshProps.put("user", initialUser);
            sshProps.put("address", address);
            sshProps.put("port", port);
            if (initialPassword.isPresent()) {
                sshProps.put("password", initialPassword.get());
            }
            if (initialPrivateKey.isPresent()) {
                sshProps.put("privateKeyData", initialPrivateKey.get());
            }
            LinkedHashMap execProps = Maps.newLinkedHashMap();
            execProps.put(ShellTool.PROP_RUN_AS_ROOT.getName(), true);
            execProps.put(SshTool.PROP_SSH_TRIES.getName(), 50);
            execProps.put(SshTool.PROP_SSH_TRIES_TIMEOUT.getName(), 600000);
            if (LOG.isDebugEnabled()) {
                LOG.debug("VM {}: executing user creation/setup via {}@{}:{}; commands: {}", new Object[]{config.getDescription(), initialUser, address, port, commands});
            }
            sshLoc = null;
            try {
                sshLoc = this.isManaged() ? (SshMachineLocation)this.getManagementContext().getLocationManager().createLocation((Map)sshProps, SshMachineLocation.class) : new SshMachineLocation((Map)sshProps);
                int exitcode = sshLoc.execScript((Map)execProps, "create-user", (List)commands);
                if (exitcode == 0) break block7;
                LOG.warn("exit code {} when creating user for {}; usage may subsequently fail", (Object)exitcode, (Object)node);
            }
            catch (Throwable throwable) {
                this.getManagementContext().getLocationManager().unmanage(sshLoc);
                Streams.closeQuietly((Closeable)sshLoc);
                throw throwable;
            }
        }
        this.getManagementContext().getLocationManager().unmanage((Location)sshLoc);
        Streams.closeQuietly((Closeable)sshLoc);
        return userCreation.createdUserCredentials;
    }

    protected LoginCredentials initTemplateForCreateUser(Template template, ConfigBag config) {
        UserCreation userCreation = this.createUserStatements(template.getImage(), config);
        if (userCreation.statements.size() > 0) {
            TemplateOptions options = template.getOptions();
            options.runScript((Statement)new StatementList(userCreation.statements));
        }
        return userCreation.createdUserCredentials;
    }

    protected UserCreation createUserStatements(@Nullable Image image, ConfigBag config) {
        boolean windows = this.isWindows(image, config);
        String user = this.getUser(config);
        String explicitLoginUser = (String)config.get(LOGIN_USER);
        String loginUser = JavaGroovyEquivalents.groovyTruth((String)explicitLoginUser) ? explicitLoginUser : (image != null && image.getDefaultCredentials() != null ? image.getDefaultCredentials().identity : null);
        boolean dontCreateUser = (Boolean)config.get(DONT_CREATE_USER);
        boolean grantUserSudo = (Boolean)config.get(GRANT_USER_SUDO);
        LocationConfigUtils.OsCredential credential = LocationConfigUtils.getOsCredential((ConfigBag)config);
        credential.checkNoErrors().logAnyWarnings();
        String passwordToSet = Strings.isNonBlank((CharSequence)credential.getPassword()) ? credential.getPassword() : Identifiers.makeRandomId((int)12);
        ArrayList statements = Lists.newArrayList();
        LoginCredentials createdUserCreds = null;
        if (dontCreateUser) {
            if (Strings.isBlank((CharSequence)user)) {
                LOG.info("Not setting up any user (subsequently using loginUser {})", (Object)user, (Object)loginUser);
                config.put(USER, (Object)loginUser);
            } else {
                LOG.info("Not creating user {}, and not installing its password or authorizing keys (assuming it exists)", (Object)user);
                if (credential.isUsingPassword()) {
                    createdUserCreds = LoginCredentials.builder().user(user).password(credential.getPassword()).build();
                } else if (credential.hasKey()) {
                    createdUserCreds = LoginCredentials.builder().user(user).privateKey(credential.getPrivateKeyData()).build();
                }
            }
        } else if (windows) {
            LOG.warn("Not creating or configuring user on Windows VM, despite " + DONT_CREATE_USER.getName() + " set to false");
            if (config.get(USER) != null) {
                config.put(USER, (Object)"");
            }
            if (config.get(PASSWORD) != null) {
                config.put(PASSWORD, (Object)"");
            }
            if (config.get(PRIVATE_KEY_DATA) != null) {
                config.put(PRIVATE_KEY_DATA, (Object)"");
            }
            if (config.get(PRIVATE_KEY_FILE) != null) {
                config.put(PRIVATE_KEY_FILE, (Object)"");
            }
            if (config.get(PUBLIC_KEY_DATA) != null) {
                config.put(PUBLIC_KEY_DATA, (Object)"");
            }
            if (config.get(PUBLIC_KEY_FILE) != null) {
                config.put(PUBLIC_KEY_FILE, (Object)"");
            }
        } else if (Strings.isBlank((CharSequence)user) || user.equals(loginUser) || user.equals(ROOT_USERNAME)) {
            if (Strings.isBlank((CharSequence)user)) {
                user = loginUser;
                config.put(USER, (Object)user);
            }
            statements.add(new ReplaceShadowPasswordEntry(Sha512Crypt.function(), user, passwordToSet));
            createdUserCreds = LoginCredentials.builder().user(user).password(passwordToSet).build();
            if (Strings.isNonBlank((CharSequence)credential.getPublicKeyData())) {
                statements.add(new AuthorizeRSAPublicKeys("~" + user + "/.ssh", (Iterable)ImmutableList.of((Object)credential.getPublicKeyData())));
                if (!credential.isUsingPassword() && Strings.isNonBlank((CharSequence)credential.getPrivateKeyData())) {
                    createdUserCreds = LoginCredentials.builder().user(user).privateKey(credential.getPrivateKeyData()).build();
                }
            }
        } else {
            String pubKey = credential.getPublicKeyData();
            String privKey = credential.getPrivateKeyData();
            if (credential.isEmpty()) {
                if (!config.containsKey(PRIVATE_KEY_FILE) && this.loggedSshKeysHint.compareAndSet(false, true)) {
                    LOG.info("Default SSH keys not found or not usable; will create new keys for each machine. Create ~/.ssh/id_rsa or set " + PRIVATE_KEY_FILE.getName() + " / " + PRIVATE_KEY_PASSPHRASE.getName() + " / " + PASSWORD.getName() + " " + "as appropriate for this location if you wish to be able to log in without Brooklyn.");
                }
                KeyPair newKeyPair = SecureKeys.newKeyPair();
                pubKey = SecureKeys.toPub((KeyPair)newKeyPair);
                privKey = SecureKeys.toPem((KeyPair)newKeyPair);
                LOG.debug("Brooklyn key being created for " + user + " at new machine " + this + " is:\n" + privKey);
            }
            credential = null;
            AdminAccess.Builder adminBuilder = AdminAccess.builder().adminUsername(user).grantSudoToAdminUser(grantUserSudo);
            adminBuilder.cryptFunction(Sha512Crypt.function());
            boolean useKey = Strings.isNonBlank((CharSequence)pubKey);
            adminBuilder.cryptFunction(Sha512Crypt.function());
            adminBuilder.adminPassword(passwordToSet);
            LOG.debug("Password '" + passwordToSet + "' being created for user '" + user + "' at the machine we are about to provision in " + this + "; " + (useKey ? "however a key will be used to access it" : "this will be the only way to log in"));
            if (grantUserSudo && ((Boolean)config.get(JcloudsLocationConfig.DISABLE_ROOT_AND_PASSWORD_SSH)).booleanValue()) {
                adminBuilder.resetLoginPassword(true);
                adminBuilder.loginPassword(Identifiers.makeRandomId((int)12));
            } else {
                adminBuilder.resetLoginPassword(false);
                adminBuilder.loginPassword(Identifiers.makeRandomId((int)12) + "-ignored");
            }
            if (useKey) {
                adminBuilder.authorizeAdminPublicKey(true).adminPublicKey(pubKey);
            } else {
                adminBuilder.authorizeAdminPublicKey(false).adminPublicKey(Identifiers.makeRandomId((int)12) + "-ignored");
            }
            adminBuilder.installAdminPrivateKey(false).adminPrivateKey(Identifiers.makeRandomId((int)12) + "-ignored");
            adminBuilder.lockSsh(useKey && grantUserSudo && (Boolean)config.get(JcloudsLocationConfig.DISABLE_ROOT_AND_PASSWORD_SSH) != false);
            statements.add(adminBuilder.build());
            if (useKey) {
                createdUserCreds = LoginCredentials.builder().user(user).privateKey(privKey).build();
            } else if (passwordToSet != null) {
                createdUserCreds = LoginCredentials.builder().user(user).password(passwordToSet).build();
                statements.add(SshStatements.sshdConfig((Map)ImmutableMap.of((Object)"PasswordAuthentication", (Object)"yes")));
            }
        }
        String customTemplateOptionsScript = (String)config.get(CUSTOM_TEMPLATE_OPTIONS_SCRIPT_CONTENTS);
        if (Strings.isNonBlank((CharSequence)customTemplateOptionsScript)) {
            statements.add(new LiteralStatement(customTemplateOptionsScript));
        }
        LOG.debug("Machine we are about to create in " + this + " will be customized with: " + statements);
        return new UserCreation(createdUserCreds, statements);
    }

    public JcloudsSshMachineLocation rebindMachine(NodeMetadata metadata) throws NoMachinesAvailableException {
        return this.rebindMachine((Map<?, ?>)MutableMap.of(), metadata);
    }

    public JcloudsSshMachineLocation rebindMachine(Map<?, ?> flags, NodeMetadata metadata) throws NoMachinesAvailableException {
        ConfigBag setup = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        if (!setup.containsKey("id")) {
            setup.putStringKey("id", (Object)metadata.getId());
        }
        this.setHostnameUpdatingCredentials(setup, metadata);
        return this.rebindMachine(setup);
    }

    public JcloudsSshMachineLocation rebindMachine(ConfigBag setup) throws NoMachinesAvailableException {
        try {
            if (setup.getDescription() == null) {
                this.setCreationString(setup);
            }
            String user = (String)Preconditions.checkNotNull((Object)this.getUser(setup), (Object)"user");
            String rawId = (String)setup.getStringKey("id");
            String rawHostname = (String)setup.getStringKey("hostname");
            Predicate<ComputeMetadata> predicate = this.getRebindToMachinePredicate(setup);
            LOG.info("Rebinding to VM {} ({}@{}), in jclouds location for provider {} matching {}", new Object[]{rawId != null ? rawId : "<lookup>", user, rawHostname != null ? rawHostname : "<unspecified>", this.getProvider(), predicate});
            ComputeService computeService = ((ComputeServiceRegistry)this.getConfig(COMPUTE_SERVICE_REGISTRY)).findComputeService(setup, true);
            Set candidateNodes = computeService.listNodesDetailsMatching(predicate);
            if (candidateNodes.isEmpty()) {
                throw new IllegalArgumentException("Jclouds node not found for rebind with predicate " + predicate);
            }
            if (candidateNodes.size() > 1) {
                throw new IllegalArgumentException("Jclouds node for rebind matched multiple with " + predicate + ": " + candidateNodes);
            }
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)candidateNodes);
            String pkd = LocationConfigUtils.getOsCredential((ConfigBag)setup).checkNoErrors().logAnyWarnings().getPrivateKeyData();
            if (Strings.isNonBlank((CharSequence)pkd)) {
                LoginCredentials expectedCredentials = LoginCredentials.fromCredentials((Credentials)new Credentials(user, pkd));
                node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).credentials(expectedCredentials).build();
            }
            return this.registerJcloudsSshMachineLocation(computeService, node, null, (Optional<HostAndPort>)Optional.absent(), setup);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public JcloudsSshMachineLocation rebindMachine(Map<?, ?> flags) throws NoMachinesAvailableException {
        ConfigBag setup = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        return this.rebindMachine(setup);
    }

    protected Predicate<ComputeMetadata> getRebindToMachinePredicate(ConfigBag config) {
        return new RebindToMachinePredicate(config);
    }

    @Deprecated
    protected final JcloudsSshMachineLocation registerJcloudsSshMachineLocation(NodeMetadata node, String vmHostname, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) throws IOException {
        LOG.warn("Using deprecated registerJcloudsSshMachineLocation: now wants computeService passed", new Throwable("source of deprecated registerJcloudsSshMachineLocation invocation"));
        return this.registerJcloudsSshMachineLocation(null, node, null, sshHostAndPort, setup);
    }

    protected JcloudsSshMachineLocation registerJcloudsSshMachineLocation(ComputeService computeService, NodeMetadata node, LoginCredentials initialCredentials, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) throws IOException {
        if (initialCredentials == null) {
            initialCredentials = node.getCredentials();
        }
        String vmHostname = this.getPublicHostname(node, sshHostAndPort, setup);
        JcloudsSshMachineLocation machine = this.createJcloudsSshMachineLocation(computeService, node, vmHostname, sshHostAndPort, setup);
        this.registerJcloudsMachineLocation(node.getId(), machine);
        return machine;
    }

    @VisibleForTesting
    protected void registerJcloudsMachineLocation(String nodeId, JcloudsMachineLocation machine) {
        machine.setParent((Location)this);
        this.vmInstanceIds.put(machine, nodeId);
    }

    @Deprecated
    protected final JcloudsSshMachineLocation createJcloudsSshMachineLocation(NodeMetadata node, String vmHostname, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) throws IOException {
        return this.createJcloudsSshMachineLocation(null, node, vmHostname, sshHostAndPort, setup);
    }

    protected JcloudsSshMachineLocation createJcloudsSshMachineLocation(ComputeService computeService, NodeMetadata node, String vmHostname, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) throws IOException {
        Map<String, Object> sshConfig = this.extractSshConfig(setup, node);
        String nodeAvailabilityZone = this.extractAvailabilityZone(setup, node);
        String nodeRegion = this.extractRegion(setup, node);
        if (nodeRegion == null) {
            nodeRegion = this.extractProvider(setup, node);
        }
        String address = sshHostAndPort.isPresent() ? ((HostAndPort)sshHostAndPort.get()).getHostText() : vmHostname;
        try {
            Networking.getInetAddressWithFixedName((String)address);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Could not resolve reported address '" + address + "' for " + vmHostname + " (" + setup.getDescription() + "/" + node + "), requesting reachable address");
            if (computeService == null) {
                throw Exceptions.propagate((Throwable)e);
            }
            address = JcloudsUtil.getFirstReachableAddress(computeService.getContext(), node);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating JcloudsSshMachineLocation representation for {}@{} ({}/{}) for {}/{}", new Object[]{this.getUser(setup), address, Sanitizer.sanitize(sshConfig), sshHostAndPort, setup.getDescription(), node});
        }
        if (this.isManaged()) {
            return (JcloudsSshMachineLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(JcloudsSshMachineLocation.class).configure((CharSequence)"displayName", (Object)vmHostname).configure((CharSequence)"address", (Object)address).configure(JcloudsSshMachineLocation.SSH_PORT, (Object)(sshHostAndPort.isPresent() ? ((HostAndPort)sshHostAndPort.get()).getPort() : node.getLoginPort())).configure((CharSequence)"user", (Object)this.getUser(setup)).configure(sshConfig).configure((CharSequence)"config", sshConfig).configure((CharSequence)"jcloudsParent", (Object)this).configure((CharSequence)"node", (Object)node).configureIfNotNull(CLOUD_AVAILABILITY_ZONE_ID, (Object)nodeAvailabilityZone).configureIfNotNull(CLOUD_REGION_ID, (Object)nodeRegion).configure(CALLER_CONTEXT, setup.get(CALLER_CONTEXT)).configure(SshMachineLocation.DETECT_MACHINE_DETAILS, setup.get(SshMachineLocation.DETECT_MACHINE_DETAILS)).configureIfNotNull(SshMachineLocation.SCRIPT_DIR, setup.get(SshMachineLocation.SCRIPT_DIR)).configureIfNotNull(USE_PORT_FORWARDING, setup.get(USE_PORT_FORWARDING)).configureIfNotNull(PORT_FORWARDER, setup.get(PORT_FORWARDER)).configureIfNotNull(PORT_FORWARDING_MANAGER, setup.get(PORT_FORWARDING_MANAGER)));
        }
        LOG.warn("Using deprecated JcloudsSshMachineLocation constructor because " + this + " is not managed");
        return new JcloudsSshMachineLocation((Map<?, ?>)MutableMap.builder().put((Object)"displayName", (Object)vmHostname).put((Object)"address", (Object)address).put((Object)"port", (Object)(sshHostAndPort.isPresent() ? ((HostAndPort)sshHostAndPort.get()).getPort() : node.getLoginPort())).put((Object)"user", (Object)this.getUser(setup)).putAll(sshConfig).put((Object)"config", sshConfig).put((Object)"callerContext", setup.get(CALLER_CONTEXT)).putIfNotNull((Object)CLOUD_AVAILABILITY_ZONE_ID.getName(), (Object)nodeAvailabilityZone).putIfNotNull((Object)CLOUD_REGION_ID.getName(), (Object)nodeRegion).put((Object)USE_PORT_FORWARDING, setup.get(USE_PORT_FORWARDING)).put((Object)PORT_FORWARDER, setup.get(PORT_FORWARDER)).put((Object)PORT_FORWARDING_MANAGER, setup.get(PORT_FORWARDING_MANAGER)).build(), this, node);
    }

    protected JcloudsWinRmMachineLocation registerWinRmMachineLocation(ComputeService computeService, NodeMetadata node, LoginCredentials initialCredentials, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) {
        if (initialCredentials == null) {
            initialCredentials = node.getCredentials();
        }
        String vmHostname = this.getPublicHostname(node, sshHostAndPort, setup);
        JcloudsWinRmMachineLocation machine = this.createWinRmMachineLocation(computeService, node, vmHostname, sshHostAndPort, setup);
        this.registerJcloudsMachineLocation(node.getId(), machine);
        return machine;
    }

    protected JcloudsWinRmMachineLocation createWinRmMachineLocation(ComputeService computeService, NodeMetadata node, String vmHostname, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) {
        String address;
        String nodeAvailabilityZone = this.extractAvailabilityZone(setup, node);
        String nodeRegion = this.extractRegion(setup, node);
        if (nodeRegion == null) {
            nodeRegion = this.extractProvider(setup, node);
        }
        String string = address = sshHostAndPort.isPresent() ? ((HostAndPort)sshHostAndPort.get()).getHostText() : vmHostname;
        if (this.isManaged()) {
            return (JcloudsWinRmMachineLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(JcloudsWinRmMachineLocation.class).configure((CharSequence)"jcloudsParent", (Object)this).configure((CharSequence)"displayName", (Object)vmHostname).configure((CharSequence)"address", (Object)address).configure(WinRmMachineLocation.WINRM_PORT, (Object)(sshHostAndPort.isPresent() ? ((HostAndPort)sshHostAndPort.get()).getPort() : node.getLoginPort())).configure((CharSequence)"user", (Object)this.getUser(setup)).configure(WinRmMachineLocation.USER, setup.get(USER)).configure(WinRmMachineLocation.PASSWORD, setup.get(PASSWORD)).configure((CharSequence)"node", (Object)node).configureIfNotNull(CLOUD_AVAILABILITY_ZONE_ID, (Object)nodeAvailabilityZone).configureIfNotNull(CLOUD_REGION_ID, (Object)nodeRegion).configure(CALLER_CONTEXT, setup.get(CALLER_CONTEXT)).configure(SshMachineLocation.DETECT_MACHINE_DETAILS, setup.get(SshMachineLocation.DETECT_MACHINE_DETAILS)).configureIfNotNull(SshMachineLocation.SCRIPT_DIR, setup.get(SshMachineLocation.SCRIPT_DIR)).configureIfNotNull(USE_PORT_FORWARDING, setup.get(USE_PORT_FORWARDING)).configureIfNotNull(PORT_FORWARDER, setup.get(PORT_FORWARDER)).configureIfNotNull(PORT_FORWARDING_MANAGER, setup.get(PORT_FORWARDING_MANAGER)));
        }
        throw new UnsupportedOperationException("Cannot create WinRmMachineLocation because " + this + " is not managed");
    }

    protected Map<String, Object> extractSshConfig(ConfigBag setup, NodeMetadata node) {
        ConfigBag nodeConfig = new ConfigBag();
        if (node != null && node.getCredentials() != null) {
            nodeConfig.putIfNotNull(PASSWORD, node.getCredentials().getOptionalPassword().orNull());
            nodeConfig.putIfNotNull(PRIVATE_KEY_DATA, node.getCredentials().getOptionalPrivateKey().orNull());
        }
        return this.extractSshConfig(setup, nodeConfig).getAllConfig();
    }

    protected String extractAvailabilityZone(ConfigBag setup, NodeMetadata node) {
        return this.extractNodeLocationId(setup, node, LocationScope.ZONE);
    }

    protected String extractRegion(ConfigBag setup, NodeMetadata node) {
        return this.extractNodeLocationId(setup, node, LocationScope.REGION);
    }

    protected String extractProvider(ConfigBag setup, NodeMetadata node) {
        return this.extractNodeLocationId(setup, node, LocationScope.PROVIDER);
    }

    protected String extractNodeLocationId(ConfigBag setup, NodeMetadata node, LocationScope scope) {
        org.jclouds.domain.Location nodeLoc = node.getLocation();
        if (nodeLoc == null) {
            return null;
        }
        do {
            if (nodeLoc.getScope() != scope) continue;
            return nodeLoc.getId();
        } while ((nodeLoc = nodeLoc.getParent()) != null);
        return null;
    }

    public void release(MachineLocation rawMachine) {
        ConfigBag setup;
        Exception tothrow;
        JcloudsMachineLocation machine;
        String instanceId;
        block14: {
            block13: {
                instanceId = this.vmInstanceIds.remove(rawMachine);
                if (instanceId == null) {
                    LOG.info("Attempted release of unknown machine " + rawMachine + " in " + this.toString());
                    throw new IllegalArgumentException("Unknown machine " + rawMachine);
                }
                machine = (JcloudsMachineLocation)rawMachine;
                LOG.info("Releasing machine {} in {}, instance id {}", new Object[]{machine, this, instanceId});
                tothrow = null;
                setup = this.config().getBag();
                for (JcloudsLocationCustomizer customizer : this.getCustomizers(setup)) {
                    try {
                        customizer.preRelease(machine);
                    }
                    catch (Exception e) {
                        LOG.error("Problem invoking pre-release customizer " + customizer + " for machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                        if (tothrow != null) continue;
                        tothrow = e;
                    }
                }
                try {
                    if (machine instanceof SshMachineLocation) {
                        this.releasePortForwarding((SshMachineLocation)machine);
                    }
                }
                catch (Exception e) {
                    LOG.error("Problem releasing port-forwarding for machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                    if (tothrow != null) break block13;
                    tothrow = e;
                }
            }
            try {
                this.releaseNode(instanceId);
            }
            catch (Exception e) {
                LOG.error("Problem releasing machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) break block14;
                tothrow = e;
            }
        }
        this.removeChild((Location)machine);
        for (JcloudsLocationCustomizer customizer : this.getCustomizers(setup)) {
            try {
                customizer.postRelease(machine);
            }
            catch (Exception e) {
                LOG.error("Problem invoking pre-release customizer " + customizer + " for machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) continue;
                tothrow = e;
            }
        }
        if (tothrow != null) {
            throw Exceptions.propagate(tothrow);
        }
    }

    protected void releaseSafely(MachineLocation machine) {
        try {
            this.release(machine);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void releaseNodeSafely(NodeMetadata node) {
        String instanceId = node.getId();
        LOG.info("Releasing node {} in {}, instance id {}", new Object[]{node, this, instanceId});
        try {
            this.releaseNode(instanceId);
        }
        catch (Exception e) {
            LOG.warn("Problem releasing node " + node + " in " + this + ", instance id " + instanceId + "; discarding instance and continuing...", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseNode(String instanceId) {
        ComputeService computeService = null;
        computeService = ((ComputeServiceRegistry)this.getConfig(COMPUTE_SERVICE_REGISTRY)).findComputeService(this.config().getBag(), true);
        computeService.destroyNode(instanceId);
    }

    protected void releasePortForwarding(SshMachineLocation machine) {
        NodeMetadata node;
        boolean usePortForwarding = Boolean.TRUE.equals(machine.getConfig(USE_PORT_FORWARDING));
        JcloudsPortForwarderExtension portForwarder = (JcloudsPortForwarderExtension)machine.getConfig(PORT_FORWARDER);
        PortForwardManager portForwardManager = (PortForwardManager)machine.getConfig(PORT_FORWARDING_MANAGER);
        NodeMetadata nodeMetadata = node = machine instanceof JcloudsSshMachineLocation ? ((JcloudsSshMachineLocation)machine).getNode() : null;
        if (portForwarder == null) {
            LOG.debug("No port-forwarding to close (because portForwarder null) on release of " + machine);
        } else {
            LinkedHashSet mappings;
            if (usePortForwarding && node != null) {
                HostAndPort sshHostAndPortOverride = machine.getSshHostAndPort();
                LOG.debug("Closing port-forwarding at {} for machine {}: {}->{}", new Object[]{this, machine, sshHostAndPortOverride, node.getLoginPort()});
                portForwarder.closePortForwarding(node, node.getLoginPort(), sshHostAndPortOverride, Protocol.TCP);
            }
            if (portForwardManager != null) {
                mappings = Sets.newLinkedHashSet();
                mappings.addAll(portForwardManager.getLocationPublicIpIds((Location)machine));
                if (node != null) {
                    mappings.addAll(portForwardManager.getPortMappingWithPublicIpId(node.getId()));
                }
            } else {
                mappings = ImmutableSet.of();
            }
            for (PortMapping mapping : mappings) {
                HostAndPort publicEndpoint = mapping.getPublicEndpoint();
                int targetPort = mapping.getPrivatePort();
                Protocol protocol = Protocol.TCP;
                if (publicEndpoint == null) continue;
                LOG.debug("Closing port-forwarding at {} for machine {}: {}->{}", new Object[]{this, machine, publicEndpoint, targetPort});
                portForwarder.closePortForwarding(node, targetPort, publicEndpoint, protocol);
            }
        }
        if (portForwardManager != null) {
            portForwardManager.forgetPortMappings((Location)machine);
            if (node != null) {
                portForwardManager.forgetPortMappings(node.getId());
            }
        }
    }

    protected LoginCredentials extractVmCredentials(ConfigBag setup, NodeMetadata node) {
        String user = this.getUser(setup);
        LocationConfigUtils.OsCredential localCredentials = LocationConfigUtils.getOsCredential((ConfigBag)setup).checkNoErrors();
        LoginCredentials nodeCredentials = LoginCredentials.fromCredentials((Credentials)node.getCredentials());
        LOG.debug("Credentials extracted for {}: {}/{} with {}/{}", new Object[]{node, user, nodeCredentials.getUser(), localCredentials, nodeCredentials});
        if (Strings.isNonBlank((CharSequence)nodeCredentials.getUser())) {
            if (Strings.isBlank((CharSequence)user)) {
                user = nodeCredentials.getUser();
                setup.put(USER, (Object)user);
            } else if (ROOT_USERNAME.equals(user) && ROOT_ALIASES.contains(nodeCredentials.getUser())) {
                LOG.warn("overriding username 'root' in favour of '" + nodeCredentials.getUser() + "' at {}; this behaviour may be removed in future", (Object)node);
                user = nodeCredentials.getUser();
                setup.put(USER, (Object)user);
            }
            String pkd = (String)Strings.maybeNonBlank((CharSequence)localCredentials.getPrivateKeyData()).or(nodeCredentials.getOptionalPrivateKey().orNull());
            String pwd = (String)Strings.maybeNonBlank((CharSequence)localCredentials.getPassword()).or(nodeCredentials.getOptionalPassword().orNull());
            if (Strings.isBlank((CharSequence)user) || Strings.isBlank((CharSequence)pkd) && pwd == null) {
                String missing = user == null ? "user" : "credential";
                LOG.warn("Not able to determine " + missing + " for " + this + " at " + node + "; will likely fail subsequently");
                return null;
            }
            LoginCredentials.Builder resultBuilder = LoginCredentials.builder().user(user);
            if (pwd != null && (Strings.isBlank((CharSequence)pkd) || localCredentials.isUsingPassword())) {
                resultBuilder.password(pwd);
            } else {
                resultBuilder.privateKey(pkd);
            }
            return resultBuilder.build();
        }
        LOG.warn("No node-credentials or admin-access available for node " + node + " in " + this + "; will likely fail subsequently");
        return null;
    }

    protected void waitForWinRmAvailable(ComputeService computeService, NodeMetadata node, Optional<HostAndPort> hostAndPortOverride, LoginCredentials expectedCredentials, ConfigBag setup) {
        String waitForWinrmAvailable = (String)setup.get(WAIT_FOR_WINRM_AVAILABLE);
        Preconditions.checkArgument((!"false".equalsIgnoreCase(waitForWinrmAvailable) ? 1 : 0) != 0, (String)"waitForWinRmAvailable called despite waitForWinRmAvailable=%s", (Object[])new Object[]{waitForWinrmAvailable});
        Duration timeout = null;
        try {
            timeout = Duration.parse((String)waitForWinrmAvailable);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
        }
        if (timeout == null) {
            timeout = Duration.parse((String)((String)WAIT_FOR_WINRM_AVAILABLE.getDefaultValue()));
        }
        String user = expectedCredentials.getUser();
        String password = (String)expectedCredentials.getOptionalPassword().orNull();
        int vmPort = hostAndPortOverride.isPresent() ? ((HostAndPort)hostAndPortOverride.get()).getPortOrDefault(5985) : 5985;
        String vmIp = hostAndPortOverride.isPresent() ? ((HostAndPort)hostAndPortOverride.get()).getHostText() : JcloudsUtil.getFirstReachableAddress(computeService.getContext(), NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).loginPort(vmPort).build());
        final Session session = WinRMFactory.INSTANCE.createSession(vmIp + ":" + vmPort, user, password);
        if (vmIp == null) {
            LOG.warn("Unable to extract IP for " + node + " (" + setup.getDescription() + "): subsequent connection attempt will likely fail");
        }
        Callable<Boolean> checker = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return session.run_cmd("hostname", new String[0]).getStatusCode() == 0;
            }
        };
        String connectionDetails = user + "@" + vmIp + ":" + vmPort;
        this.waitForReachable(checker, connectionDetails, expectedCredentials, setup, timeout);
    }

    protected void waitForSshable(final ComputeService computeService, final NodeMetadata node, Optional<HostAndPort> hostAndPortOverride, final LoginCredentials expectedCredentials, ConfigBag setup) {
        Callable<Boolean> checker;
        String vmIp;
        String waitForSshable = (String)setup.get(WAIT_FOR_SSHABLE);
        Preconditions.checkArgument((!"false".equalsIgnoreCase(waitForSshable) ? 1 : 0) != 0, (String)"waitForReachable called despite waitForSshable=%s", (Object[])new Object[]{waitForSshable});
        Duration timeout = null;
        try {
            timeout = Duration.parse((String)waitForSshable);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (timeout == null) {
            timeout = Duration.parse((String)((String)WAIT_FOR_SSHABLE.getDefaultValue()));
        }
        String user = expectedCredentials.getUser();
        String string = vmIp = hostAndPortOverride.isPresent() ? ((HostAndPort)hostAndPortOverride.get()).getHostText() : JcloudsUtil.getFirstReachableAddress(computeService.getContext(), node);
        if (vmIp == null) {
            LOG.warn("Unable to extract IP for " + node + " (" + setup.getDescription() + "): subsequent connection attempt will likely fail");
        }
        int vmPort = hostAndPortOverride.isPresent() ? ((HostAndPort)hostAndPortOverride.get()).getPortOrDefault(22) : 22;
        String connectionDetails = user + "@" + vmIp + ":" + vmPort;
        if (hostAndPortOverride.isPresent()) {
            final SshMachineLocation machine = this.createTemporarySshMachineLocation((HostAndPort)hostAndPortOverride.get(), expectedCredentials, setup);
            checker = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    int exitstatus = machine.execScript("check-connectivity", (List)ImmutableList.of((Object)"hostname"));
                    return exitstatus == 0;
                }
            };
        } else {
            checker = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    Statement statement = Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)"hostname")});
                    ExecResponse response = computeService.runScriptOnNode(node.getId(), statement, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)expectedCredentials).runAsRoot(false));
                    return response.getExitStatus() == 0;
                }
            };
        }
        this.waitForReachable(checker, connectionDetails, expectedCredentials, setup, timeout);
    }

    protected void waitForReachable(Callable<Boolean> checker, String connectionDetails, LoginCredentials expectedCredentials, ConfigBag setup, Duration timeout) {
        String user = expectedCredentials.getUser();
        if (LOG.isDebugEnabled()) {
            Optional key;
            Optional password;
            if (Boolean.TRUE.equals(setup.get(LOG_CREDENTIALS))) {
                password = expectedCredentials.getOptionalPassword();
                key = expectedCredentials.getOptionalPrivateKey();
            } else {
                password = expectedCredentials.getOptionalPassword().isPresent() ? Optional.of((Object)"******") : Optional.absent();
                key = expectedCredentials.getOptionalPrivateKey().isPresent() ? Optional.of((Object)"******") : Optional.absent();
            }
            LOG.debug("VM {}: reported online, now waiting {} for it to be contactable on {}{}; using credentials password={}; key={}", new Object[]{setup.getDescription(), timeout, connectionDetails, Objects.equal((Object)user, (Object)this.getUser(setup)) ? "" : " (setup user is different: " + this.getUser(setup) + ")", password.or((Object)"<absent>"), key.or((Object)"<absent>")});
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ReferenceWithError reachable = new Repeater().every(1L, TimeUnit.SECONDS).until(checker).limitTimeTo(timeout).runKeepingError();
        if (!((Boolean)reachable.getWithoutError()).booleanValue()) {
            throw new IllegalStateException("Connection failed for " + connectionDetails + " (" + setup.getDescription() + ") after waiting " + Time.makeTimeStringRounded((Duration)timeout), reachable.getError());
        }
        LOG.debug("VM {}: connection succeeded after {} on {}", new Object[]{setup.getDescription(), Time.makeTimeStringRounded((Stopwatch)stopwatch), connectionDetails});
    }

    protected void setHostnameUpdatingCredentials(ConfigBag setup, NodeMetadata metadata) {
        LoginCredentials credentials;
        ArrayList<String> usersTried = new ArrayList<String>();
        String originalUser = this.getUser(setup);
        if (JavaGroovyEquivalents.groovyTruth((String)originalUser)) {
            if (this.setHostname(setup, metadata, false)) {
                return;
            }
            usersTried.add(originalUser);
        }
        if ((credentials = metadata.getCredentials()) != null) {
            if (Strings.isNonBlank((CharSequence)credentials.getUser())) {
                setup.put(USER, (Object)credentials.getUser());
            }
            if (Strings.isNonBlank((CharSequence)((CharSequence)credentials.getOptionalPrivateKey().orNull()))) {
                setup.put(PRIVATE_KEY_DATA, credentials.getOptionalPrivateKey().orNull());
            }
            if (this.setHostname(setup, metadata, false)) {
                if (originalUser != null && !originalUser.equals(this.getUser(setup))) {
                    LOG.warn("Switching to cloud-specified user at " + metadata + " as " + this.getUser(setup) + " (failed to connect using: " + usersTried + ")");
                }
                return;
            }
            usersTried.add(this.getUser(setup));
        }
        for (String u : COMMON_USER_NAMES_TO_TRY) {
            setup.put(USER, (Object)u);
            if (this.setHostname(setup, metadata, false)) {
                LOG.warn("Auto-detected user at " + metadata + " as " + this.getUser(setup) + " (failed to connect using: " + usersTried + ")");
                return;
            }
            usersTried.add(this.getUser(setup));
        }
        LOG.warn("Failed to log in to " + metadata + ", tried as users " + usersTried + " (throwing original exception)");
        setup.put(USER, (Object)originalUser);
        this.setHostname(setup, metadata, true);
    }

    protected boolean setHostname(ConfigBag setup, NodeMetadata metadata, boolean rethrow) {
        try {
            setup.put(SshTool.PROP_HOST, (Object)this.getPublicHostname(metadata, (Optional<HostAndPort>)Optional.absent(), setup));
            return true;
        }
        catch (Exception e) {
            if (rethrow) {
                LOG.warn("couldn't connect to " + metadata + " when trying to discover hostname (rethrowing): " + e);
                throw Exceptions.propagate((Throwable)e);
            }
            return false;
        }
    }

    protected String getPublicHostname(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) {
        String provider;
        String string = provider = setup != null ? (String)setup.get(CLOUD_PROVIDER) : null;
        if (provider == null) {
            provider = this.getProvider();
        }
        if ("aws-ec2".equals(provider)) {
            HostAndPort inferredHostAndPort = null;
            if (!sshHostAndPort.isPresent()) {
                try {
                    String vmIp = JcloudsUtil.getFirstReachableAddress(this.getComputeService().getContext(), node);
                    int port = node.getLoginPort();
                    inferredHostAndPort = HostAndPort.fromParts((String)vmIp, (int)port);
                }
                catch (Exception e) {
                    LOG.warn("Error reaching aws-ec2 instance " + node.getId() + "@" + node.getLocation() + " on port " + node.getLoginPort() + "; falling back to jclouds metadata for address", (Throwable)e);
                }
            }
            if (sshHostAndPort.isPresent() || inferredHostAndPort != null) {
                if (this.isWindows(node, setup)) {
                    if (inferredHostAndPort != null) {
                        LOG.warn("Cannot querying aws-ec2 Windows instance " + node.getId() + "@" + node.getLocation() + " over ssh for its hostname; falling back to first reachable IP");
                        return inferredHostAndPort.getHostText();
                    }
                } else {
                    HostAndPort hostAndPortToUse = sshHostAndPort.isPresent() ? (HostAndPort)sshHostAndPort.get() : inferredHostAndPort;
                    try {
                        return this.getPublicHostnameAws(hostAndPortToUse, setup);
                    }
                    catch (Exception e) {
                        if (inferredHostAndPort != null) {
                            LOG.warn("Error querying aws-ec2 instance " + node.getId() + "@" + node.getLocation() + " over ssh for its hostname; falling back to first reachable IP", (Throwable)e);
                            return inferredHostAndPort.getHostText();
                        }
                        LOG.warn("Error querying aws-ec2 instance " + node.getId() + "@" + node.getLocation() + " over ssh for its hostname; falling back to jclouds metadata for address", (Throwable)e);
                    }
                }
            }
        }
        return this.getPublicHostnameGeneric(node, setup);
    }

    private String getPublicHostnameGeneric(NodeMetadata node, @Nullable ConfigBag setup) {
        if (JavaGroovyEquivalents.groovyTruth((Collection)node.getPublicAddresses())) {
            return (String)node.getPublicAddresses().iterator().next();
        }
        if (JavaGroovyEquivalents.groovyTruth((String)node.getHostname())) {
            return node.getHostname();
        }
        if (JavaGroovyEquivalents.groovyTruth((Collection)node.getPrivateAddresses())) {
            return (String)node.getPrivateAddresses().iterator().next();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPublicHostnameAws(HostAndPort sshHostAndPort, ConfigBag setup) {
        String string;
        SshMachineLocation sshLocByIp = null;
        try {
            String line2;
            block7: {
                String[] outLines;
                ConfigBag sshConfig = this.extractSshConfig(setup, new ConfigBag());
                if (this.isManaged()) {
                    sshLocByIp = (SshMachineLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).configure((CharSequence)"address", (Object)sshHostAndPort.getHostText()).configure((CharSequence)"port", (Object)sshHostAndPort.getPort()).configure((CharSequence)"user", (Object)this.getUser(setup)).configure(sshConfig.getAllConfig()));
                } else {
                    MutableMap locationProps = MutableMap.builder().put((Object)"address", (Object)sshHostAndPort.getHostText()).put((Object)"port", (Object)sshHostAndPort.getPort()).put((Object)"user", (Object)this.getUser(setup)).putAll(sshConfig.getAllConfig()).build();
                    sshLocByIp = new SshMachineLocation((Map)locationProps);
                }
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ByteArrayOutputStream errStream = new ByteArrayOutputStream();
                int exitcode = sshLocByIp.execCommands((Map)MutableMap.of((Object)"out", (Object)outStream, (Object)"err", (Object)errStream), "get public AWS hostname", (List)ImmutableList.of((Object)BashCommands.INSTALL_CURL, (Object)"echo `curl --silent --retry 20 http://169.254.169.254/latest/meta-data/public-hostname`; exit"));
                String outString = new String(outStream.toByteArray());
                for (String line2 : outLines = outString.split("\n")) {
                    if (!line2.startsWith("ec2-")) {
                        continue;
                    }
                    break block7;
                }
                throw new IllegalStateException("Could not obtain aws-ec2 hostname for vm " + sshHostAndPort + "; exitcode=" + exitcode + "; stdout=" + outString + "; stderr=" + new String(errStream.toByteArray()));
            }
            string = line2.trim();
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(sshLocByIp);
            throw throwable;
        }
        Streams.closeQuietly((Closeable)sshLocByIp);
        return string;
    }

    public static File asFile(Object o) {
        if (o instanceof File) {
            return (File)o;
        }
        if (o == null) {
            return null;
        }
        return new File(o.toString());
    }

    public static String fileAsString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof File) {
            return ((File)o).getAbsolutePath();
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    protected static double toDouble(Object v) {
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        throw new IllegalArgumentException("Invalid type for double: " + v + " of type " + v.getClass());
    }

    @VisibleForTesting
    static int[] toIntArray(Object v) {
        int[] result;
        if (v instanceof Iterable) {
            result = new int[Iterables.size((Iterable)((Iterable)v))];
            int i = 0;
            for (Object o : (Iterable)v) {
                result[i++] = (Integer)o;
            }
        } else if (v instanceof int[]) {
            result = (int[])v;
        } else if (v instanceof Object[]) {
            result = new int[((Object[])v).length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (Integer)((Object[])v)[i];
            }
        } else if (v instanceof Integer) {
            result = new int[]{(Integer)v};
        } else if (v instanceof String) {
            Matcher listMatcher = LIST_PATTERN.matcher(v.toString());
            boolean intList = true;
            if (listMatcher.matches()) {
                List strings = KeyValueParser.parseList((String)listMatcher.group(1));
                ArrayList<Integer> integers = new ArrayList<Integer>();
                for (String string : strings) {
                    if (INTEGER_PATTERN.matcher(string).matches()) {
                        integers.add(Integer.parseInt(string));
                        continue;
                    }
                    intList = false;
                    break;
                }
                result = Ints.toArray(integers);
            } else {
                intList = false;
                result = null;
            }
            if (!intList) {
                throw new IllegalArgumentException("Invalid type for int[]: " + v + " of type " + v.getClass());
            }
        } else {
            throw new IllegalArgumentException("Invalid type for int[]: " + v + " of type " + v.getClass());
        }
        return result;
    }

    protected static String[] toStringArray(Object v) {
        return JcloudsLocation.toListOfStrings(v).toArray(new String[0]);
    }

    protected static List<String> toListOfStrings(Object v) {
        ArrayList result = Lists.newArrayList();
        if (v instanceof Iterable) {
            for (Object o : (Iterable)v) {
                result.add(o.toString());
            }
        } else if (v instanceof Object[]) {
            for (int i = 0; i < ((Object[])v).length; ++i) {
                result.add(((Object[])v)[i].toString());
            }
        } else if (v instanceof String) {
            result.add((String)v);
        } else {
            throw new IllegalArgumentException("Invalid type for List<String>: " + v + " of type " + v.getClass());
        }
        return result;
    }

    protected static byte[] toByteArray(Object v) {
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        if (v instanceof CharSequence) {
            return v.toString().getBytes();
        }
        throw new IllegalArgumentException("Invalid type for byte[]: " + v + " of type " + v.getClass());
    }

    protected static Map<String, String> toMapStringString(Object v) {
        if (v instanceof Map) {
            LinkedHashMap result = Maps.newLinkedHashMap();
            for (Map.Entry entry : ((Map)v).entrySet()) {
                String key = ((CharSequence)entry.getKey()).toString();
                String value = ((CharSequence)entry.getValue()).toString();
                result.put(key, value);
            }
            return result;
        }
        if (v instanceof CharSequence) {
            return KeyValueParser.parseMap((String)v.toString());
        }
        throw new IllegalArgumentException("Invalid type for Map<String,String>: " + v + (v != null ? " of type " + v.getClass() : ""));
    }

    private List<String> createIptablesRulesForNetworkInterface(Iterable<Integer> ports) {
        ArrayList iptablesRules = Lists.newArrayList();
        for (Integer port : ports) {
            iptablesRules.add(IptablesCommands.insertIptablesRule((IptablesCommands.Chain)IptablesCommands.Chain.INPUT, (Protocol)Protocol.TCP, (int)port, (IptablesCommands.Policy)IptablesCommands.Policy.ACCEPT));
        }
        return iptablesRules;
    }

    public PersistenceObjectStore newPersistenceObjectStore(String container) {
        return new JcloudsBlobStoreBasedObjectStore(this, container);
    }

    static {
        Networking.init();
        SUPPORTED_TEMPLATE_BUILDER_PROPERTIES = ImmutableMap.builder().put((Object)OS_64_BIT, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                Boolean os64Bit = (Boolean)TypeCoercions.coerce((Object)v, Boolean.class);
                if (os64Bit != null) {
                    tb.os64Bit(os64Bit.booleanValue());
                }
            }
        }).put((Object)MIN_RAM, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.minRam((int)(ByteSizeStrings.parse((String)Strings.toString((Object)v), (String)"mb") / 1000L / 1000L));
            }
        }).put((Object)MIN_CORES, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.minCores(((Double)TypeCoercions.coerce((Object)v, Double.class)).doubleValue());
            }
        }).put((Object)MIN_DISK, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.minDisk((double)((int)(ByteSizeStrings.parse((String)Strings.toString((Object)v), (String)"gb") / 1000L / 1000L / 1000L)));
            }
        }).put((Object)HARDWARE_ID, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.hardwareId(((CharSequence)v).toString());
            }
        }).put((Object)IMAGE_ID, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.imageId(((CharSequence)v).toString());
            }
        }).put((Object)IMAGE_DESCRIPTION_REGEX, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.imageDescriptionMatches(((CharSequence)v).toString());
            }
        }).put((Object)IMAGE_NAME_REGEX, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.imageNameMatches(((CharSequence)v).toString());
            }
        }).put((Object)OS_FAMILY, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                Maybe osFamily = Enums.valueOfIgnoreCase(org.jclouds.compute.domain.OsFamily.class, (String)v.toString());
                if (osFamily.isAbsent()) {
                    throw new IllegalArgumentException("Invalid " + JcloudsLocationConfig.OS_FAMILY + " value " + v);
                }
                tb.osFamily((org.jclouds.compute.domain.OsFamily)osFamily.get());
            }
        }).put((Object)OS_VERSION_REGEX, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.osVersionMatches(((CharSequence)v).toString());
            }
        }).put((Object)TEMPLATE_SPEC, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
                tb.from(TemplateBuilderSpec.parse((String)((CharSequence)v).toString()));
            }
        }).put((Object)DEFAULT_IMAGE_ID, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            }
        }).put((Object)TEMPLATE_BUILDER, (Object)new CustomizeTemplateBuilder(){

            @Override
            public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            }
        }).build();
        SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES = ImmutableMap.builder().put((Object)SECURITY_GROUPS, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof EC2TemplateOptions) {
                    String[] securityGroups = JcloudsLocation.toStringArray(v);
                    ((EC2TemplateOptions)t).securityGroups(securityGroups);
                } else if (t instanceof NovaTemplateOptions) {
                    String[] securityGroups = JcloudsLocation.toStringArray(v);
                    ((NovaTemplateOptions)t).securityGroups(securityGroups);
                } else if (t instanceof SoftLayerTemplateOptions) {
                    String[] securityGroups = JcloudsLocation.toStringArray(v);
                    ((SoftLayerTemplateOptions)t).securityGroups(securityGroups);
                } else if (t instanceof GoogleComputeEngineTemplateOptions) {
                    String[] securityGroups = JcloudsLocation.toStringArray(v);
                    ((GoogleComputeEngineTemplateOptions)t).securityGroups(securityGroups);
                } else {
                    LOG.info("ignoring securityGroups({}) in VM creation because not supported for cloud/type ({})", v, t.getClass());
                }
            }
        }).put((Object)INBOUND_PORTS, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                int[] inboundPorts = JcloudsLocation.toIntArray(v);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("opening inbound ports {} for cloud/type {}", (Object)Arrays.toString(inboundPorts), t.getClass());
                }
                t.inboundPorts(inboundPorts);
            }
        }).put((Object)USER_METADATA_STRING, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof EC2TemplateOptions) {
                    if (v == null) {
                        return;
                    }
                    String data = v.toString();
                    if (!data.startsWith("<script>") && !data.startsWith("<powershell>")) {
                        data = "<script> " + data + " </script>";
                    }
                    ((EC2TemplateOptions)t).userData(data.getBytes());
                } else if (t instanceof SoftLayerTemplateOptions) {
                    ((SoftLayerTemplateOptions)t).userData(Strings.toString((Object)v));
                } else {
                    Class<?> clazz = t.getClass();
                    Method userDataMethod = null;
                    try {
                        userDataMethod = clazz.getMethod("userData", String.class);
                    }
                    catch (SecurityException e) {
                        LOG.info("Problem reflectively inspecting methods of " + t.getClass() + " for setting userData", (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            userDataMethod = clazz.getMethod("guestCustomizationScript", String.class);
                        }
                        catch (NoSuchMethodException e2) {
                            // empty catch block
                        }
                    }
                    if (userDataMethod != null) {
                        try {
                            userDataMethod.invoke((Object)t, Strings.toString((Object)v));
                        }
                        catch (InvocationTargetException e) {
                            LOG.info("Problem invoking " + userDataMethod.getName() + " of " + t.getClass() + ", for setting userData (rethrowing)", (Throwable)e);
                            throw Exceptions.propagate((Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            LOG.debug("Unable to reflectively invoke " + userDataMethod.getName() + " of " + t.getClass() + ", for setting userData (rethrowing)", (Throwable)e);
                            throw Exceptions.propagate((Throwable)e);
                        }
                    } else {
                        LOG.info("ignoring userDataString({}) in VM creation because not supported for cloud/type ({})", v, t.getClass());
                    }
                }
            }
        }).put((Object)USER_DATA_UUENCODED, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof EC2TemplateOptions) {
                    byte[] bytes = JcloudsLocation.toByteArray(v);
                    ((EC2TemplateOptions)t).userData(bytes);
                } else if (t instanceof SoftLayerTemplateOptions) {
                    ((SoftLayerTemplateOptions)t).userData(Strings.toString((Object)v));
                } else {
                    LOG.info("ignoring userData({}) in VM creation because not supported for cloud/type ({})", v, t.getClass());
                }
            }
        }).put((Object)STRING_TAGS, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                List<String> tags = JcloudsLocation.toListOfStrings(v);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("setting VM tags {} for {}", tags, (Object)t);
                }
                t.tags(tags);
            }
        }).put((Object)USER_METADATA_MAP, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (v != null) {
                    t.userMetadata(JcloudsLocation.toMapStringString(v));
                }
            }
        }).put((Object)EXTRA_PUBLIC_KEY_DATA_TO_AUTH, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                t.authorizePublicKey(((CharSequence)v).toString());
            }
        }).put((Object)RUN_AS_ROOT, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                t.runAsRoot(((Boolean)v).booleanValue());
            }
        }).put((Object)LOGIN_USER, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (v != null) {
                    t.overrideLoginUser(((CharSequence)v).toString());
                }
            }
        }).put((Object)LOGIN_USER_PASSWORD, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (v != null) {
                    t.overrideLoginPassword(((CharSequence)v).toString());
                }
            }
        }).put((Object)LOGIN_USER_PRIVATE_KEY_FILE, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (v != null) {
                    String privateKey;
                    String privateKeyFileName = ((CharSequence)v).toString();
                    try {
                        privateKey = Files.toString((File)new File(Os.tidyPath((String)privateKeyFileName)), (Charset)Charsets.UTF_8);
                    }
                    catch (IOException e) {
                        LOG.error(privateKeyFileName + "not found", (Throwable)e);
                        throw Exceptions.propagate((Throwable)e);
                    }
                    t.overrideLoginPrivateKey(privateKey);
                }
            }
        }).put((Object)LOGIN_USER_PRIVATE_KEY_DATA, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (v != null) {
                    t.overrideLoginPrivateKey(((CharSequence)v).toString());
                }
            }
        }).put((Object)KEY_PAIR, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof EC2TemplateOptions) {
                    ((EC2TemplateOptions)t).keyPair(((CharSequence)v).toString());
                } else if (t instanceof NovaTemplateOptions) {
                    ((NovaTemplateOptions)t).keyPairName(((CharSequence)v).toString());
                } else if (t instanceof CloudStackTemplateOptions) {
                    ((CloudStackTemplateOptions)t).keyPair(((CharSequence)v).toString());
                } else {
                    LOG.info("ignoring keyPair({}) in VM creation because not supported for cloud/type ({})", v, (Object)t);
                }
            }
        }).put((Object)AUTO_GENERATE_KEYPAIRS, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof NovaTemplateOptions) {
                    ((NovaTemplateOptions)t).generateKeyPair(((Boolean)v).booleanValue());
                } else if (t instanceof CloudStackTemplateOptions) {
                    ((CloudStackTemplateOptions)t).generateKeyPair(((Boolean)v).booleanValue());
                } else {
                    LOG.info("ignoring auto-generate-keypairs({}) in VM creation because not supported for cloud/type ({})", v, (Object)t);
                }
            }
        }).put((Object)AUTO_CREATE_FLOATING_IPS, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof NovaTemplateOptions) {
                    ((NovaTemplateOptions)t).autoAssignFloatingIp(((Boolean)v).booleanValue());
                } else {
                    LOG.info("ignoring auto-generate-floating-ips({}) in VM creation because not supported for cloud/type ({})", v, (Object)t);
                }
            }
        }).put((Object)AUTO_ASSIGN_FLOATING_IP, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof NovaTemplateOptions) {
                    ((NovaTemplateOptions)t).autoAssignFloatingIp(((Boolean)v).booleanValue());
                } else if (t instanceof CloudStackTemplateOptions) {
                    ((CloudStackTemplateOptions)t).setupStaticNat(((Boolean)v).booleanValue());
                } else {
                    LOG.info("ignoring auto-assign-floating-ip({}) in VM creation because not supported for cloud/type ({})", v, (Object)t);
                }
            }
        }).put((Object)NETWORK_NAME, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                t.networks(new String[]{(String)v});
            }
        }).put((Object)DOMAIN_NAME, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions t, ConfigBag props, Object v) {
                if (t instanceof SoftLayerTemplateOptions) {
                    ((SoftLayerTemplateOptions)t).domainName((String)TypeCoercions.coerce((Object)v, String.class));
                } else {
                    LOG.info("ignoring domain-name({}) in VM creation because not supported for cloud/type ({})", v, (Object)t);
                }
            }
        }).put((Object)TEMPLATE_OPTIONS, (Object)new CustomizeTemplateOptions(){

            @Override
            public void apply(TemplateOptions options, ConfigBag config, Object v) {
                if (v == null) {
                    return;
                }
                Map optionsMap = (Map)v;
                if (optionsMap.isEmpty()) {
                    return;
                }
                Class<?> clazz = options.getClass();
                List<Method> methods = Arrays.asList(clazz.getMethods());
                for (final Map.Entry option : optionsMap.entrySet()) {
                    Optional methodOptional = Iterables.tryFind(methods, (Predicate)new Predicate<Method>(){

                        public boolean apply(@Nullable Method input) {
                            if (input == null) {
                                return false;
                            }
                            if (!input.getName().equals(option.getKey())) {
                                return false;
                            }
                            int numOptionParams = option.getValue() instanceof List ? ((List)option.getValue()).size() : 1;
                            Type[] parameterTypes = input.getGenericParameterTypes();
                            if (parameterTypes.length != numOptionParams) {
                                return false;
                            }
                            if (numOptionParams == 1 && !(option.getValue() instanceof List) && parameterTypes.length == 1) {
                                return true;
                            }
                            for (int paramCount = 0; paramCount < numOptionParams; ++paramCount) {
                                if (TypeCoercions.tryCoerce(((List)option.getValue()).get(paramCount), (TypeToken)TypeToken.of((Type)parameterTypes[paramCount])).isPresentAndNonNull()) continue;
                                return false;
                            }
                            return true;
                        }
                    });
                    if (methodOptional.isPresent()) {
                        try {
                            Method method = (Method)methodOptional.get();
                            if (option.getValue() instanceof List) {
                                ArrayList parameters = Lists.newArrayList();
                                int numOptionParams = ((List)option.getValue()).size();
                                for (int paramCount = 0; paramCount < numOptionParams; ++paramCount) {
                                    parameters.add(TypeCoercions.coerce(((List)option.getValue()).get(paramCount), (TypeToken)TypeToken.of((Type)method.getGenericParameterTypes()[paramCount])));
                                }
                                method.invoke((Object)options, parameters.toArray());
                                continue;
                            }
                            method.invoke((Object)options, TypeCoercions.coerce(option.getValue(), (TypeToken)TypeToken.of((Type)method.getGenericParameterTypes()[0])));
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw Exceptions.propagate((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                    LOG.warn("Ignoring request to set template option {} because this is not supported by {}", new Object[]{option.getKey(), clazz.getCanonicalName()});
                }
            }
        }).build();
    }

    private static class RebindToMachinePredicate
    implements Predicate<ComputeMetadata> {
        final String rawId;
        final String rawHostname;
        final String rawRegion;

        public RebindToMachinePredicate(ConfigBag config) {
            this.rawId = (String)config.getStringKey("id");
            this.rawHostname = (String)config.getStringKey("hostname");
            this.rawRegion = (String)config.getStringKey("region");
        }

        public boolean apply(ComputeMetadata input) {
            if (this.rawId != null && (this.rawId.equals(input.getId()) || this.rawRegion != null && (this.rawRegion + "/" + this.rawId).equals(input.getId()))) {
                return true;
            }
            if (input instanceof NodeMetadata) {
                NodeMetadata node = (NodeMetadata)NodeMetadata.class.cast(input);
                if (this.rawHostname != null && this.rawHostname.equalsIgnoreCase(node.getHostname())) {
                    return true;
                }
                if (this.rawHostname != null && node.getPublicAddresses().contains(this.rawHostname)) {
                    return true;
                }
                if (this.rawId != null && this.rawId.equalsIgnoreCase(node.getHostname())) {
                    return true;
                }
                if (this.rawId != null && node.getPublicAddresses().contains(this.rawId)) {
                    return true;
                }
                if (this.rawId != null && this.rawId.equalsIgnoreCase(node.getProviderId())) {
                    return true;
                }
                if (this.rawHostname != null && this.rawHostname.equalsIgnoreCase(node.getProviderId())) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.rawId).add("hostname", (Object)this.rawHostname).add("region", (Object)this.rawRegion).toString();
        }
    }

    protected static class UserCreation {
        public final LoginCredentials createdUserCredentials;
        public final List<Statement> statements;

        public UserCreation(LoginCredentials creds, List<Statement> statements) {
            this.createdUserCredentials = creds;
            this.statements = statements;
        }
    }

    public static interface CustomizeTemplateOptions {
        public void apply(TemplateOptions var1, ConfigBag var2, Object var3);
    }

    private static interface CustomizeTemplateBuilder {
        public void apply(TemplateBuilder var1, ConfigBag var2, Object var3);
    }
}

