/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.LocationSpec;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.location.basic.FixedListMachineProvisioningLocation;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsPropertiesFromBrooklynProperties;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.KeyValueParser;
import brooklyn.util.text.Strings;
import brooklyn.util.text.WildcardGlobs;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsByonLocationResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(JcloudsByonLocationResolver.class);
    public static final String BYON = "jcloudsByon";
    private static final Pattern PATTERN = Pattern.compile("(jcloudsByon|" + "jcloudsByon".toUpperCase() + ")" + ":" + "\\((.*)\\)$");
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public FixedListMachineProvisioningLocation<JcloudsSshMachineLocation> newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        Map globalProperties = registry.getProperties();
        Matcher matcher = PATTERN.matcher(spec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; must specify something like jcloudsByon(provider=\"aws-ec2\",region=\"us-east-1\",hosts=\"i-f2014593,i-d1234567\")");
        }
        String argsPart = matcher.group(2);
        Map argsMap = KeyValueParser.parseMap((String)argsPart);
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        String providerOrApi = argsMap.containsKey("provider") ? (String)argsMap.get("provider") : (String)locationFlags.get("provider");
        String regionName = argsMap.containsKey("region") ? (String)argsMap.get("region") : (String)locationFlags.get("region");
        String endpoint = argsMap.containsKey("endpoint") ? (String)argsMap.get("endpoint") : (String)locationFlags.get("endpoint");
        String name = argsMap.containsKey("name") ? (String)argsMap.get("name") : (String)locationFlags.get("name");
        String user = argsMap.containsKey("user") ? (String)argsMap.get("user") : (String)locationFlags.get("user");
        String privateKeyFile = argsMap.containsKey("privateKeyFile") ? (String)argsMap.get("privateKeyFile") : (String)locationFlags.get("privateKeyFile");
        String hosts = (String)argsMap.get("hosts");
        if (Strings.isEmpty((CharSequence)providerOrApi)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; provider must be defined");
        }
        if (hosts == null || hosts.isEmpty()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        if (argsMap.containsKey("name") && Strings.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; if name supplied then value must be non-empty");
        }
        Map allProperties = this.getAllProperties(registry, globalProperties);
        Map<String, Object> jcloudsProperties = new JcloudsPropertiesFromBrooklynProperties().getJcloudsProperties(providerOrApi, regionName, namedLocation, allProperties);
        jcloudsProperties.putAll(locationFlags);
        jcloudsProperties.putAll(argsMap);
        String jcloudsSpec = "jclouds:" + providerOrApi + (regionName != null ? ":" + regionName : "") + (endpoint != null ? ":" + endpoint : "");
        JcloudsLocation jcloudsLocation = (JcloudsLocation)registry.resolve(jcloudsSpec, jcloudsProperties);
        List hostIdentifiers = WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + hosts + "}"), (boolean)true, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR);
        ArrayList machines = Lists.newArrayList();
        for (String hostIdentifier : hostIdentifiers) {
            MutableMap machineFlags = MutableMap.builder().put((Object)"id", (Object)hostIdentifier).putIfNotNull((Object)"user", (Object)user).putIfNotNull((Object)"privateKeyFile", (Object)privateKeyFile).build();
            try {
                JcloudsSshMachineLocation machine = jcloudsLocation.rebindMachine(jcloudsLocation.config().getBag().putAll((Map)machineFlags));
                machines.add(machine);
            }
            catch (NoMachinesAvailableException e) {
                log.warn("Error rebinding to jclouds machine " + hostIdentifier + " in " + jcloudsLocation, (Throwable)e);
                Exceptions.propagate((Throwable)e);
            }
        }
        ConfigBag flags = ConfigBag.newInstance(jcloudsProperties);
        flags.putStringKey("machines", (Object)machines);
        flags.putIfNotNull(LocationConfigKeys.USER, (Object)user);
        flags.putStringKeyIfNotNull("name", (Object)name);
        if (registry != null) {
            LocationPropertiesFromBrooklynProperties.setLocalTempDir((Map)registry.getProperties(), (ConfigBag)flags);
        }
        log.debug("Created Jclouds BYON location " + name + ": " + machines);
        return (FixedListMachineProvisioningLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(FixedListMachineProvisioningLocation.class).configure(flags.getAllConfig()).configure(LocationConfigUtils.finalAndOriginalSpecs((String)spec, (Object[])new Object[]{locationFlags, globalProperties, namedLocation})));
    }

    private Map getAllProperties(LocationRegistry registry, Map<?, ?> properties) {
        HashMap allProperties = Maps.newHashMap();
        if (registry != null) {
            allProperties.putAll(registry.getProperties());
        }
        allProperties.putAll(properties);
        return allProperties;
    }

    public String getPrefix() {
        return BYON;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec((LocationResolver)this, (String)spec, (boolean)true);
    }
}

