/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.entity.basic.Sanitizer;
import brooklyn.location.jclouds.ComputeServiceRegistry;
import brooklyn.location.jclouds.JcloudsLocationConfig;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Module;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.encryption.bouncycastle.config.BouncyCastleCryptoModule;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeServiceRegistryImpl
implements ComputeServiceRegistry,
JcloudsLocationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeServiceRegistryImpl.class);
    public static final ComputeServiceRegistryImpl INSTANCE = new ComputeServiceRegistryImpl();
    protected final Map<Map<?, ?>, ComputeService> cachedComputeServices = new ConcurrentHashMap();
    protected final Object createComputeServicesMutex = new Object();

    protected ComputeServiceRegistryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeService findComputeService(ConfigBag conf, boolean allowReuse) {
        ComputeServiceContext computeServiceContext;
        Map extra;
        String provider = (String)Preconditions.checkNotNull((Object)conf.get(CLOUD_PROVIDER), (Object)"provider must not be null");
        String identity = (String)Preconditions.checkNotNull((Object)conf.get(ACCESS_IDENTITY), (Object)"identity must not be null");
        String credential = (String)Preconditions.checkNotNull((Object)conf.get(ACCESS_CREDENTIAL), (Object)"credential must not be null");
        Properties properties = new Properties();
        properties.setProperty("jclouds.trust-all-certs", Boolean.toString(true));
        properties.setProperty("jclouds.relax-hostname", Boolean.toString(true));
        properties.setProperty("jclouds.ssh.max-retries", conf.getStringKey("jclouds.ssh.max-retries") != null ? conf.getStringKey("jclouds.ssh.max-retries").toString() : "50");
        if ("aws-ec2".equals(provider)) {
            if (JavaGroovyEquivalents.groovyTruth((String)((String)conf.get(IMAGE_ID)))) {
                properties.setProperty("jclouds.ec2.ami-query", "");
                properties.setProperty("jclouds.ec2.cc-ami-query", "");
            } else if (JavaGroovyEquivalents.groovyTruth((Object)conf.getStringKey("imageOwner"))) {
                properties.setProperty("jclouds.ec2.ami-query", "owner-id=" + conf.getStringKey("imageOwner") + ";state=available;image-type=machine");
            } else if (JavaGroovyEquivalents.groovyTruth((Object)conf.getStringKey("anyOwner"))) {
                properties.setProperty("jclouds.ec2.ami-query", "state=available;image-type=machine");
            }
        }
        if ((extra = Maps.filterKeys((Map)conf.getAllConfig(), (Predicate)Predicates.containsPattern((String)"^jclouds\\."))).size() > 0) {
            LOG.warn("Jclouds using deprecated property overrides: " + Sanitizer.sanitize((Map)extra));
        }
        properties.putAll((Map<?, ?>)extra);
        String endpoint = (String)conf.get(CLOUD_ENDPOINT);
        if (!JavaGroovyEquivalents.groovyTruth((String)endpoint)) {
            endpoint = this.getDeprecatedProperty(conf, "jclouds.endpoint");
        }
        if (JavaGroovyEquivalents.groovyTruth((String)endpoint)) {
            properties.setProperty("jclouds.endpoint", endpoint);
        }
        Map cacheKey = MutableMap.builder().putAll((Map)properties).put((Object)"provider", (Object)provider).put((Object)"identity", (Object)identity).put((Object)"credential", (Object)credential).putIfNotNull((Object)"endpoint", (Object)endpoint).build().asUnmodifiable();
        if (allowReuse) {
            ComputeService result = this.cachedComputeServices.get(cacheKey);
            if (result != null) {
                LOG.trace("jclouds ComputeService cache hit for compute service, for " + Sanitizer.sanitize((Map)properties));
                return result;
            }
            LOG.debug("jclouds ComputeService cache miss for compute service, creating, for " + Sanitizer.sanitize((Map)properties));
        }
        ImmutableSet<Module> modules = this.getCommonModules();
        Object object = this.createComputeServicesMutex;
        synchronized (object) {
            computeServiceContext = (ComputeServiceContext)ContextBuilder.newBuilder((String)provider).modules(modules).credentials(identity, credential).overrides(properties).build(ComputeServiceContext.class);
        }
        ComputeService computeService = computeServiceContext.getComputeService();
        if (allowReuse) {
            Map<Map<?, ?>, ComputeService> map = this.cachedComputeServices;
            synchronized (map) {
                ComputeService result = this.cachedComputeServices.get(cacheKey);
                if (result != null) {
                    LOG.debug("jclouds ComputeService cache recovery for compute service, for " + Sanitizer.sanitize((Map)cacheKey));
                    computeService.getContext().close();
                    return result;
                }
                LOG.debug("jclouds ComputeService created " + computeService + ", adding to cache, for " + Sanitizer.sanitize((Map)properties));
                this.cachedComputeServices.put(cacheKey, computeService);
            }
        }
        return computeService;
    }

    protected ImmutableSet<Module> getCommonModules() {
        return ImmutableSet.of((Object)new SshjSshClientModule(), (Object)new SLF4JLoggingModule(), (Object)new BouncyCastleCryptoModule());
    }

    protected String getDeprecatedProperty(ConfigBag conf, String key) {
        if (conf.containsKey(key)) {
            LOG.warn("Jclouds using deprecated brooklyn-jclouds property " + key + ": " + Sanitizer.sanitize((Map)conf.getAllConfig()));
            return (String)conf.getStringKey(key);
        }
        return null;
    }
}

