/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.entity.Entity;
import brooklyn.entity.trait.Startable;
import brooklyn.location.MachineLocation;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsSshMachineLocation;
import brooklyn.location.jclouds.pool.MachinePool;
import brooklyn.location.jclouds.pool.MachinePoolPredicates;
import brooklyn.location.jclouds.pool.MachineSet;
import brooklyn.location.jclouds.pool.ReusableMachineTemplate;
import brooklyn.management.Task;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.task.BasicExecutionContext;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.domain.NodeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BrooklynMachinePool
extends MachinePool {
    private static final Logger log = LoggerFactory.getLogger(BrooklynMachinePool.class);
    protected final JcloudsLocation location;
    final List<Task<?>> activeTasks = new ArrayList();
    final String providerLocationId;

    public BrooklynMachinePool(JcloudsLocation l) {
        super(l.getComputeService());
        this.providerLocationId = l.getRegion();
        this.location = l;
    }

    public SshMachineLocation obtain(ReusableMachineTemplate t) {
        MachineSet previous = this.unclaimed(MachinePoolPredicates.matching(t));
        while (true) {
            NodeMetadata m = this.claim(1, t).iterator().next();
            SshMachineLocation result = null;
            try {
                result = this.toSshMachineLocation(m);
            }
            catch (Exception e) {
                if (previous.contains(m)) {
                    log.debug("attempt to bind to previous existing machine " + m + " failed (will blacklist and retry another): " + e);
                }
                log.warn("attempt to bind to machine " + m + " failed: " + e);
                throw Throwables.propagate((Throwable)e);
            }
            if (result != null) {
                return result;
            }
            if (!previous.contains(m)) break;
            log.debug("could not bind to previous existing machine " + m + "; blacklisting and trying a new one");
            this.addToBlacklist(new MachineSet(m));
        }
        throw new IllegalStateException("cannot bind/connect to newly created machine; error in configuration");
    }

    @Override
    protected MachineSet filterForAllowedMachines(MachineSet input) {
        MachineSet result = super.filterForAllowedMachines(input);
        if (this.providerLocationId != null) {
            result = result.filtered(MachinePoolPredicates.matching(((ReusableMachineTemplate)new ReusableMachineTemplate().locationId(this.providerLocationId)).strict(false)));
        }
        return result;
    }

    protected SshMachineLocation toSshMachineLocation(NodeMetadata m) {
        try {
            JcloudsSshMachineLocation sshM = this.location.rebindMachine(m);
            if (sshM.execCommands("check-reachable", Arrays.asList("whoami")) != 0) {
                log.warn("cannot bind to machine " + m);
                return null;
            }
            return sshM;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public MachineSet create(int count, ReusableMachineTemplate template) {
        ArrayList<NodeMetadata> nodes = new ArrayList<NodeMetadata>();
        for (int i = 0; i < count; ++i) {
            JcloudsSshMachineLocation m;
            try {
                MachineLocation machineLocation = this.location.obtain((Map<?, ?>)MutableMap.of((Object)"callerContext", (Object)("" + this + "(" + template + ")")), template);
                if (!(machineLocation instanceof JcloudsSshMachineLocation)) {
                    throw new UnsupportedOperationException("Cannot create WinRmMachineLocation");
                }
                m = (JcloudsSshMachineLocation)machineLocation;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            nodes.add(m.getNode());
        }
        MachineSet result = new MachineSet(nodes);
        this.registerNewNodes(result, template);
        return result;
    }

    public boolean unclaim(SshMachineLocation location) {
        this.init();
        if (location instanceof JcloudsSshMachineLocation) {
            return this.unclaim(new MachineSet(((JcloudsSshMachineLocation)location).getNode())) > 0;
        }
        return false;
    }

    public boolean destroy(SshMachineLocation location) {
        this.init();
        if (location instanceof JcloudsSshMachineLocation) {
            return this.destroy(new MachineSet(((JcloudsSshMachineLocation)location).getNode())) > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Task<T> addTask(Task<T> t) {
        List<Task<?>> list = this.activeTasks;
        synchronized (list) {
            this.activeTasks.add(t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task<?>> getActiveTasks() {
        ImmutableList result;
        List<Task<?>> list = this.activeTasks;
        synchronized (list) {
            result = ImmutableList.copyOf(this.activeTasks);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilTasksEnded() {
        while (true) {
            boolean allDone = true;
            List<Task<?>> tt = this.getActiveTasks();
            for (Task<?> t : tt) {
                if (t.isDone()) continue;
                allDone = false;
                if (log.isDebugEnabled()) {
                    log.debug("Pool " + this + ", blocking for completion of: " + t);
                }
                t.blockUntilEnded();
            }
            List<Task<?>> list = this.activeTasks;
            synchronized (list) {
                ArrayList newTT = new ArrayList(this.getActiveTasks());
                newTT.removeAll(tt);
                if (allDone && tt.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Pool " + this + ", all known tasks have completed, clearing list");
                    }
                    this.activeTasks.clear();
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Pool " + this + ", all previously known tasks have completed, but there are new tasks (" + newTT + ") checking them");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<?> start(final ReusableMachineTemplate template, final List<? extends Startable> entities) {
        AtomicReference<Task> t;
        BasicExecutionContext ctx = BasicExecutionContext.getCurrentExecutionContext();
        if (ctx == null) {
            throw new IllegalStateException("Pool.start is only permitted within a task (effector)");
        }
        AtomicReference<Task> atomicReference = t = new AtomicReference<Task>();
        synchronized (atomicReference) {
            t.set(ctx.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicReference atomicReference = t;
                    synchronized (atomicReference) {
                        if (log.isDebugEnabled()) {
                            log.debug("Pool " + this + ", task " + t.get() + " claiming a " + template);
                        }
                        SshMachineLocation m = BrooklynMachinePool.this.obtain(template);
                        if (log.isDebugEnabled()) {
                            log.debug("Pool " + this + ", task " + t.get() + " got " + m + "; starting " + entities);
                        }
                        for (Startable entity : entities) {
                            BrooklynMachinePool.this.addTask(((Entity)entity).invoke(Startable.START, (Map)MutableMap.of((Object)"locations", Arrays.asList(m))));
                        }
                    }
                }
            }));
        }
        this.addTask((Task)t.get());
        return (Task)t.get();
    }

    public Task<?> start(ReusableMachineTemplate template, Startable ... entities) {
        return this.start(template, Arrays.asList(entities));
    }
}

