/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.util.collections.MutableList;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.common.math.DoubleMath;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BrooklynImageChooser
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(BrooklynImageChooser.class);
    protected ComputeService computeService;
    protected String cloudProviderName;

    protected static int compare(double left, double right) {
        return DoubleMath.fuzzyCompare((double)left, (double)right, (double)1.0E-8);
    }

    protected static boolean imageNameContains(Image img, String pattern) {
        if (img.getName() == null) {
            return false;
        }
        return img.getName().contains(pattern);
    }

    protected static boolean imageNameContainsCaseInsensitive(Image img, String pattern) {
        if (img.getName() == null) {
            return false;
        }
        return img.getName().toLowerCase().contains(pattern.toLowerCase());
    }

    protected static boolean imageNameContainsWordCaseInsensitive(Image img, String pattern) {
        if (img.getName() == null) {
            return false;
        }
        return img.getName().toLowerCase().matches("(.*[^a-z])?" + pattern.toLowerCase() + "([^a-z].*)?");
    }

    public double punishmentForOldOsVersions(Image img, OsFamily family, double minVersion) {
        String v;
        OperatingSystem os = img.getOperatingSystem();
        if (os != null && family.equals((Object)os.getFamily()) && (v = os.getVersion()) != null) {
            try {
                double vd = Double.parseDouble(v);
                if (vd < minVersion) {
                    return -Math.log(1.0 + (minVersion - vd));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public List<String> blackListedImageIds() {
        return Arrays.asList("us-east-1/ami-1cb30875", "us-east-1/ami-08faa660");
    }

    public List<String> whilelistedImageIds() {
        return Arrays.asList(new Object[0]);
    }

    public double score(Image img) {
        double score = 0.0;
        if (this.blackListedImageIds().contains(img.getId())) {
            score -= 50.0;
        }
        if (this.whilelistedImageIds().contains(img.getId())) {
            score += 20.0;
        }
        score += this.punishmentForDeprecation(img);
        score += this.punishmentForOldOsVersions(img, OsFamily.UBUNTU, 11.0);
        score += this.punishmentForOldOsVersions(img, OsFamily.CENTOS, 6.0);
        OperatingSystem os = img.getOperatingSystem();
        if (os != null) {
            if (os.getFamily() != null) {
                if (os.getFamily().equals((Object)OsFamily.CENTOS)) {
                    score += 2.0;
                } else if (os.getFamily().equals((Object)OsFamily.UBUNTU)) {
                    score += 2.0;
                    if ("14.04".equals(os.getVersion())) {
                        score += 0.2;
                    } else if ("12.04".equals(os.getVersion())) {
                        score += 0.1;
                    }
                } else if (os.getFamily().equals((Object)OsFamily.RHEL)) {
                    score += 1.0;
                } else if (os.getFamily().equals((Object)OsFamily.AMZN_LINUX)) {
                    score += 1.0;
                } else if (os.getFamily().equals((Object)OsFamily.DEBIAN)) {
                    score += 1.0;
                } else if (os.getFamily().equals((Object)OsFamily.WINDOWS)) {
                    score -= 1.0;
                }
                if ("softlayer".equals(this.cloudProviderName) && img.getId().toLowerCase().indexOf(os.getFamily().toString().toLowerCase()) >= 0) {
                    score += 0.5;
                }
            }
            if (os.is64Bit()) {
                score += 0.5;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("initial score " + score + " for " + img);
        }
        return score;
    }

    protected double punishmentForDeprecation(Image img) {
        String deprecated = (String)img.getUserMetadata().get("deprecatedState");
        if (deprecated != null) {
            if ("deprecated".equalsIgnoreCase(deprecated)) {
                return -30.0;
            }
            log.warn("Unrecognised 'deprecatedState' value '" + deprecated + "' when scoring " + img + "; ignoring that metadata");
        }
        if (BrooklynImageChooser.imageNameContainsWordCaseInsensitive(img, "deprecated")) {
            return -30.0;
        }
        if (BrooklynImageChooser.imageNameContainsWordCaseInsensitive(img, "alpha")) {
            return -10.0;
        }
        if (BrooklynImageChooser.imageNameContainsWordCaseInsensitive(img, "beta")) {
            return -5.0;
        }
        if (BrooklynImageChooser.imageNameContainsWordCaseInsensitive(img, "testing")) {
            return -5.0;
        }
        if (BrooklynImageChooser.imageNameContainsWordCaseInsensitive(img, "rc")) {
            return -3.0;
        }
        return 0.0;
    }

    public BrooklynImageChooser clone() {
        return new BrooklynImageChooser();
    }

    protected void use(ComputeService service) {
        if (this.computeService != null && !this.computeService.equals(service)) {
            throw new IllegalStateException("ImageChooser must be cloned to set a compute service");
        }
        this.computeService = service;
        if (this.computeService != null) {
            this.cloudProviderName = this.computeService.getContext().unwrap().getId();
        }
    }

    public BrooklynImageChooser cloneFor(ComputeService service) {
        BrooklynImageChooser result = this.clone();
        result.use(service);
        return result;
    }

    public Ordering<Image> orderingScoredWithoutDefaults() {
        return new OrderingScoredWithoutDefaults(this);
    }

    @Deprecated
    public Ordering<Image> orderingScoredWithoutDefaultsDeprecated() {
        return new Ordering<Image>(){

            public int compare(Image left, Image right) {
                return BrooklynImageChooser.compare(BrooklynImageChooser.this.score(left), BrooklynImageChooser.this.score(right));
            }
        };
    }

    public static Ordering<Image> orderingWithDefaults(Ordering<Image> primaryOrdering) {
        return new OrderingWithDefaults(primaryOrdering);
    }

    @Deprecated
    public static Ordering<Image> orderingWithDefaultsDeprecated(final Ordering<Image> primaryOrdering) {
        return new Ordering<Image>(){

            public int compare(Image left, Image right) {
                return ComparisonChain.start().compare((Object)left, (Object)right, (Comparator)primaryOrdering).compare((Object)left.getName(), (Object)right.getName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getVersion(), (Object)right.getVersion(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getDescription(), (Object)right.getDescription(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getName(), (Object)right.getOperatingSystem().getName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getVersion(), (Object)right.getOperatingSystem().getVersion(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getDescription(), (Object)right.getOperatingSystem().getDescription(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getArch(), (Object)right.getOperatingSystem().getArch(), (Comparator)Ordering.natural().nullsFirst()).result();
            }
        };
    }

    public static Function<Iterable<? extends Image>, Image> imageChooserFromOrdering(Ordering<Image> ordering) {
        return new ImageChooserFromOrdering(ordering);
    }

    @Deprecated
    public static Function<Iterable<? extends Image>, Image> imageChooserFromOrderingDeprecated(final Ordering<Image> ordering) {
        return new Function<Iterable<? extends Image>, Image>(){

            public Image apply(Iterable<? extends Image> input) {
                List<? extends Image> maxImages = BrooklynImageChooser.multiMax(ordering, input);
                return maxImages.get(maxImages.size() - 1);
            }
        };
    }

    public static <T> T cloneFor(T item, ComputeService service) {
        if (item instanceof ComputeServiceAwareChooser) {
            return ((ComputeServiceAwareChooser)item).cloneFor(service);
        }
        return item;
    }

    static <T, E extends T> List<E> multiMax(Comparator<T> ordering, Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        MutableList maxes = MutableList.of(iterator.next());
        Object maxSoFar = maxes.get(0);
        while (iterator.hasNext()) {
            E current = iterator.next();
            int comparison = ordering.compare(maxSoFar, current);
            if (comparison == 0) {
                maxes.add(current);
                continue;
            }
            if (comparison >= 0) continue;
            maxes = MutableList.of(current);
            maxSoFar = current;
        }
        return maxes;
    }

    public Ordering<Image> ordering() {
        return BrooklynImageChooser.orderingWithDefaults(this.orderingScoredWithoutDefaults());
    }

    public Function<Iterable<? extends Image>, Image> chooser() {
        return BrooklynImageChooser.imageChooserFromOrdering(this.ordering());
    }

    protected static interface ComputeServiceAwareChooser<T> {
        public T cloneFor(ComputeService var1);
    }

    public static class ImageChooserFromOrdering
    implements Function<Iterable<? extends Image>, Image>,
    ComputeServiceAwareChooser<ImageChooserFromOrdering> {
        final Ordering<Image> ordering;

        public ImageChooserFromOrdering(Ordering<Image> ordering) {
            this.ordering = ordering;
        }

        public Image apply(Iterable<? extends Image> input) {
            List<? extends Image> maxImages = BrooklynImageChooser.multiMax(this.ordering, input);
            return maxImages.get(maxImages.size() - 1);
        }

        @Override
        public ImageChooserFromOrdering cloneFor(ComputeService service) {
            if (this.ordering instanceof ComputeServiceAwareChooser) {
                return new ImageChooserFromOrdering(BrooklynImageChooser.cloneFor(this.ordering, service));
            }
            return this;
        }
    }

    public static class OrderingWithDefaults
    extends Ordering<Image>
    implements ComputeServiceAwareChooser<OrderingWithDefaults> {
        Ordering<Image> primaryOrdering;

        public OrderingWithDefaults(Ordering<Image> primaryOrdering) {
            this.primaryOrdering = primaryOrdering;
        }

        public int compare(Image left, Image right) {
            return ComparisonChain.start().compare((Object)left, (Object)right, this.primaryOrdering).compare((Object)left.getName(), (Object)right.getName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getVersion(), (Object)right.getVersion(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getDescription(), (Object)right.getDescription(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getName(), (Object)right.getOperatingSystem().getName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getVersion(), (Object)right.getOperatingSystem().getVersion(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getDescription(), (Object)right.getOperatingSystem().getDescription(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.getOperatingSystem().getArch(), (Object)right.getOperatingSystem().getArch(), (Comparator)Ordering.natural().nullsFirst()).result();
        }

        @Override
        public OrderingWithDefaults cloneFor(ComputeService service) {
            if (this.primaryOrdering instanceof ComputeServiceAwareChooser) {
                return new OrderingWithDefaults(BrooklynImageChooser.cloneFor(this.primaryOrdering, service));
            }
            return this;
        }
    }

    public static class OrderingScoredWithoutDefaults
    extends Ordering<Image>
    implements ComputeServiceAwareChooser<OrderingScoredWithoutDefaults> {
        private BrooklynImageChooser chooser;

        public OrderingScoredWithoutDefaults(BrooklynImageChooser chooser) {
            this.chooser = chooser;
        }

        public int compare(Image left, Image right) {
            return BrooklynImageChooser.compare(this.chooser.score(left), this.chooser.score(right));
        }

        @Override
        public OrderingScoredWithoutDefaults cloneFor(ComputeService service) {
            return new OrderingScoredWithoutDefaults(this.chooser.cloneFor(service));
        }
    }
}

