/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister.jclouds;

import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.Charsets;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.util.Strings2;

public class JcloudsStoreObjectAccessor
implements PersistenceObjectStore.StoreObjectAccessor {
    private final BlobStore blobStore;
    private final String containerName;
    private final String blobName;

    public JcloudsStoreObjectAccessor(BlobStore blobStore, String containerName, String blobNameOptionallyWithPath) {
        this.blobStore = blobStore;
        this.containerName = containerName;
        this.blobName = blobNameOptionallyWithPath;
    }

    public boolean exists() {
        return this.blobStore.blobExists(this.containerName, this.blobName);
    }

    public void put(String val) {
        Blob blob;
        if (val == null) {
            val = "";
        }
        this.blobStore.createContainerInLocation(null, this.containerName);
        ByteSource payload = ByteSource.wrap((byte[])val.getBytes(Charsets.UTF_8));
        try {
            blob = this.blobStore.blobBuilder(this.blobName).payload(payload).contentLength(payload.size()).build();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.blobStore.putBlob(this.containerName, blob);
    }

    public void append(String val) {
        String val0 = this.get();
        if (val0 == null) {
            val0 = "";
        }
        if (val == null) {
            val = "";
        }
        this.put(val0 + val);
    }

    public void delete() {
        this.blobStore.removeBlob(this.containerName, this.blobName);
    }

    public String get() {
        try {
            Blob blob = this.blobStore.getBlob(this.containerName, this.blobName);
            if (blob == null) {
                return null;
            }
            return Strings2.toStringAndClose((InputStream)blob.getPayload().openStream());
        }
        catch (IOException e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Error reading blobstore " + this.containerName + " " + this.blobName + ": " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        byte[] byArray;
        Blob blob = this.blobStore.getBlob(this.containerName, this.blobName);
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = blob.getPayload().openStream();
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalStateException("Error reading blobstore " + this.containerName + " " + this.blobName + ": " + e, e);
            }
        }
        out.close();
        return byArray;
    }

    public Date getLastModifiedDate() {
        Blob blob = this.blobStore.getBlob(this.containerName, this.blobName);
        if (blob == null) {
            return null;
        }
        return blob.getMetadata().getLastModified();
    }
}

