/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister.jclouds;

import brooklyn.config.BrooklynServerConfig;
import brooklyn.entity.rebind.persister.PersistMode;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.entity.rebind.persister.jclouds.JcloudsStoreObjectAccessor;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsUtil;
import brooklyn.management.ManagementContext;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.annotation.Nullable;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsBlobStoreBasedObjectStore
implements PersistenceObjectStore {
    private static final Logger log = LoggerFactory.getLogger(JcloudsBlobStoreBasedObjectStore.class);
    private final String containerNameFirstPart;
    private final String containerSubPath;
    private String locationSpec;
    private JcloudsLocation location;
    private BlobStoreContext context;
    private ManagementContext mgmt;

    public JcloudsBlobStoreBasedObjectStore(String locationSpec, String containerName) {
        this.locationSpec = locationSpec;
        String[] segments = this.splitOnce(containerName);
        this.containerNameFirstPart = segments[0];
        this.containerSubPath = segments[1];
    }

    private String[] splitOnce(String path) {
        String separator = this.subPathSeparator();
        int index = path.indexOf(separator);
        if (index < 0) {
            return new String[]{path, ""};
        }
        return new String[]{path.substring(0, index), path.substring(index + separator.length())};
    }

    public JcloudsBlobStoreBasedObjectStore(JcloudsLocation location, String containerName) {
        this.location = location;
        String[] segments = this.splitOnce(containerName);
        this.containerNameFirstPart = segments[0];
        this.containerSubPath = segments[1];
        this.getBlobStoreContext();
    }

    public String getSummaryName() {
        return (this.locationSpec != null ? this.locationSpec : this.location) + ":" + this.getContainerNameFull();
    }

    public synchronized BlobStoreContext getBlobStoreContext() {
        if (this.context == null) {
            if (this.location == null) {
                Preconditions.checkNotNull((Object)this.locationSpec, (Object)"locationSpec required for remote object store when location is null");
                Preconditions.checkNotNull((Object)this.mgmt, (Object)"mgmt not injected / object store not prepared");
                this.location = (JcloudsLocation)this.mgmt.getLocationRegistry().resolve(this.locationSpec);
            }
            String identity = (String)Preconditions.checkNotNull((Object)this.location.getConfig(LocationConfigKeys.ACCESS_IDENTITY), (Object)"identity must not be null");
            String credential = (String)Preconditions.checkNotNull((Object)this.location.getConfig(LocationConfigKeys.ACCESS_CREDENTIAL), (Object)"credential must not be null");
            String provider = (String)Preconditions.checkNotNull((Object)this.location.getConfig(LocationConfigKeys.CLOUD_PROVIDER), (Object)"provider must not be null");
            String endpoint = (String)this.location.getConfig(CloudLocationConfig.CLOUD_ENDPOINT);
            this.context = JcloudsUtil.newBlobstoreContext(provider, endpoint, identity, credential);
            this.context.getBlobStore().createContainerInLocation(null, this.getContainerNameFirstPart());
        }
        return this.context;
    }

    public void prepareForMasterUse() {
    }

    public String getContainerName() {
        return this.getContainerNameFull();
    }

    protected String getContainerNameFull() {
        return this.mergePaths(this.containerNameFirstPart, this.containerSubPath);
    }

    protected String getContainerNameFirstPart() {
        return this.containerNameFirstPart;
    }

    protected String getItemInContainerSubPath(String path) {
        if (Strings.isBlank((CharSequence)this.containerSubPath)) {
            return path;
        }
        return this.mergePaths(this.containerSubPath, path);
    }

    public void createSubPath(String subPath) {
    }

    protected void checkPrepared() {
        if (this.context == null) {
            throw new IllegalStateException("object store not prepared");
        }
    }

    public PersistenceObjectStore.StoreObjectAccessor newAccessor(String path) {
        this.checkPrepared();
        return new JcloudsStoreObjectAccessor(this.context.getBlobStore(), this.getContainerNameFirstPart(), this.getItemInContainerSubPath(path));
    }

    protected String mergePaths(String basePath, String ... subPaths) {
        StringBuilder result = new StringBuilder(basePath);
        for (String subPath : subPaths) {
            if (result.length() <= 0 || subPath.length() <= 0) continue;
            result.append(this.subPathSeparator());
            result.append(subPath);
        }
        return result.toString();
    }

    protected String subPathSeparator() {
        return "/";
    }

    public List<String> listContentsWithSubPath(String parentSubPath) {
        this.checkPrepared();
        return FluentIterable.from((Iterable)this.context.getBlobStore().list(this.getContainerNameFirstPart(), ListContainerOptions.Builder.inDirectory((String)this.getItemInContainerSubPath(parentSubPath)))).transform((Function)new Function<StorageMetadata, String>(){

            public String apply(@Nullable StorageMetadata input) {
                String result = input.getName();
                result = Strings.removeFromStart((String)result, (String)JcloudsBlobStoreBasedObjectStore.this.containerSubPath);
                result = Strings.removeFromStart((String)result, (String)"/");
                return result;
            }
        }).toList();
    }

    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("blobStoreContext", (Object)this.context).add("basedir", (Object)this.containerNameFirstPart).toString();
    }

    public void injectManagementContext(ManagementContext mgmt) {
        if (this.mgmt != null && !this.mgmt.equals(mgmt)) {
            throw new IllegalStateException("Cannot change mgmt context of " + this);
        }
        this.mgmt = mgmt;
    }

    public void prepareForSharedUse(@Nullable PersistMode persistMode, HighAvailabilityMode haMode) {
        if (this.mgmt == null) {
            throw new NullPointerException("Must inject ManagementContext before preparing " + this);
        }
        this.getBlobStoreContext();
        if (persistMode == null || persistMode == PersistMode.DISABLED) {
            log.warn("Should not be using " + this + " when persistMode is " + persistMode);
            return;
        }
        Boolean backups = (Boolean)this.mgmt.getConfig().getConfig(BrooklynServerConfig.PERSISTENCE_BACKUPS_REQUIRED);
        if (Boolean.TRUE.equals(backups)) {
            log.warn("Using legacy backup for " + this + "; functionality will be removed in future versions, in favor of promotion/demotion-specific backups to a configurable backup location.");
            throw new FatalConfigurationRuntimeException("Backups not supported for object store (" + this + ")");
        }
    }

    public void deleteCompletely() {
        if (Strings.isBlank((CharSequence)this.containerSubPath)) {
            this.getBlobStoreContext().getBlobStore().deleteContainer(this.containerNameFirstPart);
        } else {
            this.newAccessor(this.containerSubPath).delete();
        }
    }
}

