/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.okhttp;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jclouds.JcloudsVersion;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;

public final class OkHttpCommandExecutorService
extends BaseHttpCommandExecutorService<Request> {
    private static final String DEFAULT_USER_AGENT = String.format("jclouds-okhttp/%s java/%s", JcloudsVersion.get(), System.getProperty("java.version"));
    private final Function<URI, Proxy> proxyForURI;
    private final OkHttpClient globalClient;

    @Inject
    OkHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, Function<URI, Proxy> proxyForURI, OkHttpClient okHttpClient) {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire);
        this.proxyForURI = proxyForURI;
        this.globalClient = okHttpClient;
    }

    protected Request convert(HttpRequest request) throws IOException, InterruptedException {
        Long length;
        Request.Builder builder = new Request.Builder();
        builder.url(request.getEndpoint().toString());
        this.populateHeaders(request, builder);
        RequestBody body = null;
        Payload payload = request.getPayload();
        if (payload != null && (length = (Long)Preconditions.checkNotNull((Object)payload.getContentMetadata().getContentLength(), (Object)"payload.getContentLength")) > 0L) {
            body = this.generateRequestBody(request, payload);
        }
        builder.method(request.getMethod(), body);
        return builder.build();
    }

    protected void populateHeaders(HttpRequest request, Request.Builder builder) {
        if (request.getFirstHeaderOrNull("Accept") == null) {
            builder.addHeader("Accept", "*/*");
        }
        if (request.getFirstHeaderOrNull("User-Agent") == null) {
            builder.addHeader("User-Agent", DEFAULT_USER_AGENT);
        }
        for (Map.Entry entry : request.getHeaders().entries()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (request.getPayload() != null) {
            MutableContentMetadata md = request.getPayload().getContentMetadata();
            for (Map.Entry entry : this.contentMetadataCodec.toHeaders((ContentMetadata)md).entries()) {
                builder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected RequestBody generateRequestBody(final HttpRequest request, final Payload payload) {
        Preconditions.checkNotNull((Object)payload.getContentMetadata().getContentType(), (Object)"payload.getContentType");
        return new RequestBody(){

            public void writeTo(BufferedSink sink) throws IOException {
                Source source = Okio.source((InputStream)payload.openStream());
                try {
                    sink.writeAll(source);
                }
                catch (IOException ex) {
                    OkHttpCommandExecutorService.this.logger.error((Throwable)ex, "error writing bytes to %s", new Object[]{request.getEndpoint()});
                    throw ex;
                }
                finally {
                    source.close();
                }
            }

            public MediaType contentType() {
                return MediaType.parse((String)payload.getContentMetadata().getContentType());
            }
        };
    }

    protected HttpResponse invoke(Request nativeRequest) throws IOException, InterruptedException {
        OkHttpClient requestScopedClient = this.globalClient.clone();
        requestScopedClient.setProxy((Proxy)this.proxyForURI.apply((Object)nativeRequest.uri()));
        Response response = requestScopedClient.newCall(nativeRequest).execute();
        HttpResponse.Builder builder = HttpResponse.builder();
        builder.statusCode(response.code());
        builder.message(response.message());
        ImmutableMultimap.Builder headerBuilder = ImmutableMultimap.builder();
        Headers responseHeaders = response.headers();
        for (String header : responseHeaders.names()) {
            headerBuilder.putAll((Object)header, (Iterable)responseHeaders.values(header));
        }
        ImmutableMultimap headers = headerBuilder.build();
        if (response.code() == 204 && response.body() != null) {
            response.body().close();
        } else {
            InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)response.body().byteStream());
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), (Multimap)headers);
            builder.payload((Payload)payload);
        }
        builder.headers(HttpUtils.filterOutContentHeaders((Multimap)headers));
        return builder.build();
    }

    protected void cleanup(Request nativeResponse) {
    }
}

