/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.options;

import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class SessionCredentialsOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Long durationSeconds;
    private String tokenCode;
    private String serialNumber;

    public SessionCredentialsOptions serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public SessionCredentialsOptions durationSeconds(long durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public SessionCredentialsOptions tokenCode(String tokenCode) {
        this.tokenCode = tokenCode;
        return this;
    }

    public Multimap<String, String> buildFormParameters() {
        Multimap params = super.buildFormParameters();
        if (this.serialNumber != null) {
            params.put((Object)"SerialNumber", (Object)this.serialNumber.toString());
        }
        if (this.durationSeconds != null) {
            params.put((Object)"DurationSeconds", (Object)this.durationSeconds.toString());
        }
        if (this.tokenCode != null) {
            params.put((Object)"TokenCode", (Object)this.tokenCode);
        }
        return params;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.serialNumber, this.durationSeconds, this.tokenCode});
    }

    public SessionCredentialsOptions clone() {
        return new SessionCredentialsOptions().serialNumber(this.serialNumber).durationSeconds(this.durationSeconds).tokenCode(this.tokenCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentialsOptions other = (SessionCredentialsOptions)SessionCredentialsOptions.class.cast(obj);
        return Objects.equal((Object)this.serialNumber, (Object)other.serialNumber) && Objects.equal((Object)this.durationSeconds, (Object)other.durationSeconds) && Objects.equal((Object)this.tokenCode, (Object)other.tokenCode);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("serialNumber", (Object)this.serialNumber).add("durationSeconds", (Object)this.durationSeconds).add("tokenCode", (Object)this.tokenCode).toString();
    }

    public static class Builder {
        public static SessionCredentialsOptions serialNumber(String serialNumber) {
            return new SessionCredentialsOptions().serialNumber(serialNumber);
        }

        public static SessionCredentialsOptions durationSeconds(long durationSeconds) {
            return new SessionCredentialsOptions().durationSeconds(durationSeconds);
        }

        public static SessionCredentialsOptions tokenCode(String tokenCode) {
            return new SessionCredentialsOptions().tokenCode(tokenCode);
        }
    }
}

