/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.spi.resolve.interpret;

import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.text.StringPredicates;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.brooklyn.camp.spi.resolve.interpret.PlanInterpretationContext;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanInterpretationNode {
    private static final Logger log = LoggerFactory.getLogger(PlanInterpretationNode.class);
    protected final PlanInterpretationNode parent;
    protected final Role roleInParent;
    protected final Object originalValue;
    protected final PlanInterpretationContext context;
    protected Object newValue = null;
    protected Boolean changed = null;
    protected boolean excluded = false;
    protected boolean immutable = false;

    public PlanInterpretationNode(PlanInterpretationContext context) {
        this.parent = null;
        this.roleInParent = null;
        this.originalValue = context.getOriginalDeploymentPlan();
        this.context = context;
        this.apply();
    }

    protected PlanInterpretationNode(PlanInterpretationNode parent, Role roleInParent, Object originalItem) {
        this.parent = parent;
        this.roleInParent = roleInParent;
        this.originalValue = originalItem;
        this.context = parent.getContext();
    }

    public PlanInterpretationContext getContext() {
        return this.context;
    }

    public PlanInterpretationNode getParent() {
        return this.parent;
    }

    public Role getRoleInParent() {
        return this.roleInParent;
    }

    protected void apply() {
        if (this.changed != null) {
            throw new IllegalStateException("can only be applied once");
        }
        if (!this.excluded) {
            if (this.originalValue instanceof Map) {
                this.applyToMap();
                this.immutable();
            } else if (this.originalValue instanceof Iterable) {
                this.applyToIterable();
                this.immutable();
            } else {
                this.applyToYamlPrimitive();
            }
        }
        if (this.changed == null) {
            this.changed = false;
        }
    }

    public boolean matchesLiteral(String target) {
        if (this.isExcluded()) {
            return false;
        }
        if (this.getNewValue() instanceof CharSequence) {
            return this.getNewValue().toString().equals(target);
        }
        if (this.getNewValue() instanceof Map) {
            return ((Map)this.getOriginalValue()).containsKey(target);
        }
        if (this.getNewValue() instanceof Iterable) {
            return Iterables.contains((Iterable)((Iterable)this.getOriginalValue()), (Object)target);
        }
        return false;
    }

    public boolean matchesPrefix(String prefix) {
        if (this.isExcluded()) {
            return false;
        }
        if (this.getNewValue() instanceof CharSequence) {
            return this.getNewValue().toString().startsWith(prefix);
        }
        if (this.getNewValue() instanceof Map) {
            return Iterables.tryFind(((Map)this.getNewValue()).keySet(), (Predicate)StringPredicates.isStringStartingWith((String)prefix)).isPresent();
        }
        if (this.getNewValue() instanceof Iterable) {
            return Iterables.tryFind((Iterable)((Iterable)this.getNewValue()), (Predicate)StringPredicates.isStringStartingWith((String)prefix)).isPresent();
        }
        return false;
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public Object getNewValue() {
        if (this.changed == null || !this.isChanged()) {
            return this.originalValue;
        }
        return this.newValue;
    }

    public boolean isChanged() {
        if (this.changed == null) {
            throw new IllegalStateException("not yet applied");
        }
        return this.changed;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public PlanInterpretationNode exclude() {
        this.excluded = true;
        return this;
    }

    public PlanInterpretationNode setNewValue(Object newItem) {
        if (this.immutable) {
            throw new IllegalStateException("Node " + this + " has been set immutable");
        }
        this.newValue = newItem;
        this.changed = true;
        return this;
    }

    protected PlanInterpretationNode newPlanInterpretation(PlanInterpretationNode parent, Role roleInParent, Object item) {
        return new PlanInterpretationNode(parent, roleInParent, item);
    }

    protected void applyToMap() {
        MutableMap input = MutableMap.copyOf((Map)((Map)this.originalValue));
        MutableMap result = MutableMap.of();
        this.newValue = result;
        if (this.getContext().getAllInterpreter().applyMapBefore(this, (Map<Object, Object>)input)) {
            for (Map.Entry entry : input.entrySet()) {
                PlanInterpretationNode value = this.newPlanInterpretation(this, Role.MAP_VALUE, entry.getValue());
                value.apply();
                PlanInterpretationNode key = this.newPlanInterpretation(this, Role.MAP_KEY, entry.getKey());
                key.apply();
                if (key.isChanged() || value.isChanged()) {
                    this.changed = true;
                }
                if (this.getContext().getAllInterpreter().applyMapEntry(this, (Map<Object, Object>)input, (Map<Object, Object>)result, key, value)) {
                    result.put(key.getNewValue(), value.getNewValue());
                    continue;
                }
                this.changed = true;
            }
            this.getContext().getAllInterpreter().applyMapAfter(this, (Map<Object, Object>)input, (Map<Object, Object>)result);
        }
        if (this.changed == null) {
            this.changed = false;
        }
    }

    protected void applyToIterable() {
        MutableList input = MutableList.copyOf((Iterable)((Iterable)this.originalValue));
        MutableList result = new MutableList();
        this.newValue = result;
        if (this.getContext().getAllInterpreter().applyListBefore(this, (List<Object>)input)) {
            for (Object entry : input) {
                PlanInterpretationNode value = this.newPlanInterpretation(this, Role.LIST_ENTRY, entry);
                value.apply();
                if (value.isChanged()) {
                    this.changed = true;
                }
                if (!this.getContext().getAllInterpreter().applyListEntry(this, (List<Object>)input, (List<Object>)result, value)) continue;
                result.add(value.getNewValue());
            }
            this.getContext().getAllInterpreter().applyListAfter(this, (List<Object>)input, (List<Object>)result);
        }
        if (this.changed == null) {
            this.changed = false;
        }
    }

    protected void applyToYamlPrimitive() {
        this.getContext().getAllInterpreter().applyYamlPrimitive(this);
    }

    public void immutable() {
        if (!this.isChanged()) {
            if (!PlanInterpretationNode.testCollectionImmutable(this.getNewValue())) {
                this.changed = true;
                this.setNewValue(PlanInterpretationNode.immutable(this.getNewValue()));
            }
        } else {
            this.setNewValue(PlanInterpretationNode.immutable(this.getNewValue()));
        }
        this.checkImmutable(this.getNewValue());
        this.immutable = true;
    }

    private void checkImmutable(Object in) {
        if (!PlanInterpretationNode.testCollectionImmutable(in)) {
            log.warn("Node original value " + in + " at " + this + " should be immutable");
        }
    }

    private static boolean testCollectionImmutable(Object in) {
        if (in instanceof Map) {
            return in instanceof ImmutableMap;
        }
        if (in instanceof Iterable) {
            return in instanceof ImmutableList;
        }
        return true;
    }

    private static Object immutable(Object in) {
        if (in instanceof Map) {
            return ImmutableMap.copyOf((Map)((Map)in));
        }
        if (in instanceof Iterable) {
            return ImmutableList.copyOf((Iterable)((Iterable)in));
        }
        return in;
    }

    public static enum Role {
        MAP_KEY,
        MAP_VALUE,
        LIST_ENTRY,
        YAML_PRIMITIVE;

    }
}

