/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.spi.pdp;

import brooklyn.util.collections.MutableMap;
import brooklyn.util.yaml.Yamls;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.brooklyn.camp.spi.pdp.ServiceCharacteristic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Service {
    String name;
    String description;
    String serviceType;
    List<ServiceCharacteristic> characteristics;
    Map<String, Object> customAttributes;

    public static Service of(Map<String, Object> service) {
        MutableMap fields = MutableMap.copyOf(service);
        Service result = new Service();
        result.name = (String)fields.remove("name");
        result.description = (String)fields.remove("description");
        result.serviceType = (String)Yamls.removeMultinameAttribute((Map)fields, (String[])new String[]{"service_type", "serviceType", "type"});
        result.characteristics = new ArrayList<ServiceCharacteristic>();
        Object chars = fields.remove("characteristics");
        if (chars instanceof Iterable) {
            for (Object req : (Iterable)chars) {
                if (req instanceof Map) {
                    result.characteristics.add(ServiceCharacteristic.of((Map)req));
                    continue;
                }
                throw new IllegalArgumentException("characteristics should be a map, not " + req.getClass());
            }
        } else if (chars != null) {
            throw new IllegalArgumentException("services body should be iterable, not " + chars.getClass());
        }
        result.customAttributes = fields;
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public List<ServiceCharacteristic> getCharacteristics() {
        return ImmutableList.copyOf(this.characteristics);
    }

    public Map<String, Object> getCustomAttributes() {
        return ImmutableMap.copyOf(this.customAttributes);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

