/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.spi.collection;

import brooklyn.util.collections.MutableMap;
import io.brooklyn.camp.spi.AbstractResource;
import io.brooklyn.camp.spi.collection.AbstractResourceLookup;
import io.brooklyn.camp.spi.collection.ResolvableLink;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BasicResourceLookup<T extends AbstractResource>
extends AbstractResourceLookup<T> {
    Map<String, T> items = new MutableMap();
    Map<String, ResolvableLink<T>> links = new MutableMap();

    @Override
    public T get(String id) {
        return (T)((AbstractResource)this.items.get(id));
    }

    @Override
    public synchronized List<ResolvableLink<T>> links() {
        return new ArrayList<ResolvableLink<T>>(this.links.values());
    }

    public synchronized void add(T item) {
        AbstractResource old = (AbstractResource)this.items.put(((AbstractResource)item).getId(), item);
        if (old != null) {
            this.items.put(old.getId(), old);
            throw new IllegalStateException("Already contains item for " + ((AbstractResource)item).getId() + ": " + old + " (adding " + item + ")");
        }
        this.links.put(((AbstractResource)item).getId(), this.newLink(((AbstractResource)item).getId(), ((AbstractResource)item).getName()));
    }

    public synchronized void addAll(T ... items) {
        for (T item : items) {
            this.add(item);
        }
    }

    public synchronized T update(T item) {
        AbstractResource old = (AbstractResource)this.items.put(((AbstractResource)item).getId(), item);
        this.links.put(((AbstractResource)item).getId(), this.newLink(((AbstractResource)item).getId(), ((AbstractResource)item).getName()));
        return (T)old;
    }

    public synchronized boolean remove(String id) {
        this.items.remove(id);
        return this.links.remove(id) != null;
    }

    public static <T extends AbstractResource> BasicResourceLookup<T> of(T ... items) {
        BasicResourceLookup<T> result = new BasicResourceLookup<T>();
        for (T item : items) {
            result.add(item);
        }
        return result;
    }
}

