/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp;

import com.google.common.base.Preconditions;
import io.brooklyn.camp.spi.ApplicationComponent;
import io.brooklyn.camp.spi.ApplicationComponentTemplate;
import io.brooklyn.camp.spi.Assembly;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.PlatformComponent;
import io.brooklyn.camp.spi.PlatformComponentTemplate;
import io.brooklyn.camp.spi.PlatformRootSummary;
import io.brooklyn.camp.spi.PlatformTransaction;
import io.brooklyn.camp.spi.collection.ResourceLookup;
import io.brooklyn.camp.spi.resolve.PdpProcessor;

public abstract class CampPlatform {
    private final PlatformRootSummary root;
    private final PdpProcessor pdp;

    public CampPlatform(PlatformRootSummary root) {
        this.root = (PlatformRootSummary)Preconditions.checkNotNull((Object)root, (Object)"root");
        this.pdp = this.createPdpProcessor();
    }

    public PlatformRootSummary root() {
        return this.root;
    }

    public PdpProcessor pdp() {
        return this.pdp;
    }

    public abstract ResourceLookup<PlatformComponentTemplate> platformComponentTemplates();

    public abstract ResourceLookup<ApplicationComponentTemplate> applicationComponentTemplates();

    public abstract ResourceLookup<AssemblyTemplate> assemblyTemplates();

    public abstract ResourceLookup<PlatformComponent> platformComponents();

    public abstract ResourceLookup<ApplicationComponent> applicationComponents();

    public abstract ResourceLookup<Assembly> assemblies();

    public abstract PlatformTransaction transaction();

    protected PdpProcessor createPdpProcessor() {
        return new PdpProcessor(this);
    }
}

