/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.rest.domain.HasId;
import brooklyn.rest.domain.LinkWithMetadata;
import brooklyn.util.collections.Jsonya;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class TaskSummary
implements HasId,
Serializable {
    private static final long serialVersionUID = 4637850742127078158L;
    private final String id;
    private final String displayName;
    private final String entityId;
    private final String entityDisplayName;
    private final String description;
    private final Collection<Object> tags;
    private final Long submitTimeUtc;
    private final Long startTimeUtc;
    private final Long endTimeUtc;
    private final String currentStatus;
    private final Object result;
    private final boolean isError;
    private final boolean isCancelled;
    private final List<LinkWithMetadata> children;
    private final LinkWithMetadata submittedByTask;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final LinkWithMetadata blockingTask;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String blockingDetails;
    private final String detailedStatus;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, LinkWithMetadata> streams;
    private final Map<String, URI> links;

    public TaskSummary(@JsonProperty(value="id") String id, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="description") String description, @JsonProperty(value="entityId") String entityId, @JsonProperty(value="entityDisplayName") String entityDisplayName, @JsonProperty(value="tags") Set<Object> tags, @JsonProperty(value="submitTimeUtc") Long submitTimeUtc, @JsonProperty(value="startTimeUtc") Long startTimeUtc, @JsonProperty(value="endTimeUtc") Long endTimeUtc, @JsonProperty(value="currentStatus") String currentStatus, @JsonProperty(value="result") Object result, @JsonProperty(value="isError") boolean isError, @JsonProperty(value="isCancelled") boolean isCancelled, @JsonProperty(value="children") List<LinkWithMetadata> children, @JsonProperty(value="submittedByTask") LinkWithMetadata submittedByTask, @JsonProperty(value="blockingTask") LinkWithMetadata blockingTask, @JsonProperty(value="blockingDetails") String blockingDetails, @JsonProperty(value="detailedStatus") String detailedStatus, @JsonProperty(value="streams") Map<String, LinkWithMetadata> streams, @JsonProperty(value="links") Map<String, URI> links) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.entityId = entityId;
        this.entityDisplayName = entityDisplayName;
        this.tags = tags == null ? ImmutableList.of() : ImmutableList.copyOf(tags);
        this.submitTimeUtc = submitTimeUtc;
        this.startTimeUtc = startTimeUtc;
        this.endTimeUtc = endTimeUtc;
        this.currentStatus = currentStatus;
        this.result = result;
        this.isError = isError;
        this.isCancelled = isCancelled;
        this.children = children;
        this.blockingDetails = blockingDetails;
        this.blockingTask = blockingTask;
        this.submittedByTask = submittedByTask;
        this.detailedStatus = detailedStatus;
        this.streams = streams;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityDisplayName() {
        return this.entityDisplayName;
    }

    public Collection<Object> getTags() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object t : this.tags) {
            result.add(Jsonya.convertToJsonPrimitive((Object)t));
        }
        return result;
    }

    @JsonIgnore
    public Collection<Object> getRawTags() {
        return this.tags;
    }

    public Long getSubmitTimeUtc() {
        return this.submitTimeUtc;
    }

    public Long getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public Long getEndTimeUtc() {
        return this.endTimeUtc;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public Object getResult() {
        return this.result;
    }

    @Deprecated
    @JsonIgnore
    public boolean getIsError() {
        return this.isError;
    }

    @Deprecated
    @JsonIgnore
    public boolean getIsCancelled() {
        return this.isCancelled;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public List<LinkWithMetadata> getChildren() {
        return this.children;
    }

    public LinkWithMetadata getSubmittedByTask() {
        return this.submittedByTask;
    }

    public LinkWithMetadata getBlockingTask() {
        return this.blockingTask;
    }

    public String getBlockingDetails() {
        return this.blockingDetails;
    }

    public String getDetailedStatus() {
        return this.detailedStatus;
    }

    public Map<String, LinkWithMetadata> getStreams() {
        return this.streams;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public String toString() {
        return "TaskSummary{id='" + this.id + '\'' + ", displayName='" + this.displayName + '\'' + ", currentStatus='" + this.currentStatus + '\'' + ", startTimeUtc='" + this.startTimeUtc + '\'' + ", endTimeUtc='" + this.endTimeUtc + '\'' + '}';
    }
}

