/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.basic.BrooklynObject;
import brooklyn.rest.domain.HasConfig;
import brooklyn.rest.domain.HasId;
import brooklyn.rest.domain.HasName;
import brooklyn.util.text.NaturalOrderComparator;
import brooklyn.util.text.Strings;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class SummaryComparators {
    private static NaturalOrderComparator COMPARATOR = new NaturalOrderComparator();

    private SummaryComparators() {
    }

    @Nonnull
    static String getDisplayNameOrName(HasName o1) {
        String n1 = null;
        if (o1 instanceof BrooklynObject) {
            n1 = ((BrooklynObject)o1).getDisplayName();
        }
        if (Strings.isEmpty(n1) && o1 instanceof HasConfig && ((HasConfig)((Object)o1)).getConfig() != null) {
            n1 = Strings.toString(((HasConfig)((Object)o1)).getConfig().get("displayName"));
        }
        if (Strings.isEmpty((CharSequence)n1)) {
            n1 = o1.getName();
        }
        if (n1 == null) {
            return "~~~";
        }
        return n1;
    }

    public static Comparator<HasName> displayNameComparator() {
        return new Comparator<HasName>(){

            @Override
            public int compare(HasName o1, HasName o2) {
                return COMPARATOR.compare(SummaryComparators.getDisplayNameOrName(o1).toLowerCase(), SummaryComparators.getDisplayNameOrName(o2).toLowerCase());
            }
        };
    }

    public static Comparator<HasName> nameComparator() {
        return new Comparator<HasName>(){

            @Override
            public int compare(HasName o1, HasName o2) {
                return COMPARATOR.compare(o1.getName(), o2.getName());
            }
        };
    }

    public static Comparator<HasId> idComparator() {
        return new Comparator<HasId>(){

            @Override
            public int compare(HasId o1, HasId o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };
    }
}

