/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.rest.domain.HasId;
import brooklyn.rest.domain.HasName;
import brooklyn.rest.domain.LocationSpec;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class LocationSummary
extends LocationSpec
implements HasName,
HasId {
    private static final long serialVersionUID = -4559153719273573670L;
    private final String id;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String type;
    private final Map<String, URI> links;

    public LocationSummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="spec") String spec, @JsonProperty(value="type") String type, @JsonProperty(value="config") @Nullable Map<String, ?> config, @JsonProperty(value="links") Map<String, URI> links) {
        super(name, spec, config);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.type = type;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LocationSummary that = (LocationSummary)o;
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.links});
    }

    @Override
    public String toString() {
        return "LocationSummary{id='" + this.getId() + '\'' + "name='" + this.getName() + '\'' + "spec='" + this.getSpec() + '\'' + "type='" + this.getType() + '\'' + ", config=" + this.getConfig() + ", links=" + this.links + '}';
    }
}

