/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.rest.domain.HasConfig;
import brooklyn.rest.domain.HasName;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class LocationSpec
implements HasName,
HasConfig,
Serializable {
    private static final long serialVersionUID = -1562824224808185255L;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String name;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String spec;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final Map<String, ?> config;

    public static LocationSpec localhost() {
        return new LocationSpec("localhost", "localhost", null);
    }

    public LocationSpec(@JsonProperty(value="name") String name, @JsonProperty(value="spec") String spec, @JsonProperty(value="config") @Nullable Map<String, ?> config) {
        this.name = name;
        this.spec = spec;
        this.config = config == null ? Collections.emptyMap() : ImmutableMap.copyOf(config);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSpec() {
        return this.spec;
    }

    @Override
    public Map<String, ?> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationSpec that = (LocationSpec)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.spec, (Object)that.spec) && Objects.equal(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.spec, this.name, this.config});
    }

    public String toString() {
        return "LocationSpec{name='" + this.name + '\'' + "spec='" + this.spec + '\'' + ", config=" + this.config + '}';
    }
}

