/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class HighAvailabilitySummary
implements Serializable {
    private static final long serialVersionUID = -317333127094471223L;
    private final String ownId;
    private final String masterId;
    private final Map<String, HaNodeSummary> nodes;
    private final Map<String, URI> links;

    public HighAvailabilitySummary(@JsonProperty(value="ownId") String ownId, @JsonProperty(value="masterId") String masterId, @JsonProperty(value="nodes") Map<String, HaNodeSummary> nodes, @JsonProperty(value="links") Map<String, URI> links) {
        this.ownId = ownId;
        this.masterId = masterId;
        this.nodes = nodes == null ? ImmutableMap.of() : nodes;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    public String getOwnId() {
        return this.ownId;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public Map<String, HaNodeSummary> getNodes() {
        return this.nodes;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        return o instanceof HighAvailabilitySummary && this.ownId.equals(((HighAvailabilitySummary)o).getOwnId());
    }

    public int hashCode() {
        return this.ownId != null ? this.ownId.hashCode() : 0;
    }

    public String toString() {
        return "HighAvailabilitySummary{ownId='" + this.ownId + '\'' + ", links=" + this.links + '}';
    }

    public static class HaNodeSummary
    implements Serializable {
        private static final long serialVersionUID = 9205960988226816539L;
        private final String nodeId;
        private final URI nodeUri;
        private final String status;
        private final Long localTimestamp;
        private final Long remoteTimestamp;

        public HaNodeSummary(@JsonProperty(value="nodeId") String nodeId, @JsonProperty(value="nodeUri") URI nodeUri, @JsonProperty(value="status") String status, @JsonProperty(value="localTimestamp") Long localTimestamp, @JsonProperty(value="remoteTimestamp") Long remoteTimestamp) {
            this.nodeId = nodeId;
            this.nodeUri = nodeUri;
            this.status = status;
            this.localTimestamp = localTimestamp;
            this.remoteTimestamp = remoteTimestamp;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public URI getNodeUri() {
            return this.nodeUri;
        }

        public String getStatus() {
            return this.status;
        }

        public Long getLocalTimestamp() {
            return this.localTimestamp;
        }

        public Long getRemoteTimestamp() {
            return this.remoteTimestamp;
        }

        public boolean equals(Object o) {
            return o instanceof HaNodeSummary && Objects.equal((Object)this.nodeId, (Object)((HaNodeSummary)o).getNodeId());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.nodeId});
        }

        public String toString() {
            return "HighAvailabilitySummary{nodeId='" + this.nodeId + '\'' + ", status='" + this.status + '\'' + '}';
        }
    }
}

