/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.rest.domain.HasName;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class EffectorSummary
implements HasName,
Serializable {
    private static final long serialVersionUID = 8103535211378449509L;
    private final String name;
    private final String returnType;
    private final Set<ParameterSummary<?>> parameters;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String description;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, URI> links;

    public EffectorSummary(@JsonProperty(value="name") String name, @JsonProperty(value="returnType") String returnType, @JsonProperty(value="parameters") Set<ParameterSummary<?>> parameters, @JsonProperty(value="description") String description, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = name;
        this.description = description;
        this.returnType = returnType;
        this.parameters = parameters;
        this.links = links != null ? ImmutableMap.copyOf(links) : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Set<ParameterSummary<?>> getParameters() {
        return this.parameters;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectorSummary that = (EffectorSummary)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EffectorSummary{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", returnType='" + this.returnType + '\'' + ", parameters=" + this.parameters + ", links=" + this.links + '}';
    }

    public static class ParameterSummary<T>
    implements HasName,
    Serializable {
        private static final long serialVersionUID = -6393686096290306153L;
        private final String name;
        private final String type;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        private final String description;
        private final T defaultValue;

        public ParameterSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") T defaultValue) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterSummary that = (ParameterSummary)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.defaultValue, that.defaultValue);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.description, this.defaultValue});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("description", (Object)this.description).add("defaultValue", this.defaultValue).toString();
        }
    }
}

