/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.config.ConfigKey;
import brooklyn.rest.domain.HasName;
import brooklyn.util.collections.Jsonya;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public abstract class ConfigSummary
implements HasName,
Serializable {
    private static final long serialVersionUID = -2831796487073496730L;
    private final String name;
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Object defaultValue;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String description;
    @JsonSerialize
    private final boolean reconfigurable;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String label;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Double priority;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final List<Map<String, String>> possibleValues;

    protected ConfigSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") Object defaultValue, @JsonProperty(value="reconfigurable") boolean reconfigurable, @JsonProperty(value="label") String label, @JsonProperty(value="priority") Double priority, @JsonProperty(value="possibleValues") List<Map<String, String>> possibleValues) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
        this.reconfigurable = reconfigurable;
        this.label = label;
        this.priority = priority;
        this.possibleValues = possibleValues;
    }

    protected ConfigSummary(ConfigKey<?> config) {
        this(config, null, null);
    }

    protected ConfigSummary(ConfigKey<?> config, String label, Double priority) {
        this.name = config.getName();
        this.description = config.getDescription();
        this.reconfigurable = config.isReconfigurable();
        this.label = label;
        this.priority = priority;
        if (config.getType().isEnum()) {
            this.type = Enum.class.getName();
            this.defaultValue = config.getDefaultValue() == null ? null : ((Enum)config.getDefaultValue()).name();
            this.possibleValues = FluentIterable.from(Arrays.asList((Enum[])config.getType().getEnumConstants())).transform((Function)new Function<Enum, Map<String, String>>(){

                @Nullable
                public Map<String, String> apply(@Nullable Enum input) {
                    return ImmutableMap.of((Object)"value", (Object)(input != null ? input.name() : null), (Object)"description", (Object)(input != null ? input.toString() : null));
                }
            }).toList();
        } else {
            this.type = config.getTypeName();
            this.defaultValue = Jsonya.convertToJsonPrimitive((Object)config.getDefaultValue());
            this.possibleValues = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReconfigurable() {
        return this.reconfigurable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public Double getPriority() {
        return this.priority;
    }

    public List<Map<String, String>> getPossibleValues() {
        return this.possibleValues;
    }

    public abstract Map<String, URI> getLinks();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSummary that = (ConfigSummary)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        return result;
    }

    public abstract String toString();
}

