/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.rest.domain.HasId;
import brooklyn.rest.domain.HasName;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CatalogItemSummary
implements HasId,
HasName,
Serializable {
    private static final long serialVersionUID = -823483595879417681L;
    private final String id;
    private final String symbolicName;
    private final String version;
    @Deprecated
    private final String type;
    private final String javaType;
    private final String name;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final String description;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final String iconUrl;
    private final String planYaml;
    private final boolean deprecated;
    private final Map<String, URI> links;

    public CatalogItemSummary(@JsonProperty(value="symbolicName") String symbolicName, @JsonProperty(value="version") String version, @JsonProperty(value="name") String displayName, @JsonProperty(value="javaType") String javaType, @JsonProperty(value="planYaml") String planYaml, @JsonProperty(value="description") String description, @JsonProperty(value="iconUrl") String iconUrl, @JsonProperty(value="deprecated") boolean deprecated, @JsonProperty(value="links") Map<String, URI> links) {
        this.id = symbolicName + ":" + version;
        this.symbolicName = symbolicName;
        this.type = symbolicName;
        this.version = version;
        this.name = displayName;
        this.javaType = javaType;
        this.planYaml = planYaml;
        this.description = description;
        this.iconUrl = iconUrl;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
        this.deprecated = deprecated;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getType() {
        return this.type;
    }

    public String getPlanYaml() {
        return this.planYaml;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.symbolicName).add("version", (Object)this.version).add("deprecated", this.deprecated).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.version, this.name, this.javaType, this.deprecated});
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }
}

