/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.util.text.Strings;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.Serializable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ApiError
implements Serializable {
    private static final long serialVersionUID = -8244515572813244686L;
    private final String message;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final String details;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Integer error;

    public static Builder builder() {
        return new Builder();
    }

    public static ApiError of(Throwable t) {
        return ApiError.builderFromThrowable(t).build();
    }

    public static ApiError of(String message) {
        return ApiError.builder().message(message).build();
    }

    @Deprecated
    public static Builder fromThrowable(Throwable t) {
        return ApiError.builderFromThrowable(t);
    }

    public static Builder builderFromThrowable(Throwable t) {
        Preconditions.checkNotNull((Object)t, (Object)"throwable");
        String message = (String)Optional.fromNullable((Object)t.getMessage()).or((Object)t.getClass().getName());
        return ApiError.builder().message(message).details(Throwables.getStackTraceAsString((Throwable)t));
    }

    public ApiError(String message) {
        this(message, null);
    }

    public ApiError(String message, String details) {
        this(message, details, null);
    }

    public ApiError(@JsonProperty(value="message") String message, @JsonProperty(value="details") String details, @JsonProperty(value="error") Integer error) {
        this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        this.details = details != null ? details : "";
        this.error = error;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    public Integer getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ApiError that = (ApiError)ApiError.class.cast(other);
        return Objects.equal((Object)this.message, (Object)that.message) && Objects.equal((Object)this.details, (Object)that.details) && Objects.equal((Object)this.error, (Object)that.error);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.message, this.details, this.error});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("message", (Object)this.message).add("details", (Object)this.details).add("error", (Object)this.error).toString();
    }

    public Response asBadRequestResponseJson() {
        return this.asResponse(Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
    }

    public Response asResponse(Response.Status defaultStatus, MediaType type) {
        return Response.status((int)(this.error != null ? this.error : (defaultStatus != null ? defaultStatus.getStatusCode() : Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()))).type(type).entity((Object)this).build();
    }

    public Response asResponse(MediaType type) {
        return this.asResponse(null, type);
    }

    public Response asJsonResponse() {
        return this.asResponse(MediaType.APPLICATION_JSON_TYPE);
    }

    public static class Builder {
        private String message;
        private String details;
        private Integer errorCode;

        public Builder message(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
            return this;
        }

        public Builder details(String details) {
            this.details = (String)Preconditions.checkNotNull((Object)details, (Object)"details");
            return this;
        }

        public Builder errorCode(Response.Status errorCode) {
            return this.errorCode(errorCode.getStatusCode());
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder prefixMessage(String prefix) {
            return this.prefixMessage(prefix, ": ");
        }

        public Builder prefixMessage(String prefix, String separatorIfMessageNotBlank) {
            if (Strings.isBlank((CharSequence)this.message)) {
                this.message(prefix);
            } else {
                this.message(prefix + separatorIfMessageNotBlank + this.message);
            }
            return this;
        }

        public ApiError build() {
            return new ApiError(this.message, this.details, this.errorCode);
        }

        @Deprecated
        public Builder fromApiError(ApiError error) {
            return this.copy(error);
        }

        public Builder copy(ApiError error) {
            return this.message(error.message).details(error.details).errorCode(error.error);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

