/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.UsageStatistics;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/v1/usage")
@Apidoc(value="Usage")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface UsageApi {
    @GET
    @Path(value="/applications")
    @ApiOperation(value="Retrieve usage information about all applications", responseClass="brooklyn.rest.domain.UsageStatistics")
    @ApiErrors(value={})
    public List<UsageStatistics> listApplicationsUsage(@ApiParam(name="start", value="timestamp of start marker for usage reporting, in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var1, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var2);

    @GET
    @Path(value="/applications/{application}")
    @ApiOperation(value="Retrieve usage information about a specified application", responseClass="brooklyn.rest.domain.UsageStatistics")
    @ApiErrors(value={@ApiError(code=404, reason="Application not found")})
    public UsageStatistics getApplicationUsage(@ApiParam(name="application", value="Application id", required=true) @PathParam(value="application") String var1, @ApiParam(name="start", value="timestamp of start marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var2, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var3);

    @GET
    @Path(value="/machines")
    @ApiOperation(value="Retrieve usage information about all machine locations, optionally filtering for a specific application and/or time range", responseClass="brooklyn.rest.domain.UsageStatistics")
    @ApiErrors(value={@ApiError(code=404, reason="Application not found")})
    public List<UsageStatistics> listMachinesUsage(@ApiParam(name="application", value="Application id", required=false) @QueryParam(value="application") String var1, @ApiParam(name="start", value="timestamp of start marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var2, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var3);

    @GET
    @Path(value="/machines/{machine}")
    @ApiOperation(value="Retrieve usage information about a specific machine location", responseClass="brooklyn.rest.domain.UsageStatistics")
    @ApiErrors(value={@ApiError(code=404, reason="Machine not found")})
    public UsageStatistics getMachineUsage(@ApiParam(name="machine", value="Machine id", required=true) @PathParam(value="machine") String var1, @ApiParam(name="start", value="timestamp of start marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var2, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var3);
}

