/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.SensorSummary;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/v1/applications/{application}/entities/{entity}/sensors")
@Apidoc(value="Entity Sensors")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface SensorApi {
    @GET
    @ApiOperation(value="Fetch the sensor list for a specific application entity", responseClass="brooklyn.rest.domain.SensorSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public List<SensorSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch sensor values in batch", notes="Returns a map of sensor name to value")
    public Map<String, Object> batchSensorRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Return raw sensor data instead of display values", required=false) @QueryParam(value="raw") @DefaultValue(value="false") Boolean var3);

    @GET
    @Path(value="/{sensor}")
    @ApiOperation(value="Fetch sensor value (json)", responseClass="Object")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or sensor")})
    public Object get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Return raw sensor data instead of display values", required=false) @QueryParam(value="raw") @DefaultValue(value="false") Boolean var4);

    @GET
    @Path(value="/{sensor}")
    @ApiOperation(value="Fetch sensor value (text/plain)", responseClass="String")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or sensor")})
    @Produces(value={"text/plain"})
    public String getPlain(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Return raw sensor data instead of display values", required=false) @QueryParam(value="raw") @DefaultValue(value="false") Boolean var4);

    @POST
    @ApiOperation(value="Manually set multiple sensor values")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public void setFromMap(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Map of sensor names to values", required=true) Map var3);

    @POST
    @Path(value="/{sensor}")
    @ApiOperation(value="Manually set a sensor value")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or sensor")})
    public void set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Value to set") Object var4);

    @DELETE
    @Path(value="/{sensor}")
    @ApiOperation(value="Manually clear a sensor value")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or sensor")})
    public void delete(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3);
}

