/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.PolicyConfigSummary;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/applications/{application}/entities/{entity}/policies/{policy}/config")
@Apidoc(value="Entity Policy Config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface PolicyConfigApi {
    @GET
    @ApiOperation(value="Fetch the config keys for a specific policy", responseClass="brooklyn.rest.domain.ConfigSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity or policy")})
    public List<PolicyConfigSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3);

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch config key values in batch", notes="Returns a map of config name to value")
    public Map<String, Object> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3);

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value", responseClass="Object")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity, policy or config key")})
    public String get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var4);

    @Deprecated
    @POST
    @Path(value="/{config}/set")
    @ApiOperation(value="Sets the given config on this policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity, policy or config key")})
    public Response set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var4, @ApiParam(name="value", value="New value for the configuration", required=true) @QueryParam(value="value") String var5);

    @POST
    @Path(value="/{config}")
    @ApiOperation(value="Sets the given config on this policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity, policy or config key")})
    public Response set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String var3, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var4, @ApiParam(name="value", value="New value for the configuration", required=true) Object var5);
}

