/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.PolicySummary;
import brooklyn.rest.domain.Status;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/applications/{application}/entities/{entity}/policies")
@Apidoc(value="Entity Policies")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface PolicyApi {
    @GET
    @ApiOperation(value="Fetch the policies attached to a specific application entity", responseClass="brooklyn.rest.domain.PolicySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public List<PolicySummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch policy states in batch", notes="Returns a map of policy ID to whether it is active")
    public Map<String, Boolean> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @POST
    @ApiOperation(value="Add a policy", notes="Returns a summary of the new policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity"), @ApiError(code=400, reason="Type is not a class implementing Policy")})
    public PolicySummary addPolicy(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(name="policyType", value="Class of policy to add", required=true) @QueryParam(value="type") String var3, @ApiParam(name="config", value="Configuration for the policy (as key value pairs)", required=true) Map<String, String> var4);

    @GET
    @Path(value="/{policy}")
    @ApiOperation(value="Gets status of a policy (RUNNING / SUSPENDED)")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Status getStatus(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String var3);

    @POST
    @Path(value="/{policy}/start")
    @ApiOperation(value="Start or resume a policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Response start(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String var3);

    @POST
    @Path(value="/{policy}/stop")
    @ApiOperation(value="Suspends a policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Response stop(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String var3);

    @POST
    @Path(value="/{policy}/destroy")
    @ApiOperation(value="Destroy a policy", notes="Removes a policy from being associated with the entity and destroys it (stopping first if running)")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Response destroy(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String var3);
}

