/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.EntityConfigSummary;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/v1/applications/{application}/entities/{entity}/config")
@Apidoc(value="Entity Config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EntityConfigApi {
    @GET
    @ApiOperation(value="Fetch the config keys for a specific application entity", responseClass="brooklyn.rest.domain.ConfigSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public List<EntityConfigSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch config key values in batch", notes="Returns a map of config name to value")
    public Map<String, Object> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Return raw config data instead of display values", required=false) @QueryParam(value="raw") @DefaultValue(value="false") Boolean var3);

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value (json)", responseClass="Object")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or config key")})
    @Produces(value={"application/json"})
    public Object get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var3, @ApiParam(value="Return raw config data instead of display values", required=false) @QueryParam(value="raw") @DefaultValue(value="false") Boolean var4);

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value (text/plain)", responseClass="Object")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or config key")})
    @Produces(value={"text/plain"})
    public String getPlain(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var3, @ApiParam(value="Return raw config data instead of display values", required=false) @QueryParam(value="raw") @DefaultValue(value="false") Boolean var4);

    @POST
    @ApiOperation(value="Manually set multiple config values")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public void setFromMap(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Apply the config to all pre-existing descendants", required=false) @QueryParam(value="recurse") @DefaultValue(value="false") Boolean var3, @ApiParam(value="Map of config key names to values", required=true) Map var4);

    @POST
    @Path(value="/{config}")
    @ApiOperation(value="Manually set a config value")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or config key")})
    public void set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Config key name", required=true) @PathParam(value="config") String var3, @ApiParam(value="Apply the config to all pre-existing descendants", required=false) @QueryParam(value="recurse") @DefaultValue(value="false") Boolean var4, @ApiParam(value="Value to set") Object var5);
}

