/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.EffectorSummary;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/applications/{application}/entities/{entity}/effectors")
@Apidoc(value="Entity Effectors")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EffectorApi {
    @GET
    @ApiOperation(value="Fetch the list of effectors", responseClass="brooklyn.rest.domain.EffectorSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public List<EffectorSummary> list(@ApiParam(name="application", value="Application name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity name", required=true) @PathParam(value="entity") String var2);

    @POST
    @Path(value="/{effector}")
    @ApiOperation(value="Trigger an effector", notes="Returns the return value (status 200) if it completes, or an activity task ID (status 202) if it times out")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or effector")})
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response invoke(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(name="effector", value="Name of the effector to trigger", required=true) @PathParam(value="effector") String var3, @ApiParam(name="timeout", value="Delay before server should respond with activity task ID rather than result (in millis if no unit specified): 'never' (blocking) is default; '0' means 'always' return task activity ID; and e.g. '1000' or '1s' will return a result if available within one second otherwise status 202 and the activity task ID", required=false, defaultValue="never") @QueryParam(value="timeout") String var4, @ApiParam(name="parameters", value="Effector parameters (as key value pairs)", required=false) @Valid Map<String, Object> var5);
}

