/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.CatalogEntitySummary;
import brooklyn.rest.domain.CatalogItemSummary;
import brooklyn.rest.domain.CatalogLocationSummary;
import brooklyn.rest.domain.CatalogPolicySummary;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.io.InputStream;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/catalog")
@Apidoc(value="Catalog")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface CatalogApi {
    @POST
    @ApiOperation(value="Add a catalog item (e.g. new type of entity, policy or location) by uploading YAML descriptor from browser using multipart/form-data", responseClass="String")
    @Consumes(value={"multipart/form-data"})
    public Response createFromMultipart(@ApiParam(name="yaml", value="multipart/form-data file input field") @FormDataParam(value="yaml") InputStream var1, @FormDataParam(value="yaml") FormDataContentDisposition var2);

    @Consumes
    @POST
    @ApiOperation(value="Add a catalog item (e.g. new type of entity, policy or location) by uploading YAML descriptor Return value is map of ID to CatalogItemSummary, with code 201 CREATED.", responseClass="Response")
    public Response create(@ApiParam(name="yaml", value="YAML descriptor of catalog item", required=true) @Valid String var1);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/reset")
    @ApiOperation(value="Resets the catalog to the given (XML) format")
    public Response resetXml(@ApiParam(name="xml", value="XML descriptor of the entire catalog to install", required=true) @Valid String var1, @ApiParam(name="ignoreErrors", value="Don't fail on invalid bundles, log the errors only") @QueryParam(value="ignoreErrors") @DefaultValue(value="false") boolean var2);

    @Deprecated
    @DELETE
    @Path(value="/entities/{entityId}")
    @ApiOperation(value="Deletes a specific version of an entity's definition from the catalog")
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public void deleteEntity(@ApiParam(name="entityId", value="The ID of the entity or template to delete", required=true) @PathParam(value="entityId") String var1) throws Exception;

    @DELETE
    @Path(value="/entities/{entityId}/{version}")
    @ApiOperation(value="Deletes a specific version of an entity's definition from the catalog")
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public void deleteEntity(@ApiParam(name="entityId", value="The ID of the entity or template to delete", required=true) @PathParam(value="entityId") String var1, @ApiParam(name="version", value="The version identifier of the entity or template to delete", required=true) @PathParam(value="version") String var2) throws Exception;

    @DELETE
    @Path(value="/policies/{policyId}/{version}")
    @ApiOperation(value="Deletes a specific version of an policy's definition from the catalog")
    @ApiErrors(value={@ApiError(code=404, reason="Policy not found")})
    public void deletePolicy(@ApiParam(name="policyId", value="The ID of the policy to delete", required=true) @PathParam(value="policyId") String var1, @ApiParam(name="version", value="The version identifier of the policy to delete", required=true) @PathParam(value="version") String var2) throws Exception;

    @DELETE
    @Path(value="/locations/{locationId}/{version}")
    @ApiOperation(value="Deletes a specific version of an location's definition from the catalog")
    @ApiErrors(value={@ApiError(code=404, reason="Location not found")})
    public void deleteLocation(@ApiParam(name="locationId", value="The ID of the location to delete", required=true) @PathParam(value="locationId") String var1, @ApiParam(name="version", value="The version identifier of the location to delete", required=true) @PathParam(value="version") String var2) throws Exception;

    @GET
    @Path(value="/entities")
    @ApiOperation(value="List available entity types optionally matching a query", responseClass="CatalogItemSummary", multiValueResponse=true)
    public List<CatalogEntitySummary> listEntities(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @GET
    @Path(value="/applications")
    @ApiOperation(value="Fetch a list of application templates optionally matching a query", responseClass="CatalogItemSummary", multiValueResponse=true)
    public List<CatalogItemSummary> listApplications(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/entities/{entityId}")
    @ApiOperation(value="Fetch an entity's definition from the catalog", responseClass="CatalogEntitySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogEntitySummary getEntity(@ApiParam(name="entityId", value="The ID of the entity or template to retrieve", required=true) @PathParam(value="entityId") String var1) throws Exception;

    @GET
    @Path(value="/entities/{entityId}/{version}")
    @ApiOperation(value="Fetch a specific version of an entity's definition from the catalog", responseClass="CatalogEntitySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogEntitySummary getEntity(@ApiParam(name="entityId", value="The ID of the entity or template to retrieve", required=true) @PathParam(value="entityId") String var1, @ApiParam(name="version", value="The version identifier of the entity or template to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @GET
    @Path(value="/applications/{applicationId}")
    @ApiOperation(value="Fetch a specific version of an application's definition from the catalog", responseClass="CatalogEntitySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogEntitySummary getApplication(@ApiParam(name="applicationId", value="The ID of the application to retrieve", required=true) @PathParam(value="applicationId") String var1) throws Exception;

    @GET
    @Path(value="/applications/{applicationId}/{version}")
    @ApiOperation(value="Fetch a specific version of an application's definition from the catalog", responseClass="CatalogEntitySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogEntitySummary getApplication(@ApiParam(name="applicationId", value="The ID of the application to retrieve", required=true) @PathParam(value="applicationId") String var1, @ApiParam(name="version", value="The version identifier of the application to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @GET
    @Path(value="/policies")
    @ApiOperation(value="List available policies optionally matching a query", responseClass="CatalogPolicySummary", multiValueResponse=true)
    public List<CatalogPolicySummary> listPolicies(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/policies/{policyId}")
    @ApiOperation(value="Fetch a policy's definition from the catalog", responseClass="CatalogItemSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogItemSummary getPolicy(@ApiParam(name="policyId", value="The ID of the policy to retrieve", required=true) @PathParam(value="policyId") String var1) throws Exception;

    @GET
    @Path(value="/policies/{policyId}/{version}")
    @ApiOperation(value="Fetch a policy's definition from the catalog", responseClass="CatalogItemSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogItemSummary getPolicy(@ApiParam(name="policyId", value="The ID of the policy to retrieve", required=true) @PathParam(value="policyId") String var1, @ApiParam(name="version", value="The version identifier of the application to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @GET
    @Path(value="/locations")
    @ApiOperation(value="List available locations optionally matching a query", responseClass="CatalogLocationSummary", multiValueResponse=true)
    public List<CatalogLocationSummary> listLocations(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/locations/{locationId}")
    @ApiOperation(value="Fetch a location's definition from the catalog", responseClass="CatalogItemSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogItemSummary getLocation(@ApiParam(name="locationId", value="The ID of the location to retrieve", required=true) @PathParam(value="locationId") String var1) throws Exception;

    @GET
    @Path(value="/locations/{locationId}/{version}")
    @ApiOperation(value="Fetch a location's definition from the catalog", responseClass="CatalogItemSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogItemSummary getLocation(@ApiParam(name="locationId", value="The ID of the location to retrieve", required=true) @PathParam(value="locationId") String var1, @ApiParam(name="version", value="The version identifier of the application to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @GET
    @Path(value="/icon/{itemId}")
    @ApiOperation(value="Return the icon for a given catalog entry (application/image or HTTP redirect)")
    @ApiErrors(value={@ApiError(code=404, reason="Item not found")})
    @Produces(value={"application/image"})
    public Response getIcon(@ApiParam(name="itemId", value="ID of catalog item (application, entity, policy, location)") @PathParam(value="itemId") @DefaultValue(value="") String var1);

    @GET
    @Path(value="/icon/{itemId}/{version}")
    @ApiOperation(value="Return the icon for a given catalog entry (application/image or HTTP redirect)")
    @ApiErrors(value={@ApiError(code=404, reason="Item not found")})
    @Produces(value={"application/image"})
    public Response getIcon(@ApiParam(name="itemId", value="ID of catalog item (application, entity, policy, location)", required=true) @PathParam(value="itemId") String var1, @ApiParam(name="version", value="version identifier of catalog item (application, entity, policy, location)", required=true) @PathParam(value="version") String var2);

    @POST
    @Path(value="/entities/{itemId}/deprecated/{deprecated}")
    public void setDeprecated(@ApiParam(name="itemId", value="The ID of the catalog item to be deprecated", required=true) @PathParam(value="itemId") String var1, @ApiParam(name="deprecated", value="Whether or not the catalog item is deprecated", required=true) @PathParam(value="deprecated") boolean var2);
}

