/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.ApplicationSpec;
import brooklyn.rest.domain.ApplicationSummary;
import brooklyn.rest.domain.EntitySummary;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonNode;

@Path(value="/v1/applications")
@Apidoc(value="Applications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ApplicationApi {
    @GET
    @Path(value="/tree")
    @ApiOperation(value="Fetch applications and entities tree hierarchy")
    @Deprecated
    public JsonNode applicationTree();

    @GET
    @Path(value="/fetch")
    @ApiOperation(value="Fetch display details for all applications and optionally selected additional entities")
    public JsonNode fetch(@ApiParam(value="Selected additional entity ID's to include, comma-separated", required=false) @DefaultValue(value="") @QueryParam(value="items") String var1);

    @GET
    @ApiOperation(value="Fetch list of applications, as ApplicationSummary objects", responseClass="brooklyn.rest.domain.ApplicationSummary")
    public List<ApplicationSummary> list(@ApiParam(value="Regular expression to filter by", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var1);

    @GET
    @Path(value="/{application}")
    @ApiOperation(value="Fetch a specific application", responseClass="brooklyn.rest.domain.ApplicationSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Application not found")})
    public ApplicationSummary get(@ApiParam(value="ID or name of application whose details will be returned", required=true) @PathParam(value="application") String var1);

    @POST
    @Consumes(value={"application/x-yaml", "text/yaml", "text/x-yaml", "application/yaml"})
    @ApiOperation(value="Create and start a new application from YAML", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Undefined entity or location"), @ApiError(code=412, reason="Application already registered")})
    public Response createFromYaml(@ApiParam(name="applicationSpec", value="App spec in CAMP YAML format", required=true) String var1);

    @POST
    @Consumes(value={"application/json", "application/octet-stream", "text/plain"})
    @ApiOperation(value="Create and start a new application from miscellaneous types, including JSON either new CAMP format or legacy AppSpec format", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Undefined entity or location"), @ApiError(code=412, reason="Application already registered")})
    public Response createPoly(@ApiParam(name="applicationSpec", value="App spec in JSON, YAML, or other (auto-detected) format", required=true) byte[] var1);

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Create and start a new application from form URL-encoded contents (underlying type autodetected)", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Undefined entity or location"), @ApiError(code=412, reason="Application already registered")})
    public Response createFromForm(@ApiParam(name="applicationSpec", value="App spec in form-encoded YAML, JSON, or other (auto-detected) format", required=true) @Valid String var1);

    @DELETE
    @Path(value="/{application}")
    @ApiOperation(value="Delete a specified application", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Application not found")})
    public Response delete(@ApiParam(name="application", value="Application name", required=true) @PathParam(value="application") String var1);

    @POST
    @Consumes(value={"application/json", "application/octet-stream", "text/plain"})
    @ApiOperation(value="Create and start a new application from miscellaneous types, including JSON either new CAMP format or legacy AppSpec format", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Undefined entity or location"), @ApiError(code=412, reason="Application already registered")})
    @Path(value="/createLegacy")
    @Deprecated
    public Response create(ApplicationSpec var1);

    @GET
    @Path(value="/{application}/descendants")
    @ApiOperation(value="Fetch entity info for all (or filtered) descendants", responseClass="brooklyn.rest.domain.EntitySummary")
    @ApiErrors(value={@ApiError(code=404, reason="Application or entity missing")})
    public List<EntitySummary> getDescendants(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Regular expression for an entity type which must be matched", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var2);

    @GET
    @Path(value="/{application}/descendants/sensor/{sensor}")
    @ApiOperation(value="Fetch values of a given sensor for all (or filtered) descendants")
    @ApiErrors(value={@ApiError(code=404, reason="Application or entity missing")})
    public Map<String, Object> getDescendantsSensor(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var2, @ApiParam(value="Regular expression for an entity type which must be matched", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var3);
}

