/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.api;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.TaskSummary;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/v1/activities")
@Apidoc(value="Activities")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ActivityApi {
    @GET
    @Path(value="/{task}")
    @ApiOperation(value="Fetch task details", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find task")})
    public TaskSummary get(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1);

    @GET
    @Path(value="/{task}/children")
    @ApiOperation(value="Fetch list of children tasks of this task")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find task")})
    public List<TaskSummary> children(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1);

    @GET
    @Path(value="/{task}/stream/{streamId}")
    @ApiOperation(value="Return the contents of the given stream")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find task or stream")})
    public String stream(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Stream ID", required=true) @PathParam(value="streamId") String var2);
}

