/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util.json;

import brooklyn.rest.util.json.ErrorAndToStringUnknownTypeSerializer;
import brooklyn.util.exceptions.Exceptions;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonStreamContext;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.StdSerializerProvider;
import org.codehaus.jackson.type.JavaType;

final class ConfigurableSerializerProvider
extends StdSerializerProvider {
    protected JsonSerializer<Object> unknownTypeSerializer;

    public ConfigurableSerializerProvider() {
    }

    public ConfigurableSerializerProvider(SerializationConfig config) {
        this(config, new ConfigurableSerializerProvider(), null);
    }

    public ConfigurableSerializerProvider(SerializationConfig config, ConfigurableSerializerProvider src, SerializerFactory jsf) {
        super(config, (StdSerializerProvider)src, jsf);
        this.unknownTypeSerializer = src.unknownTypeSerializer;
    }

    protected StdSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new ConfigurableSerializerProvider(config, this, jsf);
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> unknownType) {
        if (this.unknownTypeSerializer != null) {
            return this.unknownTypeSerializer;
        }
        return super.getUnknownTypeSerializer(unknownType);
    }

    public void setUnknownTypeSerializer(JsonSerializer<Object> unknownTypeSerializer) {
        this.unknownTypeSerializer = unknownTypeSerializer;
    }

    protected void _serializeValue(JsonGenerator jgen, Object value) throws IOException, JsonProcessingException {
        JsonStreamContext ctxt = jgen.getOutputContext();
        try {
            super._serializeValue(jgen, value);
        }
        catch (Exception e) {
            this.onSerializationException(ctxt, jgen, value, e);
        }
    }

    protected void _serializeValue(JsonGenerator jgen, Object value, JavaType rootType) throws IOException, JsonProcessingException {
        JsonStreamContext ctxt = jgen.getOutputContext();
        try {
            super._serializeValue(jgen, value, rootType);
        }
        catch (Exception e) {
            this.onSerializationException(ctxt, jgen, value, e);
        }
    }

    protected void onSerializationException(JsonStreamContext ctxt, JsonGenerator jgen, Object value, Exception e) throws IOException, JsonProcessingException {
        Exceptions.propagateIfFatal((Throwable)e);
        JsonSerializer<Object> unknownTypeSerializer = this.getUnknownTypeSerializer(value.getClass());
        if (unknownTypeSerializer instanceof ErrorAndToStringUnknownTypeSerializer) {
            ((ErrorAndToStringUnknownTypeSerializer)unknownTypeSerializer).serializeFromError(ctxt, e, value, jgen, (SerializerProvider)this);
        } else {
            unknownTypeSerializer.serialize(value, jgen, (SerializerProvider)this);
        }
    }
}

