/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util.json;

import brooklyn.config.BrooklynProperties;
import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.management.ManagementContext;
import brooklyn.management.ManagementContextInjectable;
import brooklyn.rest.util.json.BidiSerialization;
import brooklyn.rest.util.json.ConfigurableSerializerProvider;
import brooklyn.rest.util.json.ErrorAndToStringUnknownTypeSerializer;
import brooklyn.rest.util.json.MultimapSerializer;
import brooklyn.rest.util.json.PossiblyStrictPreferringFieldsVisibilityChecker;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynJacksonJsonProvider
extends JacksonJsonProvider
implements ManagementContextInjectable {
    private static final Logger log = LoggerFactory.getLogger(BrooklynJacksonJsonProvider.class);
    public static final String BROOKLYN_REST_OBJECT_MAPPER = "brooklyn.rest.objectMapper";
    @Context
    protected ServletContext servletContext;
    protected ObjectMapper ourMapper;
    protected boolean notFound = false;
    private ManagementContext mgmt;

    public ObjectMapper locateMapper(Class<?> type, MediaType mediaType) {
        if (this.ourMapper != null) {
            return this.ourMapper;
        }
        this.findSharedMapper();
        if (this.ourMapper != null) {
            return this.ourMapper;
        }
        if (!this.notFound) {
            log.warn("Management context not available; using default ObjectMapper in " + (Object)((Object)this));
            this.notFound = true;
        }
        return super.locateMapper(Object.class, MediaType.APPLICATION_JSON_TYPE);
    }

    protected synchronized ObjectMapper findSharedMapper() {
        if (this.ourMapper != null || this.notFound) {
            return this.ourMapper;
        }
        this.ourMapper = BrooklynJacksonJsonProvider.findSharedObjectMapper(this.servletContext, this.mgmt);
        if (this.ourMapper == null) {
            return null;
        }
        if (this.notFound) {
            this.notFound = false;
        }
        log.debug("Found mapper " + this.ourMapper + " for " + (Object)((Object)this) + ", creating custom Brooklyn mapper");
        return this.ourMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectMapper findSharedObjectMapper(ServletContext servletContext, ManagementContext mgmt) {
        if (servletContext != null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                ObjectMapper mapper = (ObjectMapper)servletContext.getAttribute(BROOKLYN_REST_OBJECT_MAPPER);
                if (mapper != null) {
                    return mapper;
                }
                mapper = BrooklynJacksonJsonProvider.newPrivateObjectMapper(BrooklynJacksonJsonProvider.getManagementContext(servletContext));
                servletContext.setAttribute(BROOKLYN_REST_OBJECT_MAPPER, (Object)mapper);
                return mapper;
            }
        }
        if (mgmt != null) {
            ManagementContext managementContext = mgmt;
            synchronized (managementContext) {
                ConfigKey key = ConfigKeys.newConfigKey(ObjectMapper.class, (String)BROOKLYN_REST_OBJECT_MAPPER);
                ObjectMapper mapper = (ObjectMapper)mgmt.getConfig().getConfig(key);
                if (mapper != null) {
                    return mapper;
                }
                mapper = BrooklynJacksonJsonProvider.newPrivateObjectMapper(mgmt);
                log.debug("Storing new ObjectMapper against " + mgmt + " because no ServletContext available: " + mapper);
                ((BrooklynProperties)mgmt.getConfig()).put(key, (Object)mapper);
                return mapper;
            }
        }
        return null;
    }

    public static ObjectMapper findAnyObjectMapper(ServletContext servletContext, ManagementContext mgmt) {
        ObjectMapper mapper = BrooklynJacksonJsonProvider.findSharedObjectMapper(servletContext, mgmt);
        if (mapper != null) {
            return mapper;
        }
        if (mgmt == null && servletContext != null) {
            mgmt = BrooklynJacksonJsonProvider.getManagementContext(servletContext);
        }
        return BrooklynJacksonJsonProvider.newPrivateObjectMapper(mgmt);
    }

    public static ObjectMapper newPrivateObjectMapper(ManagementContext mgmt) {
        if (mgmt == null) {
            throw new IllegalStateException("No management context available for creating ObjectMapper");
        }
        SerializationConfig defaultConfig = new ObjectMapper().getSerializationConfig();
        SerializationConfig sc = new SerializationConfig(defaultConfig.getClassIntrospector(), defaultConfig.getAnnotationIntrospector(), (VisibilityChecker)new PossiblyStrictPreferringFieldsVisibilityChecker(), null, null, TypeFactory.defaultInstance(), null);
        ConfigurableSerializerProvider sp = new ConfigurableSerializerProvider();
        sp.setUnknownTypeSerializer((JsonSerializer<Object>)new ErrorAndToStringUnknownTypeSerializer());
        ObjectMapper mapper = new ObjectMapper(null, (SerializerProvider)sp, null, sc, null);
        SimpleModule mapperModule = new SimpleModule("Brooklyn", new Version(0, 0, 0, "ignored"));
        new BidiSerialization.ManagementContextSerialization(mgmt).install(mapperModule);
        new BidiSerialization.EntitySerialization(mgmt).install(mapperModule);
        new BidiSerialization.LocationSerialization(mgmt).install(mapperModule);
        mapperModule.addSerializer((JsonSerializer)new MultimapSerializer());
        mapper.registerModule((Module)mapperModule);
        return mapper;
    }

    public static ManagementContext getManagementContext(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        return (ManagementContext)servletContext.getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
    }

    public void injectManagementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }
}

