/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util.json;

import brooklyn.basic.BrooklynObject;
import brooklyn.entity.Entity;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;

public class BidiSerialization {
    protected static final ThreadLocal<Boolean> STRICT_SERIALIZATION = new ThreadLocal();

    public static void setStrictSerialization(Boolean value) {
        STRICT_SERIALIZATION.set(value);
    }

    public static void clearStrictSerialization() {
        STRICT_SERIALIZATION.remove();
    }

    public static boolean isStrictSerialization() {
        Boolean result = STRICT_SERIALIZATION.get();
        if (result != null) {
            return result;
        }
        return false;
    }

    public static class LocationSerialization
    extends AbstractBrooklynObjectSerialization<Location> {
        public LocationSerialization(ManagementContext mgmt) {
            super(Location.class, mgmt);
        }

        @Override
        protected Location getInstanceFromId(String id) {
            return this.mgmt.getLocationManager().getLocation(id);
        }
    }

    public static class EntitySerialization
    extends AbstractBrooklynObjectSerialization<Entity> {
        public EntitySerialization(ManagementContext mgmt) {
            super(Entity.class, mgmt);
        }

        @Override
        protected Entity getInstanceFromId(String id) {
            return this.mgmt.getEntityManager().getEntity(id);
        }
    }

    public static abstract class AbstractBrooklynObjectSerialization<T extends BrooklynObject>
    extends AbstractWithManagementContextSerialization<T> {
        public AbstractBrooklynObjectSerialization(Class<T> type, ManagementContext mgmt) {
            super(type, mgmt);
        }

        @Override
        protected void writeBody(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException, JsonProcessingException {
            jgen.writeStringField("type", this.type.getCanonicalName());
            this.customWriteBody(value, jgen, provider);
        }

        @Override
        public void customWriteBody(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStringField("id", value.getId());
        }

        @Override
        protected T customReadBody(String type, Map<Object, Object> values, JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this.getInstanceFromId((String)values.get("id"));
        }

        protected abstract T getInstanceFromId(String var1);
    }

    public static class ManagementContextSerialization
    extends AbstractWithManagementContextSerialization<ManagementContext> {
        public ManagementContextSerialization(ManagementContext mgmt) {
            super(ManagementContext.class, mgmt);
        }

        @Override
        public void customWriteBody(ManagementContext value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        }

        @Override
        protected ManagementContext customReadBody(String type, Map<Object, Object> values, JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this.mgmt;
        }
    }

    public static abstract class AbstractWithManagementContextSerialization<T> {
        protected final Serializer serializer = new Serializer();
        protected final Deserializer deserializer = new Deserializer();
        protected final Class<T> type;
        protected final ManagementContext mgmt;

        public AbstractWithManagementContextSerialization(Class<T> type, ManagementContext mgmt) {
            this.type = type;
            this.mgmt = mgmt;
        }

        public JsonSerializer<T> getSerializer() {
            return this.serializer;
        }

        public JsonDeserializer<T> getDeserializer() {
            return this.deserializer;
        }

        public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            this.writeBody(value, jgen, provider);
            jgen.writeEndObject();
        }

        protected void writeBody(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException, JsonProcessingException {
            jgen.writeStringField("type", value.getClass().getCanonicalName());
            this.customWriteBody(value, jgen, provider);
        }

        public abstract void customWriteBody(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map values = (Map)jp.readValueAs(Map.class);
            String type = (String)values.get("type");
            return this.customReadBody(type, values, jp, ctxt);
        }

        protected abstract T customReadBody(String var1, Map<Object, Object> var2, JsonParser var3, DeserializationContext var4) throws IOException, JsonProcessingException;

        public void install(SimpleModule module) {
            module.addSerializer(this.type, (JsonSerializer)this.serializer);
            module.addDeserializer(this.type, (JsonDeserializer)this.deserializer);
        }

        protected class Deserializer
        extends JsonDeserializer<T> {
            protected Deserializer() {
            }

            public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return AbstractWithManagementContextSerialization.this.deserialize(jp, ctxt);
            }
        }

        protected class Serializer
        extends JsonSerializer<T> {
            protected Serializer() {
            }

            public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                AbstractWithManagementContextSerialization.this.serialize(value, jgen, provider);
            }
        }
    }
}

