/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util;

import brooklyn.basic.BrooklynTypes;
import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BasicApplication;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.event.Sensor;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.rest.domain.ApplicationSpec;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.net.Urls;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Future;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynRestResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(BrooklynRestResourceUtils.class);
    private final ManagementContext mgmt;

    public BrooklynRestResourceUtils(ManagementContext mgmt) {
        Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.mgmt = mgmt;
    }

    public BrooklynCatalog getCatalog() {
        return this.mgmt.getCatalog();
    }

    public ClassLoader getCatalogClassLoader() {
        return this.mgmt.getCatalogClassLoader();
    }

    public LocationRegistry getLocationRegistry() {
        return this.mgmt.getLocationRegistry();
    }

    public Policy getPolicy(String application, String entity, String policy) {
        return this.getPolicy((Entity)this.getEntity(application, entity), policy);
    }

    public Policy getPolicy(Entity entity, String policy) {
        if (policy == null) {
            return null;
        }
        for (Policy p : entity.getPolicies()) {
            if (!policy.equals(p.getId())) continue;
            return p;
        }
        for (Policy p : entity.getPolicies()) {
            if (!policy.equals(p.getDisplayName())) continue;
            return p;
        }
        throw WebResourceUtils.notFound("Cannot find policy '%s' in entity '%s'", policy, entity);
    }

    public EntityLocal getEntity(String application, String entity) {
        if (entity == null) {
            return null;
        }
        Application app = application != null ? this.getApplication(application) : null;
        EntityLocal e = (EntityLocal)this.mgmt.getEntityManager().getEntity(entity);
        if (e != null) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)e)) {
                throw WebResourceUtils.notFound("Cannot find entity '%s': no known ID and application not supplied for searching", entity);
            }
            if (app == null || app.equals(this.findTopLevelApplication((Entity)e))) {
                return e;
            }
            throw WebResourceUtils.preconditionFailed("Application '%s' specified does not match application '%s' to which entity '%s' (%s) is associated", application, e.getApplication() == null ? null : e.getApplication().getId(), entity, e);
        }
        if (application == null) {
            throw WebResourceUtils.notFound("Cannot find entity '%s': no known ID and application not supplied for searching", entity);
        }
        assert (app != null) : "null app should not be returned from getApplication";
        e = this.searchForEntityNamed((Entity)app, entity);
        if (e != null) {
            return e;
        }
        throw WebResourceUtils.notFound("Cannot find entity '%s' in application '%s' (%s)", entity, application, app);
    }

    private Application findTopLevelApplication(Entity e) {
        Application app;
        for (app = e.getApplication(); app != null && !app.equals(app.getApplication()); app = app.getApplication()) {
        }
        return app;
    }

    public Application getApplication(String application) {
        Entity e = this.mgmt.getEntityManager().getEntity(application);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)e)) {
            throw WebResourceUtils.notFound("Application '%s' not found", application);
        }
        if (e != null && e instanceof Application) {
            return (Application)e;
        }
        for (Application app : this.mgmt.getApplications()) {
            if (app.getId().equals(application)) {
                return app;
            }
            if (!application.equalsIgnoreCase(app.getDisplayName())) continue;
            return app;
        }
        throw WebResourceUtils.notFound("Application '%s' not found", application);
    }

    public EntityLocal searchForEntityNamed(Entity root, String entity) {
        if (root.getId().equals(entity) || entity.equals(root.getDisplayName())) {
            return (EntityLocal)root;
        }
        for (Entity child : root.getChildren()) {
            EntityLocal result = this.searchForEntityNamed(child, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Application create(ApplicationSpec spec) {
        String catalogItemId;
        Class clazz;
        Object entities;
        log.debug("REST creating application instance for {}", (Object)spec);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.DEPLOY_APPLICATION, (Object)spec)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to deploy application %s", Entitlements.getEntitlementContext().user(), spec);
        }
        String type = spec.getType();
        String name = spec.getName();
        Map configO = spec.getConfig();
        Object object = entities = spec.getEntities() == null ? ImmutableSet.of() : spec.getEntities();
        if (Strings.isEmpty((CharSequence)type)) {
            clazz = BasicApplication.class;
            catalogItemId = null;
        } else {
            Class<?> tempclazz;
            BrooklynCatalog catalog = this.getCatalog();
            CatalogItem item = catalog.getCatalogItemForType(type);
            if (item != null) {
                catalogItemId = item.getId();
                tempclazz = catalog.loadClass(item);
            } else {
                catalogItemId = null;
                try {
                    tempclazz = catalog.getRootClassLoader().loadClass(type);
                    log.info("Catalog does not contain item for type {}; loaded class directly instead", (Object)type);
                }
                catch (ClassNotFoundException e2) {
                    log.warn("No catalog item for type {}, and could not load class directly; rethrowing", (Object)type);
                    throw new NoSuchElementException("Unable to find catalog item for type " + type);
                }
            }
            clazz = tempclazz;
        }
        if (Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, null)) {
            try {
                EntitySpec<?> coreSpec;
                Application instance;
                if (ApplicationBuilder.class.isAssignableFrom(clazz)) {
                    Constructor constructor = clazz.getConstructor(new Class[0]);
                    ApplicationBuilder appBuilder = (ApplicationBuilder)constructor.newInstance(new Object[0]);
                    if (!Strings.isEmpty((CharSequence)name)) {
                        appBuilder.appDisplayName(name);
                    }
                    if (entities.size() > 0) {
                        log.warn("Cannot supply additional entities when using an ApplicationBuilder; ignoring in spec {}", (Object)spec);
                    }
                    log.info("REST placing '{}' under management", (Object)spec.getName());
                    appBuilder.configure(this.convertFlagsToKeys(appBuilder.getType(), configO));
                    this.configureRenderingMetadata(spec, appBuilder);
                    instance = appBuilder.manage(this.mgmt);
                } else if (Application.class.isAssignableFrom(clazz)) {
                    coreSpec = this.toCoreEntitySpec(clazz, name, configO, catalogItemId);
                    this.configureRenderingMetadata(spec, coreSpec);
                    instance = (Application)this.mgmt.getEntityManager().createEntity(coreSpec);
                    Iterator i$ = entities.iterator();
                    while (i$.hasNext()) {
                        brooklyn.rest.domain.EntitySpec entitySpec = (brooklyn.rest.domain.EntitySpec)i$.next();
                        log.info("REST creating instance for entity {}", (Object)entitySpec.getType());
                        instance.addChild(this.mgmt.getEntityManager().createEntity(this.toCoreEntitySpec(entitySpec)));
                    }
                    log.info("REST placing '{}' under management", (Object)(spec.getName() != null ? spec.getName() : spec));
                    Entities.startManagement((Application)instance, (ManagementContext)this.mgmt);
                } else if (Entity.class.isAssignableFrom(clazz)) {
                    if (entities.size() > 0) {
                        log.warn("Cannot supply additional entities when using a non-application entity; ignoring in spec {}", (Object)spec);
                    }
                    coreSpec = this.toCoreEntitySpec(BasicApplication.class, name, configO, catalogItemId);
                    this.configureRenderingMetadata(spec, coreSpec);
                    instance = (Application)this.mgmt.getEntityManager().createEntity(coreSpec);
                    Entity soleChild = this.mgmt.getEntityManager().createEntity(this.toCoreEntitySpec(clazz, name, configO, catalogItemId));
                    instance.addChild(soleChild);
                    instance.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagatingAllBut(new Sensor[]{Attributes.SERVICE_UP, Attributes.SERVICE_NOT_UP_INDICATORS, Attributes.SERVICE_STATE_ACTUAL, Attributes.SERVICE_STATE_EXPECTED, Attributes.SERVICE_PROBLEMS}).from(soleChild)).build());
                    log.info("REST placing '{}' under management", (Object)spec.getName());
                    Entities.startManagement((Application)instance, (ManagementContext)this.mgmt);
                } else {
                    throw new IllegalArgumentException("Class " + clazz + " must extend one of ApplicationBuilder, Application or Entity");
                }
                return instance;
            }
            catch (Exception e) {
                log.error("REST failed to create application: " + e, (Throwable)e);
                throw Exceptions.propagate((Throwable)e);
            }
        }
        throw WebResourceUtils.unauthorized("User '%s' is not authorized to create application from applicationSpec %s", Entitlements.getEntitlementContext().user(), spec);
    }

    public Task<?> start(Application app, ApplicationSpec spec) {
        return this.start(app, this.getLocations(spec));
    }

    public Task<?> start(Application app, List<? extends Location> locations) {
        return Entities.invokeEffector((EntityLocal)((EntityLocal)app), (Entity)app, (Effector)Startable.START, (Map)MutableMap.of((Object)"locations", locations));
    }

    public List<Location> getLocations(ApplicationSpec spec) {
        Function<String, Location> buildLocationFromId = new Function<String, Location>(){

            public Location apply(String id) {
                id = BrooklynRestResourceUtils.fixLocation(id);
                return BrooklynRestResourceUtils.this.getLocationRegistry().resolve(id);
            }
        };
        ArrayList locations = Lists.newArrayList((Iterable)Iterables.transform((Iterable)spec.getLocations(), (Function)buildLocationFromId));
        return locations;
    }

    private EntitySpec<? extends Entity> toCoreEntitySpec(brooklyn.rest.domain.EntitySpec spec) {
        String catalogItemId;
        Class<?> tempclazz;
        String type = spec.getType();
        String name = spec.getName();
        LinkedHashMap config = spec.getConfig() == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap((Map)spec.getConfig());
        BrooklynCatalog catalog = this.getCatalog();
        CatalogItem item = catalog.getCatalogItemForType(type);
        if (item != null) {
            tempclazz = catalog.loadClass(item);
            catalogItemId = item.getId();
        } else {
            catalogItemId = null;
            try {
                tempclazz = catalog.getRootClassLoader().loadClass(type);
                log.info("Catalog does not contain item for type {}; loaded class directly instead", (Object)type);
            }
            catch (ClassNotFoundException e2) {
                log.warn("No catalog item for type {}, and could not load class directly; rethrowing", (Object)type);
                throw new NoSuchElementException("Unable to find catalog item for type " + type);
            }
        }
        Class<?> clazz = tempclazz;
        EntitySpec result = clazz.isInterface() ? EntitySpec.create(clazz) : EntitySpec.create(Entity.class).impl(clazz).additionalInterfaces((Iterable)Reflections.getAllInterfaces(clazz));
        result.catalogItemId(catalogItemId);
        if (!Strings.isEmpty((CharSequence)name)) {
            result.displayName(name);
        }
        result.configure(this.convertFlagsToKeys(result.getType(), config));
        this.configureRenderingMetadata(spec, result);
        return result;
    }

    protected void configureRenderingMetadata(ApplicationSpec spec, ApplicationBuilder appBuilder) {
        appBuilder.configure(this.getRenderingConfigurationFor(spec.getType()));
    }

    protected void configureRenderingMetadata(ApplicationSpec input, EntitySpec<?> entity) {
        entity.configure(this.getRenderingConfigurationFor(input.getType()));
    }

    protected void configureRenderingMetadata(brooklyn.rest.domain.EntitySpec input, EntitySpec<?> entity) {
        entity.configure(this.getRenderingConfigurationFor(input.getType()));
    }

    protected Map<?, ?> getRenderingConfigurationFor(String catalogId) {
        MutableMap result = MutableMap.of();
        CatalogItem item = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt, (String)catalogId);
        if (item == null) {
            return result;
        }
        result.addIfNotNull((Object)"iconUrl", (Object)item.getIconUrl());
        return result;
    }

    private <T extends Entity> EntitySpec<?> toCoreEntitySpec(Class<T> clazz, String name, Map<String, String> configO, String catalogItemId) {
        EntitySpec result;
        LinkedHashMap config;
        LinkedHashMap linkedHashMap = config = configO == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap(configO);
        if (clazz.isInterface()) {
            result = EntitySpec.create(clazz);
        } else {
            Class interfaceclazz = Application.class.isAssignableFrom(clazz) ? Application.class : Entity.class;
            Set additionalInterfaceClazzes = Reflections.getInterfacesIncludingClassAncestors(clazz);
            result = EntitySpec.create(interfaceclazz).impl(clazz).additionalInterfaces((Iterable)additionalInterfaceClazzes);
        }
        result.catalogItemId(catalogItemId);
        if (!Strings.isEmpty((CharSequence)name)) {
            result.displayName(name);
        }
        result.configure(this.convertFlagsToKeys(result.getImplementation(), config));
        return result;
    }

    private Map<?, ?> convertFlagsToKeys(Class<? extends Entity> javaType, Map<?, ?> config) {
        if (config == null || config.isEmpty() || javaType == null) {
            return config;
        }
        Map configKeys = BrooklynTypes.getDefinedConfigKeys(javaType);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : config.entrySet()) {
            log.debug("Setting key {} to {} for REST creation of {}", new Object[]{entry.getKey(), entry.getValue(), javaType});
            Object key = configKeys.get(entry.getKey());
            if (key == null) {
                log.warn("Unrecognised config key {} passed to {}; will be treated as flag (and likely ignored)", entry.getKey(), javaType);
                key = entry.getKey();
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    public Task<?> destroy(final Application application) {
        return this.mgmt.getExecutionManager().submit((Map)MutableMap.of((Object)"displayName", (Object)("destroying " + application), (Object)"description", (Object)("REST call to destroy application " + application.getDisplayName() + " (" + application + ")")), new Runnable(){

            @Override
            public void run() {
                ((EntityInternal)application).destroy();
                BrooklynRestResourceUtils.this.mgmt.getEntityManager().unmanage((Entity)application);
            }
        });
    }

    public Task<?> expunge(final Entity entity, final boolean release) {
        if (this.mgmt.getEntitlementManager().isEntitled(Entitlements.getEntitlementContext(), Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)entity, (Object)Entitlements.StringAndArgument.of((String)"expunge", (Object)MutableMap.of((Object)"release", (Object)release))))) {
            return this.mgmt.getExecutionManager().submit((Map)MutableMap.of((Object)"displayName", (Object)("expunging " + entity), (Object)"description", (Object)("REST call to expunge entity " + entity.getDisplayName() + " (" + entity + ")")), new Runnable(){

                @Override
                public void run() {
                    if (release) {
                        Entities.destroyCatching((Entity)entity);
                    } else {
                        BrooklynRestResourceUtils.this.mgmt.getEntityManager().unmanage(entity);
                    }
                }
            });
        }
        throw WebResourceUtils.unauthorized("User '%s' is not authorized to expunge entity %s", Entitlements.getEntitlementContext().user(), entity);
    }

    @Deprecated
    public Response createCatalogEntryFromGroovyCode(String groovyCode) {
        ClassLoader parent = this.getCatalog().getRootClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parent);
        Class clazz = loader.parseClass(groovyCode);
        if (AbstractEntity.class.isAssignableFrom(clazz)) {
            CatalogItem item = this.getCatalog().addItem(clazz);
            log.info("REST created " + item);
            return Response.created((URI)URI.create("entities/" + clazz.getName())).build();
        }
        if (AbstractPolicy.class.isAssignableFrom(clazz)) {
            CatalogItem item = this.getCatalog().addItem(clazz);
            log.info("REST created " + item);
            return Response.created((URI)URI.create("policies/" + clazz.getName())).build();
        }
        throw WebResourceUtils.preconditionFailed("Unsupported type superclass " + clazz.getSuperclass() + "; expects Entity or Policy", new Object[0]);
    }

    @Deprecated
    public static String fixLocation(String locationId) {
        if (locationId.startsWith("/v1/locations/")) {
            log.warn("REST API using legacy URI syntax for location: " + locationId);
            locationId = Strings.removeFromStart((String)locationId, (String)"/v1/locations/");
        }
        return locationId;
    }

    public Object getObjectValueForDisplay(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Future && ((Future)value).isDone()) {
            try {
                value = ((Future)value).get();
            }
            catch (Exception e) {
                value = "" + value + " (error evaluating: " + e + ")";
            }
        }
        if (TypeCoercions.isPrimitiveOrBoxer(value.getClass())) {
            return value;
        }
        return value.toString();
    }

    public String getStringValueForDisplay(Object value) {
        if (value == null) {
            return null;
        }
        return "" + this.getObjectValueForDisplay(value);
    }

    public boolean isUrlServerSideAndSafe(String url) {
        if (Strings.isEmpty((CharSequence)url)) {
            return false;
        }
        String ext = Files.getFileExtension((String)url);
        if (Strings.isEmpty((CharSequence)ext)) {
            return false;
        }
        MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(ext);
        if (mime == null) {
            return false;
        }
        return !Urls.isUrlWithProtocol((String)url) || url.startsWith("classpath:");
    }

    public Iterable<Entity> descendantsOfAnyType(String application, String entity) {
        ArrayList result = Lists.newArrayList();
        EntityLocal e = this.getEntity(application, entity);
        BrooklynRestResourceUtils.gatherAllDescendants((Entity)e, result);
        return result;
    }

    private static void gatherAllDescendants(Entity e, List<Entity> result) {
        if (result.add(e)) {
            for (Entity ee : e.getChildren()) {
                BrooklynRestResourceUtils.gatherAllDescendants(ee, result);
            }
        }
    }

    public Iterable<Entity> descendantsOfType(String application, String entity, final String typeRegex) {
        Iterable<Entity> result = this.descendantsOfAnyType(application, entity);
        return Iterables.filter(result, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                if (entity == null) {
                    return false;
                }
                return entity.getEntityType().getName().matches(typeRegex);
            }
        });
    }

    public void reloadBrooklynProperties() {
        this.mgmt.reloadBrooklynProperties();
    }
}

