/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.management.HasTaskChildren;
import brooklyn.management.Task;
import brooklyn.rest.domain.LinkWithMetadata;
import brooklyn.rest.domain.TaskSummary;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.TaskInternal;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTransformer {
    private static final Logger log = LoggerFactory.getLogger(TaskTransformer.class);
    public static final Function<Task<?>, TaskSummary> FROM_TASK = new Function<Task<?>, TaskSummary>(){

        public TaskSummary apply(@Nullable Task<?> input) {
            return TaskTransformer.taskSummary(input);
        }
    };

    public static TaskSummary taskSummary(Task<?> task) {
        try {
            Object result;
            URI entityLink;
            String entityDisplayName;
            String entityId;
            Preconditions.checkNotNull(task);
            Entity entity = BrooklynTaskTags.getContextEntity(task);
            String selfLink = TaskTransformer.asLink(task).getLink();
            if (entity != null) {
                entityId = entity.getId();
                entityDisplayName = entity.getDisplayName();
                entityLink = new URI("/v1/applications/" + entity.getApplicationId() + "/" + "entities" + "/" + entity.getId());
            } else {
                entityId = null;
                entityDisplayName = null;
                entityLink = null;
            }
            List children = Collections.emptyList();
            if (task instanceof HasTaskChildren) {
                children = new ArrayList();
                for (Task t : ((HasTaskChildren)task).getChildren()) {
                    children.add(TaskTransformer.asLink(t));
                }
            }
            MutableMap streams = new MutableMap();
            for (BrooklynTaskTags.WrappedStream stream : BrooklynTaskTags.streams(task)) {
                MutableMap metadata = MutableMap.of((Object)"name", (Object)stream.streamType);
                if (stream.streamSize.get() != null) {
                    metadata.add((Object)"size", stream.streamSize.get());
                    metadata.add((Object)"sizeText", (Object)Strings.makeSizeString((long)((Integer)stream.streamSize.get()).intValue()));
                }
                String link = selfLink + "/stream/" + stream.streamType;
                streams.put(stream.streamType, new LinkWithMetadata(link, (Map)metadata));
            }
            MutableMap links = MutableMap.of((Object)"self", (Object)new URI(selfLink), (Object)"children", (Object)new URI(selfLink + "/" + "children"));
            if (entityLink != null) {
                links.put("entity", entityLink);
            }
            try {
                result = task.isDone() ? WebResourceUtils.getValueForDisplay(task.get(), true, false) : null;
            }
            catch (Throwable t) {
                result = Exceptions.collapseText((Throwable)t);
            }
            return new TaskSummary(task.getId(), task.getDisplayName(), task.getDescription(), entityId, entityDisplayName, task.getTags(), TaskTransformer.ifPositive(task.getSubmitTimeUtc()), TaskTransformer.ifPositive(task.getStartTimeUtc()), TaskTransformer.ifPositive(task.getEndTimeUtc()), task.getStatusSummary(), result, task.isError(), task.isCancelled(), children, TaskTransformer.asLink(task.getSubmittedByTask()), task.isDone() ? null : (task instanceof TaskInternal ? TaskTransformer.asLink(((TaskInternal)task).getBlockingTask()) : null), task.isDone() ? null : (task instanceof TaskInternal ? ((TaskInternal)task).getBlockingDetails() : null), task.getStatusDetail(true), (Map)streams, (Map)links);
        }
        catch (URISyntaxException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static Long ifPositive(Long time) {
        if (time == null || time <= 0L) {
            return null;
        }
        return time;
    }

    public static LinkWithMetadata asLink(Task<?> t) {
        Entity entity;
        if (t == null) {
            return null;
        }
        MutableMap data = new MutableMap();
        data.put((Object)"id", (Object)t.getId());
        if (t.getDisplayName() != null) {
            data.put((Object)"taskName", (Object)t.getDisplayName());
        }
        if ((entity = BrooklynTaskTags.getContextEntity(t)) != null) {
            data.put((Object)"entityId", (Object)entity.getId());
            if (entity.getDisplayName() != null) {
                data.put((Object)"entityDisplayName", (Object)entity.getDisplayName());
            }
        }
        return new LinkWithMetadata("/v1/activities/" + t.getId(), (Map)data);
    }
}

