/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.Policies;
import brooklyn.rest.domain.ApplicationSummary;
import brooklyn.rest.domain.PolicyConfigSummary;
import brooklyn.rest.domain.PolicySummary;
import brooklyn.rest.resources.PolicyConfigResource;
import brooklyn.rest.transform.ApplicationTransformer;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

public class PolicyTransformer {
    public static PolicySummary policySummary(Entity entity, Policy policy) {
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = applicationUri + "/entities/" + entity.getId();
        ImmutableMap links = ImmutableMap.builder().put((Object)"self", (Object)URI.create(entityUri + "/policies/" + policy.getId())).put((Object)"config", (Object)URI.create(entityUri + "/policies/" + policy.getId() + "/config")).put((Object)"start", (Object)URI.create(entityUri + "/policies/" + policy.getId() + "/start")).put((Object)"stop", (Object)URI.create(entityUri + "/policies/" + policy.getId() + "/stop")).put((Object)"destroy", (Object)URI.create(entityUri + "/policies/" + policy.getId() + "/destroy")).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).build();
        return new PolicySummary(policy.getId(), policy.getDisplayName(), policy.getCatalogItemId(), ApplicationTransformer.statusFromLifecycle(Policies.getPolicyStatus((Policy)policy)), (Map)links);
    }

    public static PolicyConfigSummary policyConfigSummary(BrooklynRestResourceUtils utils, ApplicationSummary application, EntityLocal entity, Policy policy, ConfigKey<?> config) {
        PolicyConfigSummary summary = PolicyTransformer.policyConfigSummary(utils, entity, policy, config);
        return summary;
    }

    public static PolicyConfigSummary policyConfigSummary(BrooklynRestResourceUtils utils, EntityLocal entity, Policy policy, ConfigKey<?> config) {
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = applicationUri + "/entities/" + entity.getId();
        String policyUri = entityUri + "/policies/" + policy.getId();
        ImmutableMap links = ImmutableMap.builder().put((Object)"self", (Object)URI.create(policyUri + "/config/" + config.getName())).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).put((Object)"policy", (Object)URI.create(policyUri)).build();
        return new PolicyConfigSummary(config.getName(), config.getTypeName(), config.getDescription(), (Object)PolicyConfigResource.getStringValueForDisplay(utils, policy, config.getDefaultValue()), config.isReconfigurable(), (Map)links);
    }
}

