/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.ParameterType;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.rest.domain.EffectorSummary;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class EffectorTransformer {
    public static EffectorSummary effectorSummary(final EntityLocal entity, Effector<?> effector) {
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = applicationUri + "/entities/" + entity.getId();
        return new EffectorSummary(effector.getName(), effector.getReturnTypeName(), (Set)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)effector.getParameters(), (Function)new Function<ParameterType<?>, EffectorSummary.ParameterSummary<?>>(){

            public EffectorSummary.ParameterSummary<?> apply(@Nullable ParameterType<?> parameterType) {
                return EffectorTransformer.parameterSummary((Entity)entity, parameterType);
            }
        })), effector.getDescription(), (Map)ImmutableMap.of((Object)"self", (Object)URI.create(entityUri + "/effectors/" + effector.getName()), (Object)"entity", (Object)URI.create(entityUri), (Object)"application", (Object)URI.create(applicationUri)));
    }

    public static EffectorSummary effectorSummaryForCatalog(Effector<?> effector) {
        ImmutableSet parameters = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)effector.getParameters(), (Function)new Function<ParameterType<?>, EffectorSummary.ParameterSummary<?>>(){

            public EffectorSummary.ParameterSummary<?> apply(ParameterType<?> parameterType) {
                return EffectorTransformer.parameterSummary(null, parameterType);
            }
        }));
        return new EffectorSummary(effector.getName(), effector.getReturnTypeName(), (Set)parameters, effector.getDescription(), null);
    }

    protected static EffectorSummary.ParameterSummary<?> parameterSummary(Entity entity, ParameterType<?> parameterType) {
        try {
            Maybe defaultValue = Tasks.resolving((Object)parameterType.getDefaultValue()).as(parameterType.getParameterClass()).context(entity != null ? ((EntityInternal)entity).getExecutionContext() : null).timeout(Duration.millis((Number)50)).getMaybe();
            return new EffectorSummary.ParameterSummary(parameterType.getName(), parameterType.getParameterClassName(), parameterType.getDescription(), WebResourceUtils.getValueForDisplay(defaultValue.orNull(), true, false));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

