/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.basic.BrooklynTypes;
import brooklyn.catalog.CatalogItem;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.EntityType;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.rest.domain.CatalogEntitySummary;
import brooklyn.rest.domain.CatalogItemSummary;
import brooklyn.rest.domain.CatalogLocationSummary;
import brooklyn.rest.domain.CatalogPolicySummary;
import brooklyn.rest.domain.SummaryComparators;
import brooklyn.rest.transform.EffectorTransformer;
import brooklyn.rest.transform.EntityTransformer;
import brooklyn.rest.transform.SensorTransformer;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogTransformer {
    private static final Logger log = LoggerFactory.getLogger(CatalogTransformer.class);

    public static CatalogEntitySummary catalogEntitySummary(BrooklynRestResourceUtils b, CatalogItem<? extends Entity, EntitySpec<?>> item) {
        EntitySpec spec = (EntitySpec)b.getCatalog().createSpec(item);
        EntityDynamicType typeMap = BrooklynTypes.getDefinedEntityType((Class)spec.getType());
        EntityType type = typeMap.getSnapshot();
        TreeSet config = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
        TreeSet sensors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
        TreeSet effectors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
        for (ConfigKey x : type.getConfigKeys()) {
            config.add(EntityTransformer.entityConfigSummary(x, typeMap.getConfigKeyField(x.getName())));
        }
        for (ConfigKey x : type.getSensors()) {
            sensors.add(SensorTransformer.sensorSummaryForCatalog(x));
        }
        for (ConfigKey x : type.getEffectors()) {
            effectors.add(EffectorTransformer.effectorSummaryForCatalog(x));
        }
        return new CatalogEntitySummary(item.getSymbolicName(), item.getVersion(), item.getDisplayName(), item.getJavaType(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl()), (Set)config, (Set)sensors, (Set)effectors, item.isDeprecated(), CatalogTransformer.makeLinks(item));
    }

    public static CatalogItemSummary catalogItemSummary(BrooklynRestResourceUtils b, CatalogItem<?, ?> item) {
        try {
            switch (item.getCatalogItemType()) {
                case TEMPLATE: 
                case ENTITY: {
                    return CatalogTransformer.catalogEntitySummary(b, item);
                }
                case POLICY: {
                    return CatalogTransformer.catalogPolicySummary(b, item);
                }
                case LOCATION: {
                    return CatalogTransformer.catalogLocationSummary(b, item);
                }
            }
            log.warn("Unexpected catalog item type when getting self link (supplying generic item): " + item.getCatalogItemType() + " " + item);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Invalid item in catalog when converting REST summaries (supplying generic item), at " + item + ": " + e, (Throwable)e);
        }
        return new CatalogItemSummary(item.getSymbolicName(), item.getVersion(), item.getDisplayName(), item.getJavaType(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl()), item.isDeprecated(), CatalogTransformer.makeLinks(item));
    }

    public static CatalogPolicySummary catalogPolicySummary(BrooklynRestResourceUtils b, CatalogItem<? extends Policy, PolicySpec<?>> item) {
        ImmutableSet config = ImmutableSet.of();
        return new CatalogPolicySummary(item.getSymbolicName(), item.getVersion(), item.getDisplayName(), item.getJavaType(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl()), (Set)config, item.isDeprecated(), CatalogTransformer.makeLinks(item));
    }

    public static CatalogLocationSummary catalogLocationSummary(BrooklynRestResourceUtils b, CatalogItem<? extends Location, LocationSpec<?>> item) {
        ImmutableSet config = ImmutableSet.of();
        return new CatalogLocationSummary(item.getSymbolicName(), item.getVersion(), item.getDisplayName(), item.getJavaType(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl()), (Set)config, item.isDeprecated(), CatalogTransformer.makeLinks(item));
    }

    protected static Map<String, URI> makeLinks(CatalogItem<?, ?> item) {
        return MutableMap.of().addIfNotNull((Object)"self", (Object)URI.create(CatalogTransformer.getSelfLink(item)));
    }

    protected static String getSelfLink(CatalogItem<?, ?> item) {
        String itemId = item.getId();
        switch (item.getCatalogItemType()) {
            case TEMPLATE: {
                return "/v1/applications/" + itemId + "/" + item.getVersion();
            }
            case ENTITY: {
                return "/v1/entities/" + itemId + "/" + item.getVersion();
            }
            case POLICY: {
                return "/v1/policies/" + itemId + "/" + item.getVersion();
            }
            case LOCATION: {
                return "/v1/locations/" + itemId + "/" + item.getVersion();
            }
        }
        log.warn("Unexpected catalog item type when getting self link (not supplying self link): " + item.getCatalogItemType() + " " + item);
        return null;
    }

    private static String tidyIconLink(BrooklynRestResourceUtils b, CatalogItem<?, ?> item, String iconUrl) {
        if (b.isUrlServerSideAndSafe(iconUrl)) {
            return "/v1/catalog/icon/" + item.getSymbolicName() + "/" + item.getVersion();
        }
        return iconUrl;
    }
}

