/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.entity.Application;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.trait.Startable;
import brooklyn.location.Location;
import brooklyn.rest.domain.ApplicationSpec;
import brooklyn.rest.domain.ApplicationSummary;
import brooklyn.rest.domain.Status;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class ApplicationTransformer {
    public static final Function<? super Application, ApplicationSummary> FROM_APPLICATION = new Function<Application, ApplicationSummary>(){

        public ApplicationSummary apply(Application input) {
            return ApplicationTransformer.summaryFromApplication(input);
        }
    };

    public static Status statusFromApplication(Application application) {
        if (application == null) {
            return Status.UNKNOWN;
        }
        Lifecycle state = (Lifecycle)application.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
        if (state != null) {
            return ApplicationTransformer.statusFromLifecycle(state);
        }
        Boolean up = (Boolean)application.getAttribute(Startable.SERVICE_UP);
        if (up != null && up.booleanValue()) {
            return Status.RUNNING;
        }
        return Status.UNKNOWN;
    }

    public static Status statusFromLifecycle(Lifecycle state) {
        if (state == null) {
            return Status.UNKNOWN;
        }
        switch (state) {
            case CREATED: {
                return Status.ACCEPTED;
            }
            case STARTING: {
                return Status.STARTING;
            }
            case RUNNING: {
                return Status.RUNNING;
            }
            case STOPPING: {
                return Status.STOPPING;
            }
            case STOPPED: {
                return Status.STOPPED;
            }
            case DESTROYED: {
                return Status.DESTROYED;
            }
        }
        return Status.UNKNOWN;
    }

    public static ApplicationSpec specFromApplication(Application application) {
        Collection locations = Collections2.transform((Collection)application.getLocations(), (Function)new Function<Location, String>(){

            @Nullable
            public String apply(@Nullable Location input) {
                return input.getId();
            }
        });
        return new ApplicationSpec(application.getDisplayName(), application.getEntityType().getName(), null, locations, null);
    }

    public static ApplicationSummary summaryFromApplication(Application application) {
        ImmutableMap links = application.getId() == null ? Collections.emptyMap() : ImmutableMap.of((Object)"self", (Object)URI.create("/v1/applications/" + application.getId()), (Object)"entities", (Object)URI.create("/v1/applications/" + application.getId() + "/entities"));
        return new ApplicationSummary(application.getId(), ApplicationTransformer.specFromApplication(application), ApplicationTransformer.statusFromApplication(application), links);
    }
}

