/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.security.provider;

import brooklyn.config.StringConfigMap;
import brooklyn.management.ManagementContext;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.security.provider.AbstractSecurityProvider;
import brooklyn.rest.security.provider.SecurityProvider;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import com.google.common.base.CharMatcher;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSecurityProvider
extends AbstractSecurityProvider
implements SecurityProvider {
    public static final Logger LOG = LoggerFactory.getLogger(LdapSecurityProvider.class);
    public static final String LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private final String ldapUrl;
    private final String ldapRealm;
    static boolean triedLoading = false;

    public LdapSecurityProvider(ManagementContext mgmt) {
        StringConfigMap properties = mgmt.getConfig();
        this.ldapUrl = (String)properties.getConfig(BrooklynWebConfig.LDAP_URL);
        Strings.checkNonEmpty((CharSequence)this.ldapUrl, (String)("LDAP security provider configuration missing required property " + BrooklynWebConfig.LDAP_URL));
        this.ldapRealm = CharMatcher.isNot((char)'\"').retainFrom((CharSequence)properties.getConfig(BrooklynWebConfig.LDAP_REALM));
        Strings.checkNonEmpty((CharSequence)this.ldapRealm, (String)("LDAP security provider configuration missing required property " + BrooklynWebConfig.LDAP_REALM));
    }

    public LdapSecurityProvider(String ldapUrl, String ldapRealm) {
        this.ldapUrl = ldapUrl;
        this.ldapRealm = ldapRealm;
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        if (session == null || user == null) {
            return false;
        }
        LdapSecurityProvider.checkCanLoad();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.getUserDN(user));
        env.put("java.naming.security.credentials", password);
        try {
            new InitialDirContext(env);
            return this.allow(session, user);
        }
        catch (NamingException e) {
            return false;
        }
    }

    private String getUserDN(String user) {
        return "cn=" + user + "," + this.ldapRealm;
    }

    public static synchronized void checkCanLoad() {
        if (triedLoading) {
            return;
        }
        try {
            Class.forName(LDAP_CONTEXT_FACTORY);
            triedLoading = true;
        }
        catch (Throwable e) {
            throw Exceptions.propagate((Throwable)new ClassNotFoundException("Unable to load LDAP classes (com.sun.jndi.ldap.LdapCtxFactory) required for Brooklyn LDAP security provider"));
        }
    }
}

