/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.security.provider;

import brooklyn.config.BrooklynProperties;
import brooklyn.config.StringConfigMap;
import brooklyn.management.ManagementContext;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.security.PasswordHasher;
import brooklyn.rest.security.provider.AbstractSecurityProvider;
import brooklyn.rest.security.provider.SecurityProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitUsersSecurityProvider
extends AbstractSecurityProvider
implements SecurityProvider {
    public static final Logger LOG = LoggerFactory.getLogger(ExplicitUsersSecurityProvider.class);
    protected final ManagementContext mgmt;
    private boolean allowAnyUserWithValidPass;
    private Set<String> allowedUsers = null;

    public ExplicitUsersSecurityProvider(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    private synchronized void initialize() {
        if (this.allowedUsers != null) {
            return;
        }
        StringConfigMap properties = this.mgmt.getConfig();
        this.allowedUsers = new LinkedHashSet<String>();
        String users = (String)properties.getConfig(BrooklynWebConfig.USERS);
        if (users == null) {
            LOG.warn("REST has no users configured; no one will be able to log in!");
        } else if ("*".equals(users)) {
            LOG.info("REST allowing any user (so long as valid password is set)");
            this.allowAnyUserWithValidPass = true;
        } else {
            StringTokenizer t = new StringTokenizer(users, ",");
            while (t.hasMoreElements()) {
                this.allowedUsers.add(("" + t.nextElement()).trim());
            }
            LOG.info("REST allowing users: " + this.allowedUsers);
        }
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        if (session == null || user == null) {
            return false;
        }
        this.initialize();
        if (!this.allowAnyUserWithValidPass && !this.allowedUsers.contains(user)) {
            LOG.debug("REST rejecting unknown user " + user);
            return false;
        }
        BrooklynProperties properties = (BrooklynProperties)this.mgmt.getConfig();
        String expectedP = (String)properties.getConfig(BrooklynWebConfig.PASSWORD_FOR_USER(user));
        String salt = (String)properties.getConfig(BrooklynWebConfig.SALT_FOR_USER(user));
        String expectedSha256 = (String)properties.getConfig(BrooklynWebConfig.SHA256_FOR_USER(user));
        if (expectedP != null) {
            return expectedP.equals(password) && this.allow(session, user);
        }
        if (expectedSha256 != null) {
            String hashedPassword = PasswordHasher.sha256(salt, password);
            return expectedSha256.equals(hashedPassword) && this.allow(session, user);
        }
        return false;
    }
}

