/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.rest.api.SensorApi;
import brooklyn.rest.domain.SensorSummary;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.SensorTransformer;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class SensorResource
extends AbstractBrooklynRestResource
implements SensorApi {
    private static final Logger log = LoggerFactory.getLogger(SensorResource.class);

    public List<SensorSummary> list(String application, String entityToken) {
        final EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)entity.getEntityType().getSensors(), AttributeSensor.class), (Function)new Function<AttributeSensor, SensorSummary>(){

            public SensorSummary apply(AttributeSensor sensor) {
                return SensorTransformer.sensorSummary((Entity)entity, sensor);
            }
        }));
    }

    public Map<String, Object> batchSensorRead(String application, String entityToken, Boolean raw) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        HashMap sensorMap = Maps.newHashMap();
        Iterable sensors = Iterables.filter((Iterable)entity.getEntityType().getSensors(), AttributeSensor.class);
        for (AttributeSensor sensor : sensors) {
            Object value = entity.getAttribute(this.findSensor(entity, sensor.getName()));
            if (Boolean.FALSE.equals(raw)) {
                value = RendererHints.applyDisplayValueHint((AttributeSensor)sensor, (Object)value);
            }
            sensorMap.put(sensor.getName(), this.getValueForDisplay(value, true, false));
        }
        return sensorMap;
    }

    protected Object get(boolean preferJson, String application, String entityToken, String sensorName, Boolean raw) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
        Object value = entity.getAttribute(sensor);
        if (Boolean.FALSE.equals(raw)) {
            value = RendererHints.applyDisplayValueHint(sensor, (Object)value);
        }
        return this.getValueForDisplay(value, preferJson, true);
    }

    public String getPlain(String application, String entityToken, String sensorName, Boolean raw) {
        return (String)this.get(false, application, entityToken, sensorName, raw);
    }

    public Object get(String application, String entityToken, String sensorName, Boolean raw) {
        return this.get(true, application, entityToken, sensorName, raw);
    }

    private AttributeSensor<?> findSensor(EntityLocal entity, String name) {
        Sensor s = entity.getEntityType().getSensor(name);
        if (s instanceof AttributeSensor) {
            return (AttributeSensor)s;
        }
        return new BasicAttributeSensor(Object.class, name);
    }

    public void setFromMap(String application, String entityToken, Map newValues) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        if (log.isDebugEnabled()) {
            log.debug("REST user " + Entitlements.getEntitlementContext() + " setting sensors " + newValues);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            String sensorName = Strings.toString(entry.getKey());
            Object newValue = entry.getValue();
            AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
            entity.setAttribute(sensor, newValue);
        }
    }

    public void set(String application, String entityToken, String sensorName, Object newValue) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
        if (log.isDebugEnabled()) {
            log.debug("REST user " + Entitlements.getEntitlementContext() + " setting sensor " + sensorName + " to " + newValue);
        }
        entity.setAttribute(sensor, newValue);
    }

    public void delete(String application, String entityToken, String sensorName) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        AttributeSensor<?> sensor = this.findSensor(entity, sensorName);
        if (log.isDebugEnabled()) {
            log.debug("REST user " + Entitlements.getEntitlementContext() + " deleting sensor " + sensorName);
        }
        ((EntityInternal)entity).removeAttribute(sensor);
    }
}

