/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.rest.api.ScriptApi;
import brooklyn.rest.domain.ScriptExecutionSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.util.stream.ThreadLocalPrintStream;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptResource
extends AbstractBrooklynRestResource
implements ScriptApi {
    private static final Logger log = LoggerFactory.getLogger(ScriptResource.class);
    public static final String USER_DATA_MAP_SESSION_ATTRIBUTE = "brooklyn.script.groovy.user.data";
    public static final String USER_LAST_VALUE_SESSION_ATTRIBUTE = "brooklyn.script.groovy.user.last";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptExecutionSummary groovy(HttpServletRequest request, String script) {
        HttpSession session;
        log.info("Web REST executing user-supplied script");
        if (log.isDebugEnabled()) {
            log.debug("Web REST user-supplied script contents:\n" + script);
        }
        Binding binding = new Binding();
        binding.setVariable("mgmt", (Object)this.mgmt());
        HttpSession httpSession = session = request != null ? request.getSession() : null;
        if (session != null) {
            LinkedHashMap data = (LinkedHashMap)session.getAttribute(USER_DATA_MAP_SESSION_ATTRIBUTE);
            if (data == null) {
                data = new LinkedHashMap();
                session.setAttribute(USER_DATA_MAP_SESSION_ATTRIBUTE, data);
            }
            binding.setVariable("data", data);
            Object last = session.getAttribute(USER_LAST_VALUE_SESSION_ATTRIBUTE);
            binding.setVariable("last", last);
        }
        GroovyShell shell = new GroovyShell(binding);
        ThreadLocalPrintStream.OutputCapturingContext stdout = ThreadLocalPrintStream.stdout().captureTee();
        ThreadLocalPrintStream.OutputCapturingContext stderr = ThreadLocalPrintStream.stderr().captureTee();
        Object value = null;
        Throwable problem = null;
        try {
            value = shell.evaluate(script);
            if (session != null) {
                session.setAttribute(USER_LAST_VALUE_SESSION_ATTRIBUTE, value);
            }
        }
        catch (Throwable t) {
            log.warn("Problem in user-supplied script: " + t, t);
            problem = t;
        }
        finally {
            stdout.end();
            stderr.end();
        }
        if (log.isDebugEnabled()) {
            log.debug("Web REST user-supplied script completed:\n" + (value != null ? "RESULT: " + value.toString() + "\n" : "") + (problem != null ? "ERROR: " + problem.toString() + "\n" : "") + (!stdout.isEmpty() ? "STDOUT: " + stdout.toString() + "\n" : "") + (!stderr.isEmpty() ? "STDERR: " + stderr.toString() + "\n" : ""));
        }
        return new ScriptExecutionSummary((Object)(value != null ? value.toString() : null), problem != null ? problem.toString() : null, stdout.toString(), stderr.toString());
    }
}

