/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynTags;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.location.Location;
import brooklyn.management.ExecutionManager;
import brooklyn.management.Task;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.EntitlementPredicates;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.internal.EntityManagementUtils;
import brooklyn.rest.api.EntityApi;
import brooklyn.rest.domain.EntitySummary;
import brooklyn.rest.domain.LocationSummary;
import brooklyn.rest.domain.TaskSummary;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.resources.ApplicationResource;
import brooklyn.rest.transform.EntityTransformer;
import brooklyn.rest.transform.LocationTransformer;
import brooklyn.rest.transform.TaskTransformer;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableList;
import brooklyn.util.time.Duration;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class EntityResource
extends AbstractBrooklynRestResource
implements EntityApi {
    private static final Logger log = LoggerFactory.getLogger(EntityResource.class);
    @Context
    private UriInfo uriInfo;

    public List<EntitySummary> list(String application) {
        return FluentIterable.from((Iterable)this.brooklyn().getApplication(application).getChildren()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).transform(EntityTransformer.FROM_ENTITY).toList();
    }

    public EntitySummary get(String application, String entityName) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityName);
        if (Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            return EntityTransformer.entitySummary((Entity)entity);
        }
        throw WebResourceUtils.unauthorized("User '%s' is not authorized to get entity '%s'", Entitlements.getEntitlementContext().user(), entity);
    }

    public List<EntitySummary> getChildren(String application, String entity) {
        return FluentIterable.from((Iterable)this.brooklyn().getEntity(application, entity).getChildren()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).transform(EntityTransformer.FROM_ENTITY).toList();
    }

    public List<EntitySummary> getChildrenOld(String application, String entity) {
        log.warn("Using deprecated call to /entities when /children should be used");
        return this.getChildren(application, entity);
    }

    public Response addChildren(String applicationToken, String entityToken, Boolean start, String timeoutS, String yaml) {
        Response.ResponseBuilder response;
        EntityLocal parent = this.brooklyn().getEntity(applicationToken, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)parent)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entityToken);
        }
        EntityManagementUtils.CreationResult added = EntityManagementUtils.addChildren((EntityLocal)parent, (String)yaml, (Boolean)start).blockUntilComplete(timeoutS == null ? Duration.millis((Number)20) : Duration.of((Object)timeoutS));
        if (((List)added.get()).size() == 1) {
            Entity child = (Entity)Iterables.getOnlyElement((Iterable)((Iterable)added.get()));
            URI ref = this.uriInfo.getBaseUriBuilder().path(EntityApi.class).path(EntityApi.class, "get").build(new Object[]{child.getApplicationId(), child.getId()});
            response = Response.created((URI)ref);
        } else {
            response = Response.status((Response.Status)Response.Status.CREATED);
        }
        return response.entity((Object)TaskTransformer.taskSummary(added.task())).build();
    }

    public List<TaskSummary> listTasks(String applicationId, String entityId) {
        EntityLocal entity = this.brooklyn().getEntity(applicationId, entityId);
        Set tasks = BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.mgmt().getExecutionManager(), (Entity)entity);
        return new LinkedList<TaskSummary>(Collections2.transform((Collection)tasks, TaskTransformer.FROM_TASK));
    }

    public TaskSummary getTask(String application, String entityToken, String taskId) {
        Task t = this.mgmt().getExecutionManager().getTask(taskId);
        if (t == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s'", taskId);
        }
        return (TaskSummary)TaskTransformer.FROM_TASK.apply((Object)t);
    }

    public List<Object> listTags(String applicationId, String entityId) {
        EntityLocal entity = this.brooklyn().getEntity(applicationId, entityId);
        return (List)this.getValueForDisplay(MutableList.copyOf((Iterable)entity.tags().getTags()), true, true);
    }

    public Response getIcon(String applicationId, String entityId) {
        EntityLocal entity = this.brooklyn().getEntity(applicationId, entityId);
        String url = entity.getIconUrl();
        if (url == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.brooklyn().isUrlServerSideAndSafe(url)) {
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            InputStream content = ResourceUtils.create((Object)this.brooklyn().getCatalogClassLoader()).getResourceFromUrl(url);
            return Response.ok((Object)content, (MediaType)mime).build();
        }
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }

    public Response rename(String application, String entity, String newName) {
        EntityLocal entityLocal = this.brooklyn().getEntity(application, entity);
        entityLocal.setDisplayName(newName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public Response expunge(String application, String entity, boolean release) {
        EntityLocal entityLocal = this.brooklyn().getEntity(application, entity);
        Task<?> task = this.brooklyn().expunge((Entity)entityLocal, release);
        TaskSummary summary = (TaskSummary)TaskTransformer.FROM_TASK.apply(task);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)summary).build();
    }

    public List<EntitySummary> getDescendants(String application, String entity, String typeRegex) {
        return EntityTransformer.entitySummaries(this.brooklyn().descendantsOfType(application, entity, typeRegex));
    }

    public Map<String, Object> getDescendantsSensor(String application, String entity, String sensor, String typeRegex) {
        Iterable<Entity> descs = this.brooklyn().descendantsOfType(application, entity, typeRegex);
        return ApplicationResource.getSensorMap(sensor, descs);
    }

    public List<LocationSummary> getLocations(String application, String entity) {
        ArrayList result = Lists.newArrayList();
        EntityLocal e = this.brooklyn().getEntity(application, entity);
        for (Location l : e.getLocations()) {
            result.add(LocationTransformer.newInstance(this.mgmt(), l, LocationTransformer.LocationDetailLevel.NONE));
        }
        return result;
    }

    public String getSpec(String applicationToken, String entityToken) {
        EntityLocal entity = this.brooklyn().getEntity(applicationToken, entityToken);
        BrooklynTags.NamedStringTag spec = BrooklynTags.findFirst((String)"yaml_spec", (Iterable)entity.tags().getTags());
        if (spec == null) {
            return null;
        }
        return (String)this.getValueForDisplay(spec.getContents(), true, true);
    }
}

