/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.rest.api.EntityConfigApi;
import brooklyn.rest.domain.EntityConfigSummary;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.EntityTransformer;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class EntityConfigResource
extends AbstractBrooklynRestResource
implements EntityConfigApi {
    private static final Logger LOG = LoggerFactory.getLogger(EntityConfigResource.class);

    public List<EntityConfigSummary> list(String application, String entityToken) {
        final EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)entity.getEntityType().getConfigKeys(), (Function)new Function<ConfigKey<?>, EntityConfigSummary>(){

            public EntityConfigSummary apply(ConfigKey<?> config) {
                return EntityTransformer.entityConfigSummary(entity, config);
            }
        }));
    }

    public Map<String, Object> batchConfigRead(String application, String entityToken, Boolean raw) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        Map source = ((EntityInternal)entity).config().getBag().getAllConfigAsConfigKeyMap();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry ek : source.entrySet()) {
            Object value = ek.getValue();
            if (Boolean.FALSE.equals(raw)) {
                value = RendererHints.applyDisplayValueHint((ConfigKey)((ConfigKey)ek.getKey()), value);
            }
            result.put(((ConfigKey)ek.getKey()).getName(), this.getValueForDisplay(value, true, false));
        }
        return result;
    }

    public Object get(String application, String entityToken, String configKeyName, Boolean raw) {
        return this.get(true, application, entityToken, configKeyName, raw);
    }

    public String getPlain(String application, String entityToken, String configKeyName, Boolean raw) {
        return Strings.toString((Object)this.get(false, application, entityToken, configKeyName, raw));
    }

    public Object get(boolean preferJson, String application, String entityToken, String configKeyName, Boolean raw) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        ConfigKey<?> ck = this.findConfig(entity, configKeyName);
        Object value = ((EntityInternal)entity).config().getRaw(ck).orNull();
        if (Boolean.FALSE.equals(raw)) {
            value = RendererHints.applyDisplayValueHint(ck, (Object)value);
        }
        return this.getValueForDisplay(value, preferJson, true);
    }

    private ConfigKey<?> findConfig(EntityLocal entity, String configKeyName) {
        ConfigKey ck = entity.getEntityType().getConfigKey(configKeyName);
        if (ck == null) {
            ck = new BasicConfigKey(Object.class, configKeyName);
        }
        return ck;
    }

    public void setFromMap(String application, String entityToken, Boolean recurse, Map newValues) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("REST user " + Entitlements.getEntitlementContext() + " setting configs " + newValues);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            String configName = Strings.toString(entry.getKey());
            Object newValue = entry.getValue();
            ConfigKey<?> ck = this.findConfig(entity, configName);
            ((EntityInternal)entity).config().set(ck, TypeCoercions.coerce(newValue, (TypeToken)ck.getTypeToken()));
            if (!Boolean.TRUE.equals(recurse)) continue;
            for (Entity e2 : Entities.descendants((Entity)entity, (Predicate)Predicates.alwaysTrue(), (boolean)false)) {
                ((EntityInternal)e2).config().set(ck, newValue);
            }
        }
    }

    public void set(String application, String entityToken, String configName, Boolean recurse, Object newValue) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        ConfigKey<?> ck = this.findConfig(entity, configName);
        LOG.debug("REST setting config " + configName + " on " + entity + " to " + newValue);
        ((EntityInternal)entity).config().set(ck, TypeCoercions.coerce((Object)newValue, (TypeToken)ck.getTypeToken()));
        if (Boolean.TRUE.equals(recurse)) {
            for (Entity e2 : Entities.descendants((Entity)entity, (Predicate)Predicates.alwaysTrue(), (boolean)false)) {
                ((EntityInternal)e2).config().set(ck, newValue);
            }
        }
    }
}

